/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.navigation;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GHResponse;
import com.graphhopper.ResponsePath;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.navigation.DistanceConfig;
import com.graphhopper.navigation.DistanceUtils;
import com.graphhopper.navigation.ManeuverType;
import com.graphhopper.navigation.VoiceInstructionConfig;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.IntersectionValues;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.shapes.GHPoint3D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigateResponseConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NavigateResponseConverter.class);
    private static final int VOICE_INSTRUCTION_MERGE_TRESHHOLD = 100;

    public static ObjectNode convertFromGHResponse(GHResponse ghResponse, TranslationMap translationMap, Locale locale, DistanceConfig distanceConfig) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        if (ghResponse.hasErrors()) {
            throw new IllegalStateException("If the response has errors, you should use the method NavigateResponseConverter#convertFromGHResponseError");
        }
        PointList waypoints = ghResponse.getBest().getWaypoints();
        ArrayNode routesJson = json.putArray("routes");
        List paths = ghResponse.getAll();
        for (int i = 0; i < paths.size(); ++i) {
            ResponsePath path = (ResponsePath)paths.get(i);
            ObjectNode pathJson = routesJson.addObject();
            NavigateResponseConverter.putRouteInformation(pathJson, path, i, translationMap, locale, distanceConfig);
        }
        ArrayNode waypointsJson = json.putArray("waypoints");
        for (int i = 0; i < waypoints.size(); ++i) {
            ObjectNode waypointJson = waypointsJson.addObject();
            waypointJson.put("name", "");
            NavigateResponseConverter.putLocation(waypoints.getLat(i), waypoints.getLon(i), waypointJson);
        }
        json.put("code", "Ok");
        json.put("uuid", UUID.randomUUID().toString().replaceAll("-", ""));
        return json;
    }

    private static void putRouteInformation(ObjectNode pathJson, ResponsePath path, int routeNr, TranslationMap translationMap, Locale locale, DistanceConfig distanceConfig) {
        InstructionList instructions = path.getInstructions();
        pathJson.put("geometry", ResponsePathSerializer.encodePolyline((PointList)path.getPoints(), (boolean)false, (double)1000000.0));
        ArrayNode legsJson = pathJson.putArray("legs");
        ObjectNode legJson = legsJson.addObject();
        ArrayNode steps = legJson.putArray("steps");
        long time = 0L;
        double distance = 0.0;
        boolean isDepartInstruction = true;
        int pointIndexFrom = 0;
        Map pathDetails = path.getPathDetails();
        List<PathDetail> intersectionDetails = pathDetails.getOrDefault("intersection", Collections.emptyList());
        ObjectNode annotation = null;
        ArrayNode maxSpeedArray = null;
        if (pathDetails.containsKey("max_speed")) {
            annotation = legJson.putObject("annotation");
            maxSpeedArray = annotation.putArray("maxspeed");
        }
        for (int i = 0; i < instructions.size(); ++i) {
            ManeuverType maneuverType;
            ObjectNode stepJson = steps.addObject();
            Instruction instruction = instructions.get(i);
            int pointIndexTo = pointIndexFrom + instruction.getPoints().size();
            if (isDepartInstruction) {
                maneuverType = ManeuverType.DEPART;
                NavigateResponseConverter.fixDepartIntersectionDetail(intersectionDetails, i);
            } else {
                switch (instruction.getSign()) {
                    case 4: 
                    case 5: {
                        maneuverType = ManeuverType.ARRIVE;
                        break;
                    }
                    case 6: {
                        maneuverType = ManeuverType.ROUNDABOUT;
                        break;
                    }
                    default: {
                        maneuverType = ManeuverType.TURN;
                    }
                }
            }
            if (annotation != null) {
                NavigateResponseConverter.putAnnotation(maxSpeedArray, pathDetails, pointIndexFrom, pointIndexTo, distanceConfig.unit);
            }
            NavigateResponseConverter.putInstruction(path.getPoints(), instructions, i, locale, translationMap, stepJson, maneuverType, distanceConfig, intersectionDetails, pointIndexFrom, pointIndexTo);
            pointIndexFrom = pointIndexTo;
            time += instruction.getTime();
            distance += instruction.getDistance();
            isDepartInstruction = false;
            if (maneuverType != ManeuverType.ARRIVE) continue;
            NavigateResponseConverter.putLegInformation(legJson, path, routeNr, time, distance);
            if (instruction.getSign() != 5) continue;
            legJson = legsJson.addObject();
            steps = legJson.putArray("steps");
            if (annotation != null) {
                annotation = legJson.putObject("annotation");
                maxSpeedArray = annotation.putArray("maxspeed");
            }
            isDepartInstruction = true;
            time = 0L;
            distance = 0.0;
        }
        pathJson.put("weight_name", "routability");
        pathJson.put("weight", Helper.round((double)path.getRouteWeight(), (int)1));
        pathJson.put("duration", NavigateResponseConverter.convertToSeconds(path.getTime()));
        pathJson.put("distance", Helper.round((double)path.getDistance(), (int)1));
        pathJson.put("voiceLocale", locale.toLanguageTag());
    }

    private static void putAnnotation(ArrayNode maxSpeedArray, Map<String, List<PathDetail>> pathDetails, int fromIdx, int toIdx, DistanceUtils.Unit metric) {
        List<PathDetail> maxSpeeds = pathDetails.get("max_speed");
        String unitValue = metric == DistanceUtils.Unit.METRIC ? "km/h" : "mph";
        int nextPDIdx = 0;
        if (!maxSpeeds.isEmpty()) {
            int idx = fromIdx;
            while (idx < toIdx) {
                long value;
                PathDetail pd;
                while (nextPDIdx < maxSpeeds.size() && (idx < (pd = maxSpeeds.get(nextPDIdx)).getFirst() || idx > pd.getLast())) {
                    ++nextPDIdx;
                }
                if (nextPDIdx >= maxSpeeds.size()) break;
                pd = maxSpeeds.get(nextPDIdx);
                long l = pd.getValue() == null ? Math.round(150.0) : (value = metric == DistanceUtils.Unit.METRIC ? Math.round(((Number)pd.getValue()).doubleValue()) : Math.round(((Number)pd.getValue()).doubleValue() / 1.609344));
                while (idx <= Math.min(toIdx, pd.getLast())) {
                    ObjectNode object = maxSpeedArray.addObject();
                    object.put("speed", value);
                    object.put("unit", unitValue);
                    ++idx;
                }
            }
        }
    }

    private static void putLegInformation(ObjectNode legJson, ResponsePath path, int i, long time, double distance) {
        Object summary = !path.getDescription().isEmpty() ? String.join((CharSequence)",", path.getDescription()) : "GraphHopper Route " + i;
        legJson.put("summary", (String)summary);
        legJson.put("weight", NavigateResponseConverter.convertToSeconds(time));
        legJson.put("duration", NavigateResponseConverter.convertToSeconds(time));
        legJson.put("distance", Helper.round((double)distance, (int)1));
    }

    private static void fixDepartIntersectionDetail(List<PathDetail> intersectionDetails, int position) {
        if (intersectionDetails.size() < position + 2) {
            return;
        }
        Map departIntersectionMap = (Map)intersectionDetails.get(position).getValue();
        int out = (Integer)departIntersectionMap.get("out");
        departIntersectionMap.put("out", 0);
        List oldBearings = (List)departIntersectionMap.get("bearings");
        ArrayList<Integer> newBearings = new ArrayList<Integer>();
        newBearings.add((Integer)oldBearings.get(out));
        departIntersectionMap.put("bearings", newBearings);
        List oldEntries = (List)departIntersectionMap.get("entries");
        ArrayList<Boolean> newEntries = new ArrayList<Boolean>();
        newEntries.add((Boolean)oldEntries.get(out));
        departIntersectionMap.put("entries", newEntries);
    }

    private static List<PathDetail> filterIntersectionDetails(PointList points, List<PathDetail> intersectionDetails, int pointIndexFrom, int pointIndexTo) {
        PathDetail intersectionDetail;
        int first;
        ArrayList<PathDetail> list = new ArrayList<PathDetail>();
        Iterator<PathDetail> iterator = intersectionDetails.iterator();
        while (iterator.hasNext() && (first = (intersectionDetail = iterator.next()).getFirst()) < pointIndexTo) {
            if (first < pointIndexFrom) continue;
            list.add(intersectionDetail);
        }
        if (list.size() < 2) {
            return list;
        }
        GHPoint3D intersectionPoint = points.get(((PathDetail)list.get(0)).getFirst());
        ArrayList<Integer> duplicates = new ArrayList<Integer>();
        for (int i = 1; i < list.size(); ++i) {
            GHPoint3D currentIntersectionPoint = points.get(((PathDetail)list.get(i)).getFirst());
            if (intersectionPoint.equals((Object)currentIntersectionPoint)) {
                duplicates.add(i - 1);
            }
            intersectionPoint = currentIntersectionPoint;
        }
        for (int dup = duplicates.size() - 1; dup >= 0; --dup) {
            int i = (Integer)duplicates.get(dup);
            try {
                Map intersectionMap = (Map)((PathDetail)list.get(i)).getValue();
                List intersectionValueList = IntersectionValues.createList((Map)intersectionMap);
                Map nextIntersectionMap = (Map)((PathDetail)list.get(i + 1)).getValue();
                List nextIntersectionValueList = IntersectionValues.createList((Map)nextIntersectionMap);
                List mergedInterSectionValueList = Stream.concat(intersectionValueList.stream().filter(x -> !x.out), nextIntersectionValueList.stream().filter(x -> !x.in)).sorted((x, y) -> Integer.compare(x.bearing, y.bearing)).collect(Collectors.toList());
                list.remove(i + 1);
                Map mergedIntersection = IntersectionValues.createIntersection(mergedInterSectionValueList);
                PathDetail mergedPathDetail = new PathDetail((Object)mergedIntersection);
                mergedPathDetail.setFirst(((PathDetail)list.get(i)).getFirst());
                list.set(i, mergedPathDetail);
                continue;
            }
            catch (ClassCastException e) {
                LOGGER.warn("Exception :" + String.valueOf(e));
            }
        }
        return list;
    }

    private static void putInstruction(PointList points, InstructionList instructions, int instructionIndex, Locale locale, TranslationMap translationMap, ObjectNode stepJson, ManeuverType maneuverType, DistanceConfig distanceConfig, List<PathDetail> intersectionDetails, int pointIndexFrom, int pointIndexTo) {
        Instruction instruction = instructions.get(instructionIndex);
        ArrayNode intersections = stepJson.putArray("intersections");
        PointList pointList = instruction.getPoints().clone(false);
        if (maneuverType != ManeuverType.ARRIVE && instructionIndex + 1 < instructions.size()) {
            PointList nextPoints = instructions.get(instructionIndex + 1).getPoints();
            pointList.add(nextPoints.getLat(0), nextPoints.getLon(0), nextPoints.getEle(0));
        } else {
            pointList.add(pointList.getLat(0), pointList.getLon(0), pointList.getEle(0));
            ObjectNode intersection = intersections.addObject();
            ArrayNode entryArray = intersection.putArray("entry");
            entryArray.add(true);
            ArrayNode bearingsArray = intersection.putArray("bearings");
            bearingsArray.add(0);
            intersection.put("in", 0);
            NavigateResponseConverter.putLocation(pointList.getLat(0), pointList.getLon(0), intersection);
        }
        List<PathDetail> filteredIntersectionDetails = NavigateResponseConverter.filterIntersectionDetails(points, intersectionDetails, pointIndexFrom, pointIndexTo);
        for (PathDetail intersectionDetail : filteredIntersectionDetails) {
            ObjectNode intersection = intersections.addObject();
            Map intersectionValue = (Map)intersectionDetail.getValue();
            ArrayNode locationArray = intersection.putArray("location");
            locationArray.add(Helper.round6((double)points.getLon(intersectionDetail.getFirst())));
            locationArray.add(Helper.round6((double)points.getLat(intersectionDetail.getFirst())));
            List entries = intersectionValue.getOrDefault("entries", Collections.emptyList());
            ArrayNode entryArray = intersection.putArray("entry");
            for (Boolean entry : entries) {
                entryArray.add(entry);
            }
            List bearingsList = intersectionValue.getOrDefault("bearings", Collections.emptyList());
            ArrayNode bearingsrray = intersection.putArray("bearings");
            for (Integer bearing : bearingsList) {
                bearingsrray.add(bearing);
            }
            if (intersectionValue.containsKey("in")) {
                intersection.put("in", ((Integer)intersectionValue.get("in")).intValue());
            }
            if (!intersectionValue.containsKey("out")) continue;
            intersection.put("out", ((Integer)intersectionValue.get("out")).intValue());
        }
        stepJson.put("driving_side", "right");
        stepJson.put("geometry", ResponsePathSerializer.encodePolyline((PointList)pointList, (boolean)false, (double)1000000.0));
        stepJson.put("mode", instruction.getSign() == 9 ? "ferry" : distanceConfig.getMode());
        NavigateResponseConverter.putManeuver(instruction, stepJson, locale, translationMap, maneuverType);
        double distance = Helper.round((double)instruction.getDistance(), (int)1);
        stepJson.put("weight", distance);
        stepJson.put("duration", NavigateResponseConverter.convertToSeconds(instruction.getTime()));
        stepJson.put("name", instruction.getName());
        stepJson.put("distance", distance);
        ArrayNode voiceInstructions = stepJson.putArray("voiceInstructions");
        ArrayNode bannerInstructions = stepJson.putArray("bannerInstructions");
        if (instructionIndex + 1 < instructions.size()) {
            NavigateResponseConverter.putVoiceInstructions(instructions, distance, instructionIndex, locale, translationMap, voiceInstructions, distanceConfig);
            NavigateResponseConverter.putBannerInstructions(instructions, distance, instructionIndex, locale, translationMap, bannerInstructions);
        }
    }

    private static void putVoiceInstructions(InstructionList instructions, double distance, int index, Locale locale, TranslationMap translationMap, ArrayNode voiceInstructions, DistanceConfig distanceConfig) {
        Instruction nextInstruction = instructions.get(index + 1);
        String turnDescription = nextInstruction.getTurnDescription(translationMap.getWithFallBack(locale));
        String thenVoiceInstruction = NavigateResponseConverter.getThenVoiceInstructionpart(instructions, index, locale, translationMap);
        List<VoiceInstructionConfig.VoiceInstructionValue> voiceValues = distanceConfig.getVoiceInstructionsForDistance(distance, turnDescription, thenVoiceInstruction);
        for (VoiceInstructionConfig.VoiceInstructionValue voiceValue : voiceValues) {
            NavigateResponseConverter.putSingleVoiceInstruction(voiceValue.spokenDistance, voiceValue.turnDescription, voiceInstructions);
        }
        double distanceAlongGeometry = Helper.round((double)Math.min(distance, 80.0), (int)1);
        if (index + 2 == instructions.size()) {
            distanceAlongGeometry = Helper.round((double)Math.min(distance, 25.0), (int)1);
        }
        NavigateResponseConverter.putSingleVoiceInstruction(distanceAlongGeometry, turnDescription + thenVoiceInstruction, voiceInstructions);
    }

    private static void putSingleVoiceInstruction(double distanceAlongGeometry, String turnDescription, ArrayNode voiceInstructions) {
        ObjectNode voiceInstruction = voiceInstructions.addObject();
        voiceInstruction.put("distanceAlongGeometry", distanceAlongGeometry);
        voiceInstruction.put("announcement", turnDescription);
        voiceInstruction.put("ssmlAnnouncement", "<speak><amazon:effect name=\"drc\"><prosody rate=\"1.08\">" + turnDescription + "</prosody></amazon:effect></speak>");
    }

    private static String getThenVoiceInstructionpart(InstructionList instructions, int index, Locale locale, TranslationMap translationMap) {
        Instruction secondInstruction;
        Instruction firstInstruction;
        if (instructions.size() > index + 2 && (firstInstruction = instructions.get(index + 1)).getDistance() < 100.0 && (secondInstruction = instructions.get(index + 2)).getSign() != 5) {
            return ", " + translationMap.getWithFallBack(locale).tr("navigate.then", new Object[0]) + " " + secondInstruction.getTurnDescription(translationMap.getWithFallBack(locale));
        }
        return "";
    }

    private static void putBannerInstructions(InstructionList instructions, double distance, int index, Locale locale, TranslationMap translationMap, ArrayNode bannerInstructions) {
        ObjectNode bannerInstruction = bannerInstructions.addObject();
        bannerInstruction.put("distanceAlongGeometry", distance);
        ObjectNode primary = bannerInstruction.putObject("primary");
        NavigateResponseConverter.putSingleBannerInstruction(instructions.get(index + 1), locale, translationMap, primary);
        bannerInstruction.putNull("secondary");
        if (instructions.size() > index + 2 && instructions.get(index + 2).getSign() != 5) {
            ObjectNode sub = bannerInstruction.putObject("sub");
            NavigateResponseConverter.putSingleBannerInstruction(instructions.get(index + 2), locale, translationMap, sub);
        }
    }

    private static void putSingleBannerInstruction(Instruction instruction, Locale locale, TranslationMap translationMap, ObjectNode singleBannerInstruction) {
        String bannerInstructionName = instruction.getName();
        if (bannerInstructionName.isEmpty()) {
            bannerInstructionName = instruction.getTurnDescription(translationMap.getWithFallBack(locale));
            bannerInstructionName = Helper.firstBig((String)bannerInstructionName);
        }
        singleBannerInstruction.put("text", bannerInstructionName);
        ArrayNode components = singleBannerInstruction.putArray("components");
        ObjectNode component = components.addObject();
        component.put("text", bannerInstructionName);
        component.put("type", "text");
        singleBannerInstruction.put("type", NavigateResponseConverter.getTurnType(instruction));
        String modifier = NavigateResponseConverter.getModifier(instruction);
        if (modifier != null) {
            singleBannerInstruction.put("modifier", modifier);
        }
        if (instruction.getSign() == 6 && instruction instanceof RoundaboutInstruction) {
            double turnAngle = ((RoundaboutInstruction)instruction).getTurnAngle();
            if (Double.isNaN(turnAngle)) {
                singleBannerInstruction.putNull("degrees");
            } else {
                double degree = Math.abs(turnAngle) * 180.0 / Math.PI;
                singleBannerInstruction.put("degrees", Math.round(degree));
            }
        }
    }

    private static void putManeuver(Instruction instruction, ObjectNode instructionJson, Locale locale, TranslationMap translationMap, ManeuverType maneuverType) {
        ObjectNode maneuver = instructionJson.putObject("maneuver");
        maneuver.put("bearing_after", 0);
        maneuver.put("bearing_before", 0);
        PointList points = instruction.getPoints();
        NavigateResponseConverter.putLocation(points.getLat(0), points.getLon(0), maneuver);
        switch (maneuverType) {
            case ARRIVE: {
                maneuver.put("type", "arrive");
                break;
            }
            case DEPART: {
                maneuver.put("type", "depart");
                break;
            }
            case ROUNDABOUT: {
                maneuver.put("type", "roundabout");
                maneuver.put("exit", ((RoundaboutInstruction)instruction).getExitNumber());
                break;
            }
            default: {
                maneuver.put("type", "turn");
            }
        }
        String modifier = NavigateResponseConverter.getModifier(instruction);
        if (modifier != null) {
            maneuver.put("modifier", modifier);
        }
        maneuver.put("instruction", instruction.getTurnDescription(translationMap.getWithFallBack(locale)));
    }

    private static String getTurnType(Instruction instruction) {
        switch (instruction.getSign()) {
            case 4: 
            case 5: {
                return "arrive";
            }
            case 6: {
                return "roundabout";
            }
        }
        return "turn";
    }

    private static String getModifier(Instruction instruction) {
        switch (instruction.getSign()) {
            case 0: {
                return "straight";
            }
            case -98: 
            case -8: 
            case 8: {
                return "uturn";
            }
            case -7: 
            case -1: {
                return "slight left";
            }
            case -2: {
                return "left";
            }
            case -3: {
                return "sharp left";
            }
            case 1: 
            case 7: {
                return "slight right";
            }
            case 2: {
                return "right";
            }
            case 3: {
                return "sharp right";
            }
            case 6: {
                return "right";
            }
        }
        return null;
    }

    private static ObjectNode putLocation(double lat, double lon, ObjectNode node) {
        ArrayNode location = node.putArray("location");
        location.add(Helper.round6((double)lon));
        location.add(Helper.round6((double)lat));
        return node;
    }

    private static double convertToSeconds(double milliSeconds) {
        return Helper.round((double)(milliSeconds / 1000.0), (int)1);
    }

    public static ObjectNode convertFromGHResponseError(GHResponse ghResponse) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.put("code", "InvalidInput");
        json.put("message", ((Throwable)ghResponse.getErrors().get(0)).getMessage());
        return json;
    }
}

