/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.DateParseError;
import com.conveyal.gtfs.error.EmptyFieldError;
import com.conveyal.gtfs.error.MissingColumnError;
import com.conveyal.gtfs.error.MissingTableError;
import com.conveyal.gtfs.error.NumberParseError;
import com.conveyal.gtfs.error.RangeError;
import com.conveyal.gtfs.error.ReferentialIntegrityError;
import com.conveyal.gtfs.error.TableInSubdirectoryError;
import com.conveyal.gtfs.error.TimeParseError;
import com.conveyal.gtfs.error.URLParseError;
import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Entity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -3576441868127607448L;
    public static final int INT_MISSING = Integer.MIN_VALUE;
    public long sourceFileLine;
    transient GTFSFeed feed;

    private static final String human(long n) {
        if (n >= 1000000L) {
            return String.format(Locale.getDefault(), "%.1fM", (double)n / 1000000.0);
        }
        if (n >= 1000L) {
            return String.format(Locale.getDefault(), "%.1fk", (double)n / 1000.0);
        }
        return String.format(Locale.getDefault(), "%d", n);
    }

    public static abstract class Writer<E extends Entity> {
        private static final Logger LOG = LoggerFactory.getLogger(Writer.class);
        protected final GTFSFeed feed;
        protected final String tableName;
        protected CsvWriter writer;
        protected long row;

        protected Writer(GTFSFeed feed, String tableName) {
            this.feed = feed;
            this.tableName = tableName;
        }

        protected abstract void writeHeaders() throws IOException;

        protected abstract void writeOneRow(E var1) throws IOException;

        protected abstract Iterator<E> iterator();

        public void writeTable(ZipOutputStream zip) throws IOException {
            LOG.info("Writing GTFS table {}", (Object)this.tableName);
            ZipEntry zipEntry = new ZipEntry(this.tableName + ".txt");
            zip.putNextEntry(zipEntry);
            UncloseableOutputStream protectedOut = new UncloseableOutputStream(zip);
            this.writer = new CsvWriter((OutputStream)protectedOut, ',', Charset.forName("UTF8"));
            this.writeHeaders();
            this.row = 0L;
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                if (++this.row % 500000L == 0L) {
                    LOG.info("Record number {}", (Object)Entity.human(this.row));
                }
                this.writeOneRow((Entity)iter.next());
            }
            this.writer.flush();
            zip.closeEntry();
            LOG.info("Wrote {} rows", (Object)Entity.human(this.row));
        }

        protected void writeStringField(String str) throws IOException {
            this.writer.write(str);
        }

        protected void writeUrlField(URL obj) throws IOException {
            this.writeStringField(obj != null ? obj.toString() : "");
        }

        protected void writeDateField(LocalDate d) throws IOException {
            this.writeStringField(d.format(DateTimeFormatter.BASIC_ISO_DATE));
        }

        protected void writeTimeField(int secsSinceMidnight) throws IOException {
            if (secsSinceMidnight == Integer.MIN_VALUE) {
                this.writeStringField("");
                return;
            }
            this.writeStringField(Writer.convertToGtfsTime(secsSinceMidnight));
        }

        public static String convertToGtfsTime(int secsSinceMidnight) {
            int seconds = secsSinceMidnight % 60;
            int minutes = (secsSinceMidnight -= seconds) % 3600;
            return String.format(Locale.getDefault(), "%02d:%02d:%02d", (secsSinceMidnight -= minutes) / 3600, minutes / 60, seconds);
        }

        protected void writeIntField(Integer val) throws IOException {
            if (val.equals(Integer.MIN_VALUE)) {
                this.writeStringField("");
            } else {
                this.writeStringField(val.toString());
            }
        }

        protected void writeDoubleField(double val) throws IOException {
            if (Double.isNaN(val)) {
                this.writeStringField("");
            } else {
                this.writeStringField(String.format(Locale.US, "%.7f", val));
            }
        }

        public void endRecord() throws IOException {
            this.writer.endRecord();
        }
    }

    private static class UncloseableOutputStream
    extends FilterOutputStream {
        public UncloseableOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() {
        }
    }

    public static abstract class Loader<E extends Entity> {
        private static final Logger LOG = LoggerFactory.getLogger(Loader.class);
        protected final GTFSFeed feed;
        protected final String tableName;
        protected final Set<String> missingRequiredColumns = new HashSet<String>();
        protected CsvReader reader;
        protected long row;

        public Loader(GTFSFeed feed, String tableName) {
            this.feed = feed;
            this.tableName = tableName;
        }

        protected boolean checkRangeInclusive(double min, double max, double actual) {
            if (actual < min || actual > max) {
                this.feed.errors.add(new RangeError(this.tableName, this.row, null, min, max, actual));
                return false;
            }
            return true;
        }

        private String getFieldCheckRequired(String column, boolean required) throws IOException {
            String str = this.reader.get(column);
            if (str == null) {
                if (!this.missingRequiredColumns.contains(column)) {
                    this.feed.errors.add(new MissingColumnError(this.tableName, column));
                    this.missingRequiredColumns.add(column);
                }
            } else if (str.isEmpty()) {
                if (required) {
                    this.feed.errors.add(new EmptyFieldError(this.tableName, this.row, column));
                }
                str = null;
            }
            return str;
        }

        protected String getStringField(String column, boolean required) throws IOException {
            return this.getFieldCheckRequired(column, required);
        }

        protected int getIntField(String column, boolean required, int min, int max) throws IOException {
            return this.getIntField(column, required, min, max, 0);
        }

        protected int getIntField(String column, boolean required, int min, int max, int defaultValue) throws IOException {
            Map<Integer, Integer> mapping = null;
            return this.getIntField(column, required, min, max, defaultValue, mapping);
        }

        protected int getIntField(String column, boolean required, int min, int max, int defaultValue, Map<Integer, Integer> mapping) throws IOException {
            String str = this.getFieldCheckRequired(column, required);
            int val = Integer.MIN_VALUE;
            if (str == null) {
                val = defaultValue;
            } else {
                try {
                    Integer mappedVal;
                    val = Integer.parseInt(str);
                    if (mapping != null && (mappedVal = mapping.get(val)) != null) {
                        val = mappedVal;
                    }
                    this.checkRangeInclusive(min, max, val);
                }
                catch (NumberFormatException nfe) {
                    this.feed.errors.add(new NumberParseError(this.tableName, this.row, column));
                }
            }
            return val;
        }

        protected int getTimeField(String column, boolean required) throws IOException {
            String str = this.getFieldCheckRequired(column, required);
            int val = Integer.MIN_VALUE;
            if (str != null) {
                String[] fields = str.split(":");
                if (fields.length != 3) {
                    this.feed.errors.add(new TimeParseError(this.tableName, this.row, column));
                } else {
                    try {
                        int hours = Integer.parseInt(fields[0]);
                        int minutes = Integer.parseInt(fields[1]);
                        int seconds = Integer.parseInt(fields[2]);
                        this.checkRangeInclusive(0.0, 72.0, hours);
                        this.checkRangeInclusive(0.0, 59.0, minutes);
                        this.checkRangeInclusive(0.0, 59.0, seconds);
                        val = hours * 60 * 60 + minutes * 60 + seconds;
                    }
                    catch (NumberFormatException nfe) {
                        this.feed.errors.add(new TimeParseError(this.tableName, this.row, column));
                    }
                }
            }
            return val;
        }

        protected LocalDate getDateField(String column, boolean required) throws IOException {
            String str = this.getFieldCheckRequired(column, required);
            LocalDate dateTime = null;
            if (str != null) {
                try {
                    dateTime = LocalDate.parse(str, DateTimeFormatter.BASIC_ISO_DATE);
                    this.checkRangeInclusive(2000.0, 2100.0, dateTime.getYear());
                }
                catch (IllegalArgumentException iae) {
                    this.feed.errors.add(new DateParseError(this.tableName, this.row, column));
                }
            }
            return dateTime;
        }

        protected URL getUrlField(String column, boolean required) throws IOException {
            String str = this.getFieldCheckRequired(column, required);
            URL url = null;
            if (str != null) {
                try {
                    url = new URL(str);
                }
                catch (MalformedURLException mue) {
                    this.feed.errors.add(new URLParseError(this.tableName, this.row, column));
                }
            }
            return url;
        }

        protected double getDoubleField(String column, boolean required, double min, double max) throws IOException {
            String str = this.getFieldCheckRequired(column, required);
            double val = Double.NaN;
            if (str != null) {
                try {
                    val = Double.parseDouble(str);
                    this.checkRangeInclusive(min, max, val);
                }
                catch (NumberFormatException nfe) {
                    this.feed.errors.add(new NumberParseError(this.tableName, this.row, column));
                }
            }
            return val;
        }

        protected <K, V> V getRefField(String column, boolean required, Map<K, V> target) throws IOException {
            String str = this.getFieldCheckRequired(column, required);
            V val = null;
            if (str != null && (val = (V)target.get(str)) == null) {
                this.feed.errors.add(new ReferentialIntegrityError(this.tableName, this.row, column, str));
            }
            return val;
        }

        protected abstract boolean isRequired();

        protected abstract void loadOneRow() throws IOException;

        public void loadTable(File zipOrDirectory) throws IOException {
            CsvReader reader;
            InputStream zis;
            if (zipOrDirectory.isDirectory()) {
                Path path = zipOrDirectory.toPath().resolve(this.tableName + ".txt");
                if (!path.toFile().exists()) {
                    this.missing();
                    return;
                }
                zis = new FileInputStream(path.toFile());
                LOG.info("Loading GTFS table {} from {}", (Object)this.tableName, (Object)path);
            } else {
                ZipFile zip = new ZipFile(zipOrDirectory);
                ZipEntry entry = zip.getEntry(this.tableName + ".txt");
                if (entry == null) {
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry e = entries.nextElement();
                        if (!e.getName().endsWith(this.tableName + ".txt")) continue;
                        entry = e;
                        this.feed.errors.add(new TableInSubdirectoryError(this.tableName, entry.getName().replace(this.tableName + ".txt", "")));
                    }
                    this.missing();
                    if (entry == null) {
                        return;
                    }
                }
                zis = zip.getInputStream(entry);
                LOG.info("Loading GTFS table {} from {}", (Object)this.tableName, (Object)entry);
            }
            BOMInputStream bis = new BOMInputStream(zis);
            this.reader = reader = new CsvReader((InputStream)bis, ',', Charset.forName("UTF8"));
            reader.readHeaders();
            while (reader.readRecord()) {
                if (++this.row % 500000L == 0L) {
                    LOG.info("Record number {}", (Object)Entity.human(this.row));
                }
                this.loadOneRow();
            }
        }

        private void missing() {
            if (this.isRequired()) {
                this.feed.errors.add(new MissingTableError(this.tableName));
            } else {
                LOG.info("Table {} was missing but it is not required.", (Object)this.tableName);
            }
        }
    }
}

