/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.gtfs.GtfsReader;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.PtEdgeAttributes;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.EdgeIterator;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;

public class PtGraph
implements GtfsReader.PtGraphOut {
    private final DataAccess nodes;
    private final int nodeEntryBytes;
    private final Directory dir;
    private int nodeCount;
    private final DataAccess edges;
    private final int E_NODEA;
    private final int E_NODEB;
    private final int E_LINKA;
    private final int E_LINKB;
    private final int E_ATTRS;
    private final int edgeEntryBytes;
    private int edgeCount;
    private final DataAccess attrs;
    private static final GtfsStorage.EdgeType[] edgeTypeValues = GtfsStorage.EdgeType.values();
    int nextNode = 0;
    long currentPointer = 0L;
    Map<GtfsStorage.Validity, Integer> validities = new HashMap<GtfsStorage.Validity, Integer>();
    List<GtfsStorage.Validity> validityList = new ArrayList<GtfsStorage.Validity>();
    Map<GtfsStorage.PlatformDescriptor, Integer> platformDescriptors = new HashMap<GtfsStorage.PlatformDescriptor, Integer>();
    List<GtfsStorage.PlatformDescriptor> platformDescriptorList = new ArrayList<GtfsStorage.PlatformDescriptor>();
    Map<GtfsRealtime.TripDescriptor, Integer> tripDescriptors = new HashMap<GtfsRealtime.TripDescriptor, Integer>();
    List<GtfsRealtime.TripDescriptor> tripDescriptorList = new ArrayList<GtfsRealtime.TripDescriptor>();
    Map<GtfsStorage.FeedIdWithTimezone, Integer> feedIdWithTimezones = new HashMap<GtfsStorage.FeedIdWithTimezone, Integer>();
    List<GtfsStorage.FeedIdWithTimezone> feedIdWithTimezoneList = new ArrayList<GtfsStorage.FeedIdWithTimezone>();

    public PtGraph(Directory dir, int firstNode) {
        this.dir = dir;
        this.nextNode = firstNode;
        this.nodes = dir.create("pt_nodes", dir.getDefaultType("pt_nodes", true), -1);
        this.edges = dir.create("pt_edges", dir.getDefaultType("pt_edges", true), -1);
        this.attrs = dir.create("pt_edge_attrs", dir.getDefaultType("pt_edge_attrs", true), -1);
        this.nodeEntryBytes = 8;
        this.E_NODEA = 0;
        this.E_NODEB = 4;
        this.E_LINKA = 8;
        this.E_LINKB = 12;
        this.E_ATTRS = 16;
        this.edgeEntryBytes = this.E_ATTRS + 8;
    }

    public void create(long initSize) {
        this.nodes.create(initSize);
        this.edges.create(initSize);
        this.attrs.create(initSize);
    }

    public boolean loadExisting() {
        if (!(this.nodes.loadExisting() && this.edges.loadExisting() && this.attrs.loadExisting())) {
            return false;
        }
        this.nodeCount = this.nodes.getHeader(8);
        this.edgeCount = this.edges.getHeader(8);
        try {
            this.deserializeExtraStuff();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public void flush() {
        this.nodes.setHeader(8, this.nodeCount);
        this.edges.setHeader(8, this.edgeCount);
        this.edges.flush();
        this.nodes.flush();
        this.attrs.flush();
        try {
            this.serializeExtraStuff();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.edges.close();
        this.nodes.close();
        this.attrs.flush();
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    public boolean isClosed() {
        assert (this.nodes.isClosed() == this.edges.isClosed());
        return this.nodes.isClosed();
    }

    public int addEdge(int nodeA, int nodeB, long attrPointer) {
        if (this.edgeCount == Integer.MAX_VALUE) {
            throw new IllegalStateException("Maximum edge count exceeded: " + this.edgeCount);
        }
        this.ensureNodeCapacity(Math.max(nodeA, nodeB));
        int edge = this.edgeCount;
        long edgePointer = (long)this.edgeCount * (long)this.edgeEntryBytes;
        ++this.edgeCount;
        this.edges.ensureCapacity((long)this.edgeCount * (long)this.edgeEntryBytes);
        this.setNodeA(edgePointer, nodeA);
        this.setNodeB(edgePointer, nodeB);
        this.setAttrPointer(edgePointer, attrPointer);
        long nodePointerA = this.toNodePointer(nodeA);
        int edgeRefA = this.getEdgeRefOut(nodePointerA);
        this.setLinkA(edgePointer, edgeRefA >= 0 ? edgeRefA : -1);
        this.setEdgeRefOut(nodePointerA, edge);
        if (nodeA != nodeB) {
            long nodePointerB = this.toNodePointer(nodeB);
            int edgeRefB = this.getEdgeRefIn(nodePointerB);
            this.setLinkB(edgePointer, EdgeIterator.Edge.isValid((int)edgeRefB) ? edgeRefB : -1);
            this.setEdgeRefIn(nodePointerB, edge);
        }
        return edge;
    }

    public void ensureNodeCapacity(int node) {
        if (node < this.nodeCount) {
            return;
        }
        int oldNodes = this.nodeCount;
        this.nodeCount = node + 1;
        this.nodes.ensureCapacity((long)this.nodeCount * (long)this.nodeEntryBytes);
        for (int n = oldNodes; n < this.nodeCount; ++n) {
            this.setEdgeRefOut(this.toNodePointer(n), -1);
            this.setEdgeRefIn(this.toNodePointer(n), -1);
        }
    }

    public long toNodePointer(int node) {
        if (node < 0 || node >= this.nodeCount) {
            throw new IllegalArgumentException("node: " + node + " out of bounds [0," + this.nodeCount + "[");
        }
        return (long)node * (long)this.nodeEntryBytes;
    }

    public long toEdgePointer(int edge) {
        if (edge < 0 || edge >= this.edgeCount) {
            throw new IllegalArgumentException("edge: " + edge + " out of bounds [0," + this.edgeCount + "[");
        }
        return (long)edge * (long)this.edgeEntryBytes;
    }

    public void setNodeA(long edgePointer, int nodeA) {
        this.edges.setInt(edgePointer + (long)this.E_NODEA, nodeA);
    }

    private void setAttrPointer(long edgePointer, long attrPointer) {
        this.edges.setInt(edgePointer + (long)this.E_ATTRS, this.getIntLow(attrPointer));
        this.edges.setInt(edgePointer + (long)this.E_ATTRS + 4L, this.getIntHigh(attrPointer));
    }

    private long getAttrPointer(long edgePointer) {
        return this.combineIntsToLong(this.edges.getInt(edgePointer + (long)this.E_ATTRS), this.edges.getInt(edgePointer + (long)this.E_ATTRS + 4L));
    }

    final int getIntLow(long longValue) {
        return (int)(longValue & 0xFFFFFFFFL);
    }

    final int getIntHigh(long longValue) {
        return (int)(longValue >> 32);
    }

    final long combineIntsToLong(int intLow, int intHigh) {
        return (long)intHigh << 32 | (long)intLow & 0xFFFFFFFFL;
    }

    public void setNodeB(long edgePointer, int nodeB) {
        this.edges.setInt(edgePointer + (long)this.E_NODEB, nodeB);
    }

    public void setLinkA(long edgePointer, int linkA) {
        this.edges.setInt(edgePointer + (long)this.E_LINKA, linkA);
    }

    public void setLinkB(long edgePointer, int linkB) {
        this.edges.setInt(edgePointer + (long)this.E_LINKB, linkB);
    }

    public int getNodeA(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_NODEA);
    }

    public int getNodeB(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_NODEB);
    }

    public int getLinkA(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_LINKA);
    }

    public int getLinkB(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_LINKB);
    }

    public void setEdgeRefOut(long nodePointer, int edgeRef) {
        this.nodes.setInt(nodePointer, edgeRef);
    }

    public void setEdgeRefIn(long nodePointer, int edgeRef) {
        this.nodes.setInt(nodePointer + 4L, edgeRef);
    }

    public int getEdgeRefOut(long nodePointer) {
        return this.nodes.getInt(nodePointer);
    }

    public int getEdgeRefIn(long nodePointer) {
        return this.nodes.getInt(nodePointer + 4L);
    }

    private void serializeExtraStuff() throws IOException {
        try (ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.dir.getLocation() + "/pt_extra"));){
            os.writeObject(this.validityList);
            os.writeObject(this.platformDescriptorList);
            os.writeObject(this.tripDescriptorList);
            os.writeObject(this.feedIdWithTimezoneList);
        }
    }

    private void deserializeExtraStuff() throws IOException, ClassNotFoundException {
        try (ObjectInputStream is = new ObjectInputStream(new FileInputStream(this.dir.getLocation() + "/pt_extra"));){
            this.validityList = (List)is.readObject();
            this.platformDescriptorList = (List)is.readObject();
            this.tripDescriptorList = (List)is.readObject();
            this.feedIdWithTimezoneList = (List)is.readObject();
        }
    }

    @Override
    public int createEdge(int src, int dest, PtEdgeAttributes attrs) {
        this.attrs.ensureCapacity(this.currentPointer + 10000L);
        int edge = this.addEdge(src, dest, this.currentPointer);
        this.attrs.setInt(this.currentPointer, attrs.type.ordinal());
        this.currentPointer += 4L;
        this.attrs.setInt(this.currentPointer, attrs.time);
        this.currentPointer += 4L;
        switch (attrs.type) {
            case ENTER_PT: {
                this.attrs.setInt(this.currentPointer, attrs.route_type);
                this.currentPointer += 4L;
                this.attrs.setInt(this.currentPointer, this.sharePlatformDescriptor(attrs.platformDescriptor).intValue());
                this.currentPointer += 4L;
                break;
            }
            case EXIT_PT: {
                this.attrs.setInt(this.currentPointer, this.sharePlatformDescriptor(attrs.platformDescriptor).intValue());
                this.currentPointer += 4L;
                break;
            }
            case ENTER_TIME_EXPANDED_NETWORK: {
                this.attrs.setInt(this.currentPointer, this.shareFeedIdWithTimezone(attrs.feedIdWithTimezone).intValue());
                this.currentPointer += 4L;
                break;
            }
            case LEAVE_TIME_EXPANDED_NETWORK: {
                this.attrs.setInt(this.currentPointer, this.shareFeedIdWithTimezone(attrs.feedIdWithTimezone).intValue());
                this.currentPointer += 4L;
                break;
            }
            case BOARD: {
                this.attrs.setInt(this.currentPointer, attrs.stop_sequence);
                this.currentPointer += 4L;
                this.attrs.setInt(this.currentPointer, this.shareTripDescriptor(attrs.tripDescriptor));
                this.currentPointer += 4L;
                this.attrs.setInt(this.currentPointer, this.shareValidity(attrs.validity));
                this.currentPointer += 4L;
                this.attrs.setInt(this.currentPointer, attrs.transfers);
                this.currentPointer += 4L;
                break;
            }
            case ALIGHT: {
                this.attrs.setInt(this.currentPointer, attrs.stop_sequence);
                this.currentPointer += 4L;
                this.attrs.setInt(this.currentPointer, this.shareTripDescriptor(attrs.tripDescriptor));
                this.currentPointer += 4L;
                this.attrs.setInt(this.currentPointer, this.shareValidity(attrs.validity));
                this.currentPointer += 4L;
                break;
            }
            case WAIT: {
                break;
            }
            case WAIT_ARRIVAL: {
                break;
            }
            case OVERNIGHT: {
                break;
            }
            case HOP: {
                this.attrs.setInt(this.currentPointer, attrs.stop_sequence);
                this.currentPointer += 4L;
                break;
            }
            case DWELL: {
                break;
            }
            case TRANSFER: {
                this.attrs.setInt(this.currentPointer, attrs.route_type);
                this.currentPointer += 4L;
                this.attrs.setInt(this.currentPointer, this.sharePlatformDescriptor(attrs.platformDescriptor).intValue());
                this.currentPointer += 4L;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return edge;
    }

    private int shareValidity(GtfsStorage.Validity validity) {
        Integer validityId = this.validities.get(validity);
        if (validityId == null) {
            validityId = this.validityList.size();
            this.validities.put(validity, validityId);
            this.validityList.add(validity);
        }
        return validityId;
    }

    private int shareTripDescriptor(GtfsRealtime.TripDescriptor tripDescriptor) {
        Integer tripDescriptorId = this.tripDescriptors.get(tripDescriptor);
        if (tripDescriptorId == null) {
            tripDescriptorId = this.tripDescriptorList.size();
            this.tripDescriptors.put(tripDescriptor, tripDescriptorId);
            this.tripDescriptorList.add(tripDescriptor);
        }
        return tripDescriptorId;
    }

    private Integer shareFeedIdWithTimezone(GtfsStorage.FeedIdWithTimezone feedIdWithTimezone1) {
        Integer feedIdWithTimezone = this.feedIdWithTimezones.get(feedIdWithTimezone1);
        if (feedIdWithTimezone == null) {
            feedIdWithTimezone = this.feedIdWithTimezoneList.size();
            this.feedIdWithTimezones.put(feedIdWithTimezone1, feedIdWithTimezone);
            this.feedIdWithTimezoneList.add(feedIdWithTimezone1);
        }
        return feedIdWithTimezone;
    }

    private Integer sharePlatformDescriptor(GtfsStorage.PlatformDescriptor platformDescriptor) {
        Integer platformDescriptorId = this.platformDescriptors.get(platformDescriptor);
        if (platformDescriptorId == null) {
            platformDescriptorId = this.platformDescriptorList.size();
            this.platformDescriptors.put(platformDescriptor, platformDescriptorId);
            this.platformDescriptorList.add(platformDescriptor);
        }
        return platformDescriptorId;
    }

    @Override
    public int createNode() {
        return this.nextNode++;
    }

    public Iterable<PtEdge> edgesAround(final int baseNode) {
        Spliterators.AbstractSpliterator<PtEdge> spliterator = new Spliterators.AbstractSpliterator<PtEdge>(0L, 0){
            int edgeId;
            {
                super(arg0, arg1);
                this.edgeId = PtGraph.this.getEdgeRefOut(PtGraph.this.toNodePointer(baseNode));
            }

            @Override
            public boolean tryAdvance(Consumer<? super PtEdge> action) {
                if (this.edgeId < 0) {
                    return false;
                }
                long edgePointer = PtGraph.this.toEdgePointer(this.edgeId);
                int nodeA = PtGraph.this.getNodeA(edgePointer);
                int nodeB = PtGraph.this.getNodeB(edgePointer);
                PtEdgeAttributes attrs = PtGraph.this.pullAttrs(this.edgeId);
                action.accept(new PtEdge(this.edgeId, nodeA, nodeB, attrs));
                this.edgeId = PtGraph.this.getLinkA(edgePointer);
                return true;
            }
        };
        return () -> Spliterators.iterator(spliterator);
    }

    private PtEdgeAttributes pullAttrs(int edgeId) {
        long attrPointer = this.getAttrPointer(this.toEdgePointer(edgeId));
        GtfsStorage.EdgeType type = edgeTypeValues[this.attrs.getInt(attrPointer)];
        int time = this.attrs.getInt(attrPointer += 4L);
        attrPointer += 4L;
        switch (type) {
            case BOARD: {
                int stop_sequence = this.attrs.getInt(attrPointer);
                int tripDescriptor = this.attrs.getInt(attrPointer += 4L);
                int validity = this.attrs.getInt(attrPointer += 4L);
                int transfers = this.attrs.getInt(attrPointer += 4L);
                attrPointer += 4L;
                return new PtEdgeAttributes(GtfsStorage.EdgeType.BOARD, time, this.validityList.get(validity), -1, null, transfers, stop_sequence, this.tripDescriptorList.get(tripDescriptor), null);
            }
            case ALIGHT: {
                int stop_sequence = this.attrs.getInt(attrPointer);
                int tripDescriptor = this.attrs.getInt(attrPointer += 4L);
                int validity = this.attrs.getInt(attrPointer += 4L);
                attrPointer += 4L;
                return new PtEdgeAttributes(GtfsStorage.EdgeType.ALIGHT, time, this.validityList.get(validity), -1, null, 0, stop_sequence, this.tripDescriptorList.get(tripDescriptor), null);
            }
            case ENTER_PT: {
                int routeType = this.attrs.getInt(attrPointer);
                int platformDescriptor = this.attrs.getInt(attrPointer += 4L);
                attrPointer += 4L;
                return new PtEdgeAttributes(GtfsStorage.EdgeType.ENTER_PT, time, null, routeType, null, 0, -1, null, this.platformDescriptorList.get(platformDescriptor));
            }
            case EXIT_PT: {
                int platformDescriptor = this.attrs.getInt(attrPointer);
                attrPointer += 4L;
                return new PtEdgeAttributes(GtfsStorage.EdgeType.EXIT_PT, time, null, -1, null, 0, -1, null, this.platformDescriptorList.get(platformDescriptor));
            }
            case HOP: {
                int stop_sequence = this.attrs.getInt(attrPointer);
                attrPointer += 4L;
                return new PtEdgeAttributes(GtfsStorage.EdgeType.HOP, time, null, -1, null, 0, stop_sequence, null, null);
            }
            case DWELL: {
                return new PtEdgeAttributes(GtfsStorage.EdgeType.DWELL, time, null, -1, null, 0, -1, null, null);
            }
            case ENTER_TIME_EXPANDED_NETWORK: {
                int feedId = this.attrs.getInt(attrPointer);
                attrPointer += 4L;
                return new PtEdgeAttributes(GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK, time, null, -1, this.feedIdWithTimezoneList.get(feedId), 0, -1, null, null);
            }
            case LEAVE_TIME_EXPANDED_NETWORK: {
                int feedId = this.attrs.getInt(attrPointer);
                attrPointer += 4L;
                return new PtEdgeAttributes(GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK, time, null, -1, this.feedIdWithTimezoneList.get(feedId), 0, -1, null, null);
            }
            case WAIT: {
                return new PtEdgeAttributes(GtfsStorage.EdgeType.WAIT, time, null, -1, null, 0, -1, null, null);
            }
            case WAIT_ARRIVAL: {
                return new PtEdgeAttributes(GtfsStorage.EdgeType.WAIT_ARRIVAL, time, null, -1, null, 0, -1, null, null);
            }
            case OVERNIGHT: {
                return new PtEdgeAttributes(GtfsStorage.EdgeType.OVERNIGHT, time, null, -1, null, 0, -1, null, null);
            }
            case TRANSFER: {
                int routeType = this.attrs.getInt(attrPointer);
                int platformDescriptor = this.attrs.getInt(attrPointer += 4L);
                attrPointer += 4L;
                return new PtEdgeAttributes(GtfsStorage.EdgeType.TRANSFER, time, null, routeType, null, 0, -1, null, this.platformDescriptorList.get(platformDescriptor));
            }
        }
        throw new RuntimeException();
    }

    public PtEdge edge(int edgeId) {
        long edgePointer = this.toEdgePointer(edgeId);
        int nodeA = this.getNodeA(edgePointer);
        int nodeB = this.getNodeB(edgePointer);
        return new PtEdge(edgeId, nodeA, nodeB, this.pullAttrs(edgeId));
    }

    public Iterable<PtEdge> backEdgesAround(final int adjNode) {
        Spliterators.AbstractSpliterator<PtEdge> spliterator = new Spliterators.AbstractSpliterator<PtEdge>(0L, 0){
            int edgeId;
            {
                super(arg0, arg1);
                this.edgeId = PtGraph.this.getEdgeRefIn(PtGraph.this.toNodePointer(adjNode));
            }

            @Override
            public boolean tryAdvance(Consumer<? super PtEdge> action) {
                if (this.edgeId < 0) {
                    return false;
                }
                long edgePointer = PtGraph.this.toEdgePointer(this.edgeId);
                int nodeA = PtGraph.this.getNodeA(edgePointer);
                int nodeB = PtGraph.this.getNodeB(edgePointer);
                action.accept(new PtEdge(this.edgeId, nodeB, nodeA, PtGraph.this.pullAttrs(this.edgeId)));
                this.edgeId = PtGraph.this.getLinkB(edgePointer);
                return true;
            }
        };
        return () -> Spliterators.iterator(spliterator);
    }

    public static class PtEdge {
        private final int edgeId;
        private final int baseNode;
        private final int adjNode;
        private final PtEdgeAttributes attrs;

        public String toString() {
            return "PtEdge{edgeId=" + this.edgeId + ", baseNode=" + this.baseNode + ", adjNode=" + this.adjNode + ", attrs=" + String.valueOf(this.attrs) + "}";
        }

        public PtEdge(int edgeId, int baseNode, int adjNode, PtEdgeAttributes attrs) {
            this.edgeId = edgeId;
            this.baseNode = baseNode;
            this.adjNode = adjNode;
            this.attrs = attrs;
        }

        public GtfsStorage.EdgeType getType() {
            return this.attrs.type;
        }

        public int getTime() {
            return this.attrs.time;
        }

        public int getAdjNode() {
            return this.adjNode;
        }

        public PtEdgeAttributes getAttrs() {
            return this.attrs;
        }

        public int getId() {
            return this.edgeId;
        }

        public int getRouteType() {
            GtfsStorage.EdgeType edgeType = this.getType();
            if (edgeType == GtfsStorage.EdgeType.ENTER_PT || edgeType == GtfsStorage.EdgeType.EXIT_PT || edgeType == GtfsStorage.EdgeType.TRANSFER) {
                return this.getAttrs().route_type;
            }
            throw new RuntimeException("Edge type " + String.valueOf((Object)edgeType) + " doesn't encode route type.");
        }

        public int getBaseNode() {
            return this.baseNode;
        }
    }
}

