/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.Trip;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.ResponsePath;
import com.graphhopper.Trip;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GHLocation;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.gtfs.PtLocationSnapper;
import com.graphhopper.gtfs.PtRouter;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Request;
import com.graphhopper.gtfs.TripBasedRouter;
import com.graphhopper.gtfs.TripFromLabel;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.exceptions.MaximumNodesExceededException;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PtRouterTripBasedImpl
implements PtRouter {
    private static final Logger logger = LoggerFactory.getLogger(PtRouterTripBasedImpl.class);
    private final GraphHopperConfig config;
    private final TranslationMap translationMap;
    private final BaseGraph baseGraph;
    private final EncodingManager encodingManager;
    private final LocationIndex locationIndex;
    private final GtfsStorage gtfsStorage;
    private final PtGraph ptGraph;
    private final PathDetailsBuilderFactory pathDetailsBuilderFactory;
    private final WeightingFactory weightingFactory;
    private final Map<String, ZoneId> feedZoneIds = new ConcurrentHashMap<String, ZoneId>();
    private final GraphHopper graphHopper;

    @Inject
    public PtRouterTripBasedImpl(GraphHopper graphHopper, GraphHopperConfig config, TranslationMap translationMap, BaseGraph baseGraph, EncodingManager encodingManager, LocationIndex locationIndex, GtfsStorage gtfsStorage, PathDetailsBuilderFactory pathDetailsBuilderFactory) {
        this.graphHopper = graphHopper;
        this.config = config;
        this.weightingFactory = new DefaultWeightingFactory(baseGraph, encodingManager);
        this.translationMap = translationMap;
        this.baseGraph = baseGraph;
        this.encodingManager = encodingManager;
        this.locationIndex = locationIndex;
        this.gtfsStorage = gtfsStorage;
        this.ptGraph = gtfsStorage.getPtGraph();
        this.pathDetailsBuilderFactory = pathDetailsBuilderFactory;
    }

    @Override
    public GHResponse route(Request request) {
        return new RequestHandler(request).route();
    }

    private TripBasedRouter.StopWithTimeDelta stopWithTimeDelta(GtfsStorage.PlatformDescriptor platformDescriptor, long timeDelta) {
        ZoneId zoneId = this.feedZoneIds.computeIfAbsent(platformDescriptor.feed_id, feedId -> ZoneId.of(this.gtfsStorage.getGtfsFeeds().get((Object)feedId).agency.values().stream().findFirst().get().agency_timezone));
        return new TripBasedRouter.StopWithTimeDelta(new GtfsStorage.FeedIdWithStopId(platformDescriptor.feed_id, platformDescriptor.stop_id), zoneId, timeDelta);
    }

    private class RequestHandler {
        private final int maxVisitedNodesForRequest;
        private final int limitSolutions;
        private final Duration maxProfileDuration;
        private final Instant initialTime;
        private final boolean profileQuery;
        private final boolean arriveBy;
        private final boolean ignoreTransfers;
        private final double betaTransfers;
        private final double betaStreetTime;
        private final double walkSpeedKmH;
        private final int blockedRouteTypes;
        private final Map<Integer, Long> transferPenaltiesByRouteType;
        private final GHLocation enter;
        private final GHLocation exit;
        private final Translation translation;
        private final List<String> requestedPathDetails;
        private final GHResponse response = new GHResponse();
        private final long limitTripTime;
        private final long limitStreetTime;
        private final double betaAccessTime;
        private final double betaEgressTime;
        private QueryGraph queryGraph;
        private int visitedNodes;
        private final Profile accessProfile;
        private final EdgeFilter accessSnapFilter;
        private final Weighting accessWeighting;
        private final Profile egressProfile;
        private final EdgeFilter egressSnapFilter;
        private final Weighting egressWeighting;
        private TripFromLabel tripFromLabel;
        private List<Label> accessStationLabels;
        private List<TripBasedRouter.StopWithTimeDelta> accessStations;
        private Label walkDestLabel;
        private List<Label> egressStationLabels;
        private List<TripBasedRouter.StopWithTimeDelta> egressStations;
        private ResponsePath walkResponsePath;

        RequestHandler(Request request) {
            this.maxVisitedNodesForRequest = request.getMaxVisitedNodes();
            this.profileQuery = request.isProfileQuery();
            this.ignoreTransfers = Optional.ofNullable(request.getIgnoreTransfers()).orElse(false);
            this.betaTransfers = request.getBetaTransfers();
            this.betaStreetTime = request.getBetaStreetTime();
            this.limitSolutions = Optional.ofNullable(request.getLimitSolutions()).orElse(this.profileQuery ? 50 : (this.ignoreTransfers ? 1 : Integer.MAX_VALUE));
            this.initialTime = request.getEarliestDepartureTime();
            this.maxProfileDuration = request.getMaxProfileDuration();
            this.arriveBy = request.isArriveBy();
            this.walkSpeedKmH = request.getWalkSpeedKmH();
            this.blockedRouteTypes = request.getBlockedRouteTypes();
            this.transferPenaltiesByRouteType = request.getBoardingPenaltiesByRouteType();
            this.translation = PtRouterTripBasedImpl.this.translationMap.getWithFallBack(request.getLocale());
            this.enter = request.getPoints().get(0);
            this.exit = request.getPoints().get(1);
            this.limitTripTime = request.getLimitTripTime() != null ? request.getLimitTripTime().toMillis() : Long.MAX_VALUE;
            this.limitStreetTime = request.getLimitStreetTime() != null ? request.getLimitStreetTime().toMillis() : Long.MAX_VALUE;
            this.requestedPathDetails = request.getPathDetails();
            this.accessProfile = PtRouterTripBasedImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals(request.getAccessProfile())).findFirst().get();
            this.betaAccessTime = request.getBetaAccessTime();
            this.accessWeighting = PtRouterTripBasedImpl.this.weightingFactory.createWeighting(this.accessProfile, new PMap(), false);
            this.accessSnapFilter = new DefaultSnapFilter(this.accessWeighting, PtRouterTripBasedImpl.this.encodingManager.getBooleanEncodedValue(Subnetwork.key((String)this.accessProfile.getName())));
            this.egressProfile = PtRouterTripBasedImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals(request.getEgressProfile())).findFirst().get();
            this.betaEgressTime = request.getBetaEgressTime();
            this.egressWeighting = PtRouterTripBasedImpl.this.weightingFactory.createWeighting(this.egressProfile, new PMap(), false);
            this.egressSnapFilter = new DefaultSnapFilter(this.egressWeighting, PtRouterTripBasedImpl.this.encodingManager.getBooleanEncodedValue(Subnetwork.key((String)this.egressProfile.getName())));
        }

        GHResponse route() {
            Instant departureTime;
            StopWatch stopWatch = new StopWatch().start();
            PtLocationSnapper.Result result = new PtLocationSnapper(PtRouterTripBasedImpl.this.baseGraph, PtRouterTripBasedImpl.this.locationIndex, PtRouterTripBasedImpl.this.gtfsStorage).snapAll(Arrays.asList(this.enter, this.exit), Arrays.asList(this.accessSnapFilter, this.egressSnapFilter));
            this.queryGraph = result.queryGraph;
            this.response.addDebugInfo("idLookup:" + stopWatch.stop().getSeconds() + "s");
            Label.NodeId startNode = result.nodes.get(0);
            Label.NodeId destNode = result.nodes.get(1);
            StopWatch stopWatch1 = new StopWatch().start();
            this.accessStationLabels = this.access(startNode, destNode);
            this.accessStations = this.accessStationLabels.stream().map(l -> PtRouterTripBasedImpl.this.stopWithTimeDelta(l.edge.getPlatformDescriptor(), l.currentTime - this.initialTime.toEpochMilli())).collect(Collectors.toList());
            for (TripBasedRouter.StopWithTimeDelta accessStation : this.accessStations) {
                logger.debug("access {}", (Object)accessStation);
            }
            this.egressStationLabels = this.egress(startNode, destNode);
            this.egressStations = this.egressStationLabels.stream().map(l -> PtRouterTripBasedImpl.this.stopWithTimeDelta(l.edge.getPlatformDescriptor(), this.initialTime.toEpochMilli() - l.currentTime)).collect(Collectors.toList());
            this.response.addDebugInfo("access/egress routing:" + stopWatch1.stop().getSeconds() + "s");
            TripBasedRouter tripBasedRouter = new TripBasedRouter(PtRouterTripBasedImpl.this.gtfsStorage, PtRouterTripBasedImpl.this.gtfsStorage.tripTransfers);
            List<TripBasedRouter.ResultLabel> routes = tripBasedRouter.routeNaiveProfileWithNaiveBetas(new TripBasedRouter.Parameters(this.accessStations, this.egressStations, this.initialTime, this.maxProfileDuration, trip -> (this.blockedRouteTypes & 1 << trip.routeType) == 0, this.betaAccessTime, this.betaEgressTime, this.betaTransfers, this.transferPenaltiesByRouteType));
            this.tripFromLabel = new TripFromLabel((Graph)this.queryGraph, (EncodedValueLookup)PtRouterTripBasedImpl.this.encodingManager, PtRouterTripBasedImpl.this.gtfsStorage, RealtimeFeed.empty(), PtRouterTripBasedImpl.this.pathDetailsBuilderFactory, this.walkSpeedKmH);
            if (this.walkDestLabel != null) {
                List<Label.Transition> walkTransitions = Label.getTransitions(this.walkDestLabel, false);
                List<List<Label.Transition>> walkPartitions = this.tripFromLabel.parsePathToPartitions(walkTransitions);
                List<Trip.Leg> walkPath = this.tripFromLabel.parsePartitionToLegs(walkPartitions.get(0), (Graph)result.queryGraph, (EncodedValueLookup)PtRouterTripBasedImpl.this.encodingManager, this.accessWeighting, this.translation, this.requestedPathDetails);
                this.walkResponsePath = TripFromLabel.createResponsePath(PtRouterTripBasedImpl.this.gtfsStorage, this.translation, result.points, walkPath);
                this.walkResponsePath.setRouteWeight((double)this.walkResponsePath.getTime() * this.betaAccessTime);
                this.response.add(this.walkResponsePath);
            }
            for (TripBasedRouter.ResultLabel route : routes) {
                ResponsePath responsePath = this.extractResponse(route, result);
                if (this.walkResponsePath != null) {
                    Instant endOfProfile;
                    departureTime = ((Trip.Leg)responsePath.getLegs().get(0)).getDepartureTime().toInstant();
                    Duration waitTimeBeforeDeparture = Duration.between(this.initialTime, departureTime);
                    double travelTimeyWeight = responsePath.getRouteWeight() - (double)waitTimeBeforeDeparture.toMillis();
                    double gapBetweenTravelTimeyWeights = this.walkResponsePath.getRouteWeight() - travelTimeyWeight;
                    Instant earliestDepartureTimeWhereResponseIsBetterThanWalking = departureTime.minus((long)gapBetweenTravelTimeyWeights, ChronoUnit.MILLIS);
                    if (earliestDepartureTimeWhereResponseIsBetterThanWalking.isAfter(endOfProfile = this.initialTime.plus(this.maxProfileDuration))) continue;
                }
                this.response.add(responsePath);
            }
            this.response.getAll().sort(Comparator.comparingLong(ResponsePath::getTime));
            if (this.ignoreTransfers) {
                Instant bestDepartureTime = Instant.MIN;
                Iterator i = this.response.getAll().iterator();
                while (i.hasNext()) {
                    ResponsePath path = (ResponsePath)i.next();
                    departureTime = ((Trip.Leg)path.getLegs().get(0)).getDepartureTime().toInstant();
                    if (!departureTime.isAfter(bestDepartureTime)) {
                        i.remove();
                        continue;
                    }
                    bestDepartureTime = departureTime;
                }
            }
            this.response.getHints().putObject("visited_nodes.sum", (Object)this.visitedNodes);
            this.response.getHints().putObject("visited_nodes.average", (Object)this.visitedNodes);
            if (this.response.getAll().isEmpty()) {
                if (this.visitedNodes >= this.maxVisitedNodesForRequest) {
                    this.response.addError((Throwable)new MaximumNodesExceededException("No path found - maximum number of nodes exceeded: " + this.maxVisitedNodesForRequest, this.maxVisitedNodesForRequest));
                } else {
                    this.response.addError((Throwable)new ConnectionNotFoundException("No route found", Collections.emptyMap()));
                }
            }
            return this.response;
        }

        private List<Label> access(Label.NodeId startNode, Label.NodeId destNode) {
            GraphExplorer accessEgressGraphExplorer = new GraphExplorer((Graph)this.queryGraph, PtRouterTripBasedImpl.this.ptGraph, this.accessWeighting, PtRouterTripBasedImpl.this.gtfsStorage, RealtimeFeed.empty(), false, true, false, this.walkSpeedKmH, false, this.blockedRouteTypes);
            MultiCriteriaLabelSetting stationRouter = new MultiCriteriaLabelSetting(accessEgressGraphExplorer, false, false, false, 0L, new ArrayList<Label>());
            stationRouter.setBetaStreetTime(this.betaStreetTime);
            stationRouter.setLimitStreetTime(this.limitStreetTime);
            ArrayList<Label> stationLabels = new ArrayList<Label>();
            for (Label label : stationRouter.calcLabels(startNode, this.initialTime)) {
                ++this.visitedNodes;
                if (label.node.equals(destNode)) {
                    this.walkDestLabel = label;
                    break;
                }
                if (label.edge == null || label.edge.getType() != GtfsStorage.EdgeType.ENTER_PT) continue;
                stationLabels.add(label);
            }
            return stationLabels;
        }

        private List<Label> egress(Label.NodeId startNode, Label.NodeId destNode) {
            GraphExplorer accessEgressGraphExplorer = new GraphExplorer((Graph)this.queryGraph, PtRouterTripBasedImpl.this.ptGraph, this.egressWeighting, PtRouterTripBasedImpl.this.gtfsStorage, RealtimeFeed.empty(), true, true, false, this.walkSpeedKmH, false, this.blockedRouteTypes);
            MultiCriteriaLabelSetting stationRouter = new MultiCriteriaLabelSetting(accessEgressGraphExplorer, true, false, false, 0L, new ArrayList<Label>());
            stationRouter.setBetaStreetTime(this.betaStreetTime);
            stationRouter.setLimitStreetTime(this.limitStreetTime);
            ArrayList<Label> stationLabels = new ArrayList<Label>();
            for (Label label : stationRouter.calcLabels(destNode, this.initialTime)) {
                ++this.visitedNodes;
                if (label.node.equals(startNode)) break;
                if (label.edge == null || label.edge.getType() != GtfsStorage.EdgeType.EXIT_PT) continue;
                stationLabels.add(label);
            }
            return stationLabels;
        }

        private ResponsePath extractResponse(TripBasedRouter.ResultLabel route, PtLocationSnapper.Result snapResult) {
            logger.debug("{}", (Object)route);
            GeometryFactory geometryFactory = new GeometryFactory();
            ArrayList<TripBasedRouter.EnqueuedTripSegment> segments = new ArrayList<TripBasedRouter.EnqueuedTripSegment>();
            TripBasedRouter.EnqueuedTripSegment enqueuedTripSegment = route.enqueuedTripSegment;
            while (enqueuedTripSegment != null) {
                segments.add(enqueuedTripSegment);
                enqueuedTripSegment = enqueuedTripSegment.parent;
            }
            Collections.reverse(segments);
            long routeWeight = 0L;
            ArrayList<Trip.Leg> legs = new ArrayList<Trip.Leg>();
            Optional<Trip.Leg> maybeAccessLeg = this.extractAccessLeg(route, snapResult);
            logger.debug(" {}", maybeAccessLeg);
            if (maybeAccessLeg.isPresent()) {
                Trip.Leg accessLeg = maybeAccessLeg.get();
                legs.add(accessLeg);
                routeWeight = (long)((double)routeWeight + (double)(accessLeg.getArrivalTime().getTime() - accessLeg.getDepartureTime().getTime()) * this.betaAccessTime);
            }
            String previousBlockId = null;
            for (int i = 0; i < segments.size(); ++i) {
                boolean isInSameVehicleAsPrevious;
                TripBasedRouter.EnqueuedTripSegment segment = (TripBasedRouter.EnqueuedTripSegment)segments.get(i);
                GTFSFeed feed = PtRouterTripBasedImpl.this.gtfsStorage.getGtfsFeeds().get(segment.tripPointer.feedId);
                ZoneId zoneId = ZoneId.of(feed.agency.values().stream().findFirst().get().agency_timezone);
                LocalDate day = segment.serviceDay;
                Trip trip = segment.tripPointer.trip;
                int untilStopSequence = i == segments.size() - 1 ? route.stopTime : ((TripBasedRouter.EnqueuedTripSegment)segments.get((int)(i + 1))).transferOrigin.stop_sequence;
                List stops = segment.tripPointer.stopTimes.stream().filter(st -> st != null && st.stop_sequence >= segment.tripAtStopTime.stop_sequence && st.stop_sequence <= untilStopSequence).map(st -> {
                    Instant departureTime = day.atStartOfDay().plusSeconds(st.departure_time).atZone(zoneId).toInstant();
                    Instant arrivalTime = day.atStartOfDay().plusSeconds(st.arrival_time).atZone(zoneId).toInstant();
                    Stop stop = feed.stops.get(st.stop_id);
                    return new Trip.Stop(st.stop_id, st.stop_sequence, stop.stop_name, geometryFactory.createPoint(new Coordinate(stop.stop_lon, stop.stop_lat)), Date.from(arrivalTime), Date.from(arrivalTime), Date.from(arrivalTime), false, Date.from(departureTime), Date.from(departureTime), Date.from(departureTime), false);
                }).collect(Collectors.toList());
                boolean bl = isInSameVehicleAsPrevious = trip.block_id != null && trip.block_id.equals(previousBlockId);
                if (segment.transferOrigin != null) {
                    GtfsStorage.FeedIdWithStopId stopA = new GtfsStorage.FeedIdWithStopId(segment.parent.tripPointer.feedId, segment.parent.tripPointer.stopTimes.get((int)segment.transferOrigin.stop_sequence).stop_id);
                    GtfsStorage.FeedIdWithStopId stopB = new GtfsStorage.FeedIdWithStopId(segment.tripPointer.feedId, segment.tripPointer.stopTimes.get((int)segment.tripAtStopTime.stop_sequence).stop_id);
                    List previousStops = ((Trip.PtLeg)legs.get((int)(legs.size() - 1))).stops;
                    PtRouterTripBasedImpl.this.gtfsStorage.interpolatedTransfers.get((Object)stopA).stream().filter(it -> it.toPlatformDescriptor.equals(stopB)).findAny().ifPresent(it -> {
                        List<Label.Transition> transferTransitions = this.tripFromLabel.transferPath(it.skippedEdgesForTransfer, this.egressWeighting, ((Trip.Stop)previousStops.get((int)(previousStops.size() - 1))).arrivalTime.toInstant().toEpochMilli());
                        List<Trip.Leg> transferLegs = this.tripFromLabel.parsePartitionToLegs(transferTransitions, (Graph)this.queryGraph, (EncodedValueLookup)PtRouterTripBasedImpl.this.encodingManager, this.egressWeighting, this.translation, this.requestedPathDetails);
                        legs.add(transferLegs.get(0));
                    });
                }
                long travelTime = ((Trip.Stop)stops.get((int)(stops.size() - 1))).arrivalTime.toInstant().toEpochMilli() - ((Trip.Stop)stops.get((int)0)).departureTime.toInstant().toEpochMilli();
                legs.add((Trip.Leg)new Trip.PtLeg(segment.tripPointer.feedId, isInSameVehicleAsPrevious, segment.tripPointer.trip.trip_id, trip.route_id, trip.trip_headsign, stops, 0.0, travelTime, (Geometry)geometryFactory.createLineString((Coordinate[])stops.stream().map(s -> s.geometry.getCoordinate()).toArray(Coordinate[]::new))));
                routeWeight += travelTime;
                routeWeight += this.transferPenaltiesByRouteType.getOrDefault(segment.tripPointer.routeType, 0L).longValue();
                previousBlockId = trip.block_id;
            }
            Optional<Trip.Leg> maybeEgressLeg = this.extractEgressLeg(route, snapResult);
            if (maybeEgressLeg.isPresent()) {
                Trip.Leg egressLeg = maybeEgressLeg.get();
                legs.add(egressLeg);
                routeWeight = (long)((double)routeWeight + (double)(egressLeg.getArrivalTime().getTime() - egressLeg.getDepartureTime().getTime()) * this.betaEgressTime);
            }
            ResponsePath responsePath = TripFromLabel.createResponsePath(PtRouterTripBasedImpl.this.gtfsStorage, this.translation, snapResult.points, legs);
            Duration duration = Duration.between(this.initialTime, ((Trip.Leg)responsePath.getLegs().get(responsePath.getLegs().size() - 1)).getArrivalTime().toInstant());
            responsePath.setTime(duration.toMillis());
            Duration waitTimeBeforeDeparture = Duration.between(this.initialTime, ((Trip.Leg)responsePath.getLegs().get(0)).getDepartureTime().toInstant());
            routeWeight += waitTimeBeforeDeparture.toMillis();
            for (int i = 1; i < responsePath.getLegs().size(); ++i) {
                Duration waitTimeBeforeLeg = Duration.between(((Trip.Leg)responsePath.getLegs().get(i - 1)).getArrivalTime().toInstant(), ((Trip.Leg)responsePath.getLegs().get(i)).getDepartureTime().toInstant());
                routeWeight += waitTimeBeforeLeg.toMillis();
            }
            responsePath.setRouteWeight((double)routeWeight);
            return responsePath;
        }

        private Optional<Trip.Leg> extractAccessLeg(TripBasedRouter.ResultLabel route, PtLocationSnapper.Result snapResult) {
            Label accessLabel = this.accessStationLabels.get(this.accessStations.indexOf(route.getAccessStop()));
            List<Label.Transition> accessTransitions = Label.getTransitions(accessLabel, false);
            List<List<Label.Transition>> accessPartitions = this.tripFromLabel.parsePathToPartitions(accessTransitions);
            List<Trip.Leg> accessPath = this.tripFromLabel.parsePartitionToLegs(accessPartitions.get(0), (Graph)snapResult.queryGraph, (EncodedValueLookup)PtRouterTripBasedImpl.this.encodingManager, this.accessWeighting, this.translation, this.requestedPathDetails);
            if (accessPath.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(accessPath.get(0));
        }

        private Optional<Trip.Leg> extractEgressLeg(TripBasedRouter.ResultLabel route, PtLocationSnapper.Result snapResult) {
            Label egressLabel = this.egressStationLabels.get(this.egressStations.indexOf(route.destination));
            List<Label.Transition> egressTransitions = Label.getTransitions(egressLabel, true);
            List<List<Label.Transition>> egressPartitions = this.tripFromLabel.parsePathToPartitions(egressTransitions);
            if (egressPartitions.size() < 2) {
                return Optional.empty();
            }
            List<Trip.Leg> egressPath = this.tripFromLabel.parsePartitionToLegs(egressPartitions.get(1), (Graph)snapResult.queryGraph, (EncodedValueLookup)PtRouterTripBasedImpl.this.encodingManager, this.egressWeighting, this.translation, this.requestedPathDetails);
            return Optional.of(egressPath.get(0));
        }
    }
}

