/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Trips;
import com.graphhopper.reader.osm.Pair;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripBasedRouter {
    private static final Logger logger = LoggerFactory.getLogger(TripBasedRouter.class);
    private final Trips tripTransfers;
    private GtfsStorage gtfsStorage;
    int[] earliestArrivalTime;
    private int[][] tripDoneFromIndex;
    private List<ResultLabel> result = new ArrayList<ResultLabel>();
    private Parameters parameters;
    private final int N_ROUNDS = 8;
    int round;

    public TripBasedRouter(GtfsStorage gtfsStorage, Trips tripTransfers) {
        this.gtfsStorage = gtfsStorage;
        this.tripTransfers = tripTransfers;
        this.earliestArrivalTime = new int[9];
        this.tripDoneFromIndex = new int[9][tripTransfers.idx];
        for (int i = 0; i < 9; ++i) {
            this.earliestArrivalTime[i] = Integer.MAX_VALUE;
            Arrays.fill(this.tripDoneFromIndex[i], Integer.MAX_VALUE);
        }
    }

    public List<ResultLabel> routeNaiveProfileWithNaiveBetas(Parameters parameters) {
        this.routeNaiveProfile(parameters);
        return this.result;
    }

    public List<ResultLabel> routeNaiveProfile(Parameters parameters) {
        this.parameters = parameters;
        while (!parameters.getProfileLength().isNegative()) {
            Instant initialTime = parameters.getProfileStartTime().plus(parameters.getProfileLength());
            this.route(parameters.getAccessStations(), initialTime, parameters.getTripFilter());
            parameters.setProfileLength(parameters.getProfileLength().minus(Duration.ofMinutes(1L)));
        }
        this.route(parameters.getAccessStations(), parameters.getProfileStartTime(), parameters.getTripFilter());
        return this.result;
    }

    public List<ResultLabel> route(List<StopWithTimeDelta> accessStations, Instant initialTime, Predicate<GTFSFeed.StopTimesForTripWithTripPatternKey> tripFilter) {
        logger.debug("=== {} ===", (Object)initialTime);
        ArrayList<EnqueuedTripSegment> queue = new ArrayList<EnqueuedTripSegment>();
        for (StopWithTimeDelta accessStation : accessStations) {
            ZonedDateTime earliestDepartureTime = initialTime.atZone(accessStation.zoneId).plus(accessStation.timeDelta, ChronoUnit.MILLIS);
            LocalDate serviceDay = earliestDepartureTime.toLocalDate();
            Map<String, List<Trips.TripAtStopTime>> boardingsByPattern = this.tripTransfers.getPatternBoardings(accessStation.stopId);
            int targetSecondOfDay = earliestDepartureTime.toLocalTime().toSecondOfDay();
            block1: for (List<Trips.TripAtStopTime> boardings : boardingsByPattern.values()) {
                int index;
                for (int i = index = TripBasedRouter.binarySearch(targetSecondOfDay, boardings, boarding -> this.tripTransfers.getTrip((int)boarding.tripIdx).stopTimes.get((int)boarding.stop_sequence).departure_time); i < boardings.size(); ++i) {
                    Trips.TripAtStopTime boarding2 = boardings.get(i);
                    GTFSFeed.StopTimesForTripWithTripPatternKey tripPointer = this.tripTransfers.getTrip(boarding2.tripIdx);
                    if (!tripPointer.service.activeOn(serviceDay) || !tripFilter.test(tripPointer)) continue;
                    logger.debug("{}", (Object)boarding2);
                    this.enqueue(queue, tripPointer, boarding2, null, null, serviceDay, accessStation, 0);
                    continue block1;
                }
            }
        }
        this.iterate(queue);
        return this.result;
    }

    private static int binarySearch(int targetSecondOfDay, List<Trips.TripAtStopTime> boardings, ToIntFunction<Trips.TripAtStopTime> tripAtStopTimeToIntFunction) {
        int index = Collections.binarySearch(boardings, null, (boarding, key) -> {
            int x = tripAtStopTimeToIntFunction.applyAsInt((Trips.TripAtStopTime)boarding);
            return x >= targetSecondOfDay ? 1 : -1;
        });
        return index >= 0 ? index : -index - 1;
    }

    private void iterate(List<EnqueuedTripSegment> queue) {
        this.round = 0;
        logger.debug("Round {}: {}", (Object)this.round, (Object)queue.size());
        this.reportQueue(queue);
        this.checkArrivals(queue, this.round);
        while (queue.size() != 0 && this.round < 8) {
            List<EnqueuedTripSegment> queue1 = this.enqueueTransfers(queue);
            queue = queue1;
            ++this.round;
            logger.debug("Round {}: {}", (Object)this.round, (Object)queue.size());
            this.reportQueue(queue);
            this.checkArrivals(queue, this.round);
        }
    }

    private void reportQueue(List<EnqueuedTripSegment> queue) {
        List<Pair> pairs = queue.stream().map(segment -> new Pair(segment, (Object)this.tripTransfers.getTrip(segment.tripAtStopTime.tripIdx))).collect(Collectors.toList());
        pairs.forEach(p -> {
            EnqueuedTripSegment segment = (EnqueuedTripSegment)p.first;
            GTFSFeed.StopTimesForTripWithTripPatternKey trip = (GTFSFeed.StopTimesForTripWithTripPatternKey)p.second;
            logger.debug(" pattern: {}   trip: {} {},   stops: [{}, {}]", new Object[]{trip.pattern.pattern_id, ((EnqueuedTripSegment)p.first).tripPointer.trip.trip_id, ((EnqueuedTripSegment)p.first).tripPointer.idx, segment.tripAtStopTime.stop_sequence, segment.toStopSequence});
        });
    }

    private List<EnqueuedTripSegment> enqueueTransfers(List<EnqueuedTripSegment> queue0) {
        ArrayList<EnqueuedTripSegment> queue1 = new ArrayList<EnqueuedTripSegment>();
        block0: for (EnqueuedTripSegment enqueuedTripSegment : queue0) {
            logger.debug("{}", (Object)enqueuedTripSegment);
            GTFSFeed sourceFeed = this.gtfsStorage.getGtfsFeeds().get(enqueuedTripSegment.tripPointer.feedId);
            ZoneId sourceZoneId = ZoneId.of(sourceFeed.agency.values().stream().findFirst().get().agency_timezone);
            int toStopSequence = Math.min(enqueuedTripSegment.toStopSequence, enqueuedTripSegment.tripPointer.stopTimes.size());
            for (int i = enqueuedTripSegment.tripAtStopTime.stop_sequence + 1; i < toStopSequence; ++i) {
                StopTime stopTime = enqueuedTripSegment.tripPointer.stopTimes.get(i);
                if (stopTime == null) continue;
                if (this.getArrivalTime(enqueuedTripSegment, stopTime, 0) >= this.earliestArrivalTime[this.round]) continue block0;
                Trips.TripAtStopTime transferOrigin = new Trips.TripAtStopTime(enqueuedTripSegment.tripPointer.idx, stopTime.stop_sequence);
                logger.debug("  {}", (Object)Trips.TripAtStopTime.print(transferOrigin, this.tripTransfers, Trips.TripAtStopTime.ArrivalDeparture.ARRIVAL));
                Collection<Trips.TripAtStopTime> transferDestinations = this.gtfsStorage.tripTransfers.getTripTransfers(enqueuedTripSegment.serviceDay).get(transferOrigin);
                if (transferDestinations == null) continue;
                for (Trips.TripAtStopTime transferDestination : transferDestinations) {
                    GTFSFeed.StopTimesForTripWithTripPatternKey destinationTripPointer = this.tripTransfers.getTrip(transferDestination.tripIdx);
                    GTFSFeed destinationFeed = this.gtfsStorage.getGtfsFeeds().get(destinationTripPointer.feedId);
                    ZoneId destinationZoneId = ZoneId.of(destinationFeed.agency.values().stream().findFirst().get().agency_timezone);
                    StopTime transferStopTime = destinationTripPointer.stopTimes.get(transferDestination.stop_sequence);
                    LocalDateTime scheduleArrivalTime = enqueuedTripSegment.serviceDay.atStartOfDay().plusSeconds(stopTime.arrival_time);
                    int timeZoneOffset = (int)(scheduleArrivalTime.atZone(sourceZoneId).toEpochSecond() - scheduleArrivalTime.atZone(destinationZoneId).toEpochSecond());
                    if (transferStopTime.departure_time < stopTime.arrival_time + timeZoneOffset || !destinationTripPointer.service.activeOn(enqueuedTripSegment.serviceDay) || !this.parameters.getTripFilter().test(destinationTripPointer)) continue;
                    logger.debug("    {}", (Object)transferDestination);
                    this.enqueue(queue1, destinationTripPointer, transferDestination, transferOrigin, enqueuedTripSegment, enqueuedTripSegment.serviceDay, enqueuedTripSegment.accessStation, this.round + 1);
                }
            }
        }
        return queue1;
    }

    private void checkArrivals(List<EnqueuedTripSegment> queue0, int round) {
        for (EnqueuedTripSegment enqueuedTripSegment : queue0) {
            int toStopSequence = Math.min(enqueuedTripSegment.toStopSequence, enqueuedTripSegment.tripPointer.stopTimes.size() - 1);
            for (int i = enqueuedTripSegment.tripAtStopTime.stop_sequence + 1; i <= toStopSequence; ++i) {
                StopTime stopTime = enqueuedTripSegment.tripPointer.stopTimes.get(i);
                if (stopTime == null) continue;
                for (StopWithTimeDelta destination : this.parameters.getEgressStations()) {
                    int newArrivalTime = this.getArrivalTime(enqueuedTripSegment, stopTime, (int)(destination.timeDelta / 1000L));
                    if (!destination.stopId.stopId.equals(stopTime.stop_id) || !destination.stopId.feedId.equals(enqueuedTripSegment.tripPointer.feedId) || newArrivalTime >= this.earliestArrivalTime[round]) continue;
                    for (int r = round; r < 9; ++r) {
                        if (newArrivalTime >= this.earliestArrivalTime[r]) continue;
                        this.earliestArrivalTime[r] = newArrivalTime;
                    }
                    ResultLabel newResult = new ResultLabel(round, destination, enqueuedTripSegment.tripPointer.idx, stopTime.stop_sequence, enqueuedTripSegment);
                    logger.debug(" {}", (Object)newResult);
                    int newRealTransfers = newResult.getRealTransfers();
                    int newDepartureTime = newResult.getDepartureTime();
                    Iterator<ResultLabel> it = this.result.iterator();
                    while (it.hasNext()) {
                        ResultLabel oldResult = it.next();
                        if (oldResult.getArrivalTime() < newArrivalTime || oldResult.getRealTransfers() < newRealTransfers || oldResult.getDepartureTime() > newDepartureTime) continue;
                        it.remove();
                    }
                    this.result.add(newResult);
                    for (ResultLabel oldResult : this.result) {
                        logger.debug("  {}", (Object)oldResult);
                    }
                }
            }
        }
    }

    private int getArrivalTime(EnqueuedTripSegment enqueuedTripSegment, StopTime stopTime, int extraSeconds) {
        int extraDisutilityOfAccessSeconds = (int)((long)((double)enqueuedTripSegment.accessStation.timeDelta * (this.parameters.getBetaAccessTime() - 1.0)) / 1000L);
        int extraDisutilityOfTransfersSeconds = (int)((double)enqueuedTripSegment.nRealTransfers * this.parameters.getBetaTransfers() / 1000.0);
        int extraDisutilityOfRouteTypeSeconds = (int)(enqueuedTripSegment.routeTypePenalty / 1000L);
        return stopTime.arrival_time + extraDisutilityOfAccessSeconds + extraDisutilityOfTransfersSeconds + extraDisutilityOfRouteTypeSeconds + extraSeconds;
    }

    private void enqueue(List<EnqueuedTripSegment> queue1, GTFSFeed.StopTimesForTripWithTripPatternKey tripPointer, Trips.TripAtStopTime tripAtBoarding, Trips.TripAtStopTime transferOrigin, EnqueuedTripSegment parent, LocalDate serviceDay, StopWithTimeDelta accessStation, int round) {
        int thisTripDoneFromIndex = this.tripDoneFromIndex[round][tripPointer.idx];
        if (tripAtBoarding.stop_sequence < thisTripDoneFromIndex) {
            long routeTypePenalty = this.parameters.transferPenaltiesByRouteType.getOrDefault(tripPointer.routeType, 0L);
            EnqueuedTripSegment enqueuedTripSegment = new EnqueuedTripSegment(tripPointer, tripAtBoarding, thisTripDoneFromIndex, serviceDay, transferOrigin, parent, accessStation);
            if (parent != null) {
                enqueuedTripSegment.nRealTransfers = parent.nRealTransfers + 1;
                enqueuedTripSegment.routeTypePenalty = parent.routeTypePenalty;
            }
            enqueuedTripSegment.routeTypePenalty += routeTypePenalty;
            queue1.add(enqueuedTripSegment);
            this.markAsDone(tripPointer, tripAtBoarding.stop_sequence, round);
        }
    }

    private void markAsDone(GTFSFeed.StopTimesForTripWithTripPatternKey destinationTripPointer, int doneFromIndex, int round) {
        logger.debug("done: {} [{}", (Object)destinationTripPointer.idx, (Object)doneFromIndex);
        for (int r = round; r < 9; ++r) {
            int previousDoneFromIndex;
            for (int i = destinationTripPointer.idx; i < destinationTripPointer.endIdxOfPattern && doneFromIndex < (previousDoneFromIndex = this.tripDoneFromIndex[r][i]); ++i) {
                this.tripDoneFromIndex[r][i] = doneFromIndex;
            }
        }
    }

    static class Parameters {
        private final List<StopWithTimeDelta> accessStations;
        private final List<StopWithTimeDelta> egressStations;
        private final Instant profileStartTime;
        private Duration profileLength;
        private final Predicate<GTFSFeed.StopTimesForTripWithTripPatternKey> tripFilter;
        private final double betaAccessTime;
        private final double betaEgressTime;
        private final double betaTransfers;
        private final Map<Integer, Long> transferPenaltiesByRouteType;

        Parameters(List<StopWithTimeDelta> accessStations, List<StopWithTimeDelta> egressStations, Instant profileStartTime, Duration profileLength, Predicate<GTFSFeed.StopTimesForTripWithTripPatternKey> tripFilter, double betaAccessTime, double betaEgressTime, double betaTransfers, Map<Integer, Long> transferPenaltiesByRouteType) {
            this.accessStations = accessStations;
            this.egressStations = egressStations;
            this.profileStartTime = profileStartTime;
            this.profileLength = profileLength;
            this.tripFilter = tripFilter;
            this.betaAccessTime = betaAccessTime;
            this.betaEgressTime = betaEgressTime;
            this.betaTransfers = betaTransfers;
            this.transferPenaltiesByRouteType = transferPenaltiesByRouteType;
        }

        public List<StopWithTimeDelta> getAccessStations() {
            return this.accessStations;
        }

        public List<StopWithTimeDelta> getEgressStations() {
            return this.egressStations;
        }

        public Instant getProfileStartTime() {
            return this.profileStartTime;
        }

        public Duration getProfileLength() {
            return this.profileLength;
        }

        public Predicate<GTFSFeed.StopTimesForTripWithTripPatternKey> getTripFilter() {
            return this.tripFilter;
        }

        public void setProfileLength(Duration profileLength) {
            this.profileLength = profileLength;
        }

        public double getBetaAccessTime() {
            return this.betaAccessTime;
        }

        public double getBetaEgressTime() {
            return this.betaEgressTime;
        }

        public double getBetaTransfers() {
            return this.betaTransfers;
        }
    }

    public static class StopWithTimeDelta {
        GtfsStorage.FeedIdWithStopId stopId;
        ZoneId zoneId;
        long timeDelta;

        public StopWithTimeDelta(GtfsStorage.FeedIdWithStopId stopId, ZoneId zoneId, long timeDelta) {
            this.stopId = stopId;
            this.zoneId = zoneId;
            this.timeDelta = timeDelta;
        }

        public String toString() {
            return "StopWithTimeDelta{stopId=" + String.valueOf(this.stopId) + ", timeDelta=" + this.timeDelta + "}";
        }
    }

    static class EnqueuedTripSegment {
        GTFSFeed.StopTimesForTripWithTripPatternKey tripPointer;
        Trips.TripAtStopTime tripAtStopTime;
        int toStopSequence;
        LocalDate serviceDay;
        Trips.TripAtStopTime transferOrigin;
        EnqueuedTripSegment parent;
        StopWithTimeDelta accessStation;
        long routeTypePenalty;
        int nRealTransfers;

        public EnqueuedTripSegment(GTFSFeed.StopTimesForTripWithTripPatternKey tripPointer, Trips.TripAtStopTime tripAtStopTime, int toStopSequence, LocalDate serviceDay, Trips.TripAtStopTime transferOrigin, EnqueuedTripSegment parent, StopWithTimeDelta accessStation) {
            this.tripPointer = tripPointer;
            this.tripAtStopTime = tripAtStopTime;
            this.toStopSequence = toStopSequence;
            this.serviceDay = serviceDay;
            this.transferOrigin = transferOrigin;
            this.parent = parent;
            this.accessStation = accessStation;
        }

        public String toString() {
            return "EnqueuedTripSegment{tripAtStopTime=" + String.valueOf(this.tripAtStopTime) + ", serviceDay=" + String.valueOf(this.serviceDay) + "}";
        }
    }

    public class ResultLabel {
        private final int round;
        public final StopWithTimeDelta destination;
        private final int tripIdx;
        public final int stopTime;
        public EnqueuedTripSegment enqueuedTripSegment;

        public ResultLabel(int round, StopWithTimeDelta destination, int tripIdx, int stop_time, EnqueuedTripSegment enqueuedTripSegment) {
            this.round = round;
            this.destination = destination;
            this.tripIdx = tripIdx;
            this.stopTime = stop_time;
            this.enqueuedTripSegment = enqueuedTripSegment;
        }

        public String toString() {
            StopTime stopTime = this.getStopTime();
            int departureTime = this.getDepartureTime();
            int departureTimeAtStop = this.getDepartureTimeAtStop();
            return String.format("%s+%d %s+%d %s %s+%d %s %s+%d", LocalTime.ofSecondOfDay(departureTime % 86400), departureTime / 86400, LocalTime.ofSecondOfDay(departureTimeAtStop % 86400), departureTimeAtStop / 86400, this.getAccessStop().stopId.stopId, LocalTime.ofSecondOfDay(stopTime.arrival_time % 86400), stopTime.arrival_time / 86400, stopTime.stop_id, LocalTime.ofSecondOfDay(((long)stopTime.arrival_time + this.destination.timeDelta / 1000L) % 86400L), ((long)stopTime.arrival_time + this.destination.timeDelta / 1000L) / 86400L);
        }

        private StopTime getStopTime() {
            List<StopTime> stopTimes = TripBasedRouter.this.tripTransfers.getTrip((int)this.tripIdx).stopTimes;
            return stopTimes.get(this.stopTime);
        }

        int getDepartureTime() {
            int departureTimeAtStop = this.getDepartureTimeAtStop();
            return departureTimeAtStop - (int)(this.getAccessStop().timeDelta / 1000L);
        }

        private int getDepartureTimeAtStop() {
            EnqueuedTripSegment i = this.enqueuedTripSegment;
            while (i.parent != null) {
                i = i.parent;
            }
            return TripBasedRouter.this.tripTransfers.getTrip((int)i.tripPointer.idx).stopTimes.get((int)i.tripAtStopTime.stop_sequence).departure_time;
        }

        public StopWithTimeDelta getAccessStop() {
            EnqueuedTripSegment i = this.enqueuedTripSegment;
            while (i.parent != null) {
                i = i.parent;
            }
            return i.accessStation;
        }

        int getArrivalTime() {
            return TripBasedRouter.this.getArrivalTime(this.enqueuedTripSegment, this.getStopTime(), (int)((double)(this.destination.timeDelta / 1000L) * TripBasedRouter.this.parameters.getBetaEgressTime() + (double)this.getRouteTypePenalty()));
        }

        public int getRound() {
            return this.round;
        }

        public int getRealTransfers() {
            int result = 0;
            EnqueuedTripSegment i = this.enqueuedTripSegment;
            while (i.parent != null) {
                Trip trip1 = TripBasedRouter.this.tripTransfers.getTrip((int)i.tripAtStopTime.tripIdx).trip;
                Trip trip2 = TripBasedRouter.this.tripTransfers.getTrip((int)i.transferOrigin.tripIdx).trip;
                if (trip1.block_id == null || trip2.block_id == null || !trip1.block_id.equals(trip2.block_id)) {
                    ++result;
                }
                i = i.parent;
            }
            return result;
        }

        public long getRouteTypePenalty() {
            long result = 0L;
            EnqueuedTripSegment i = this.enqueuedTripSegment;
            while (i.parent != null) {
                result += TripBasedRouter.this.parameters.transferPenaltiesByRouteType.getOrDefault(i.tripPointer.routeType, 0L).longValue();
                i = i.parent;
            }
            return result;
        }
    }
}

