/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharObjectHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharObjectScatterMap<VType>
extends CharObjectHashMap<VType> {
    public CharObjectScatterMap() {
        this(4);
    }

    public CharObjectScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharObjectScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static <VType> CharObjectScatterMap<VType> from(char[] keys2, VType[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharObjectScatterMap<VType> map = new CharObjectScatterMap<VType>(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }
}

