/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.IntByteHashMap;

public class IntByteScatterMap
extends IntByteHashMap {
    public IntByteScatterMap() {
        this(4);
    }

    public IntByteScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntByteScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(int key) {
        return BitMixer.mixPhi(key);
    }

    public static IntByteScatterMap from(int[] keys2, byte[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntByteScatterMap map = new IntByteScatterMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }
}

