/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongIntHashMap;

public class LongIntScatterMap
extends LongIntHashMap {
    public LongIntScatterMap() {
        this(4);
    }

    public LongIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(long key) {
        return BitMixer.mixPhi(key);
    }

    public static LongIntScatterMap from(long[] keys2, int[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongIntScatterMap map = new LongIntScatterMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }
}

