/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongLongHashMap;

public class LongLongScatterMap
extends LongLongHashMap {
    public LongLongScatterMap() {
        this(4);
    }

    public LongLongScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongLongScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(long key) {
        return BitMixer.mixPhi(key);
    }

    public static LongLongScatterMap from(long[] keys2, long[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongLongScatterMap map = new LongLongScatterMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }
}

