/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ObjectIntHashMap;

public class ObjectIntScatterMap<KType>
extends ObjectIntHashMap<KType> {
    public ObjectIntScatterMap() {
        this(4);
    }

    public ObjectIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType> ObjectIntScatterMap<KType> from(KType[] keys2, int[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectIntScatterMap<KType> map = new ObjectIntScatterMap<KType>(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }
}

