/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectObjectAssociativeContainer;
import com.carrotsearch.hppc.ObjectObjectMap;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectObjectPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectObjectProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class ObjectObjectHashMap<KType, VType>
implements ObjectObjectMap<KType, VType>,
Preallocable,
Cloneable {
    public Object[] keys;
    public Object[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public ObjectObjectHashMap() {
        this(4);
    }

    public ObjectObjectHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectObjectHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public ObjectObjectHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ObjectObjectHashMap(ObjectObjectAssociativeContainer<? extends KType, ? extends VType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public VType put(KType key, VType value) {
        Object existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == null) {
            this.hasEmptyKey = true;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return (VType)previousValue;
        }
        Object[] keys2 = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != null) {
            if (this.equals(existing, key)) {
                Object previousValue = this.values[slot];
                this.values[slot] = value;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys2[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return null;
    }

    @Override
    public int putAll(ObjectObjectAssociativeContainer<? extends KType, ? extends VType> container) {
        int count = this.size();
        for (ObjectObjectCursor<KType, VType> objectObjectCursor : container) {
            this.put(objectObjectCursor.key, objectObjectCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends ObjectObjectCursor<? extends KType, ? extends VType>> iterable) {
        int count = this.size();
        for (ObjectObjectCursor<KType, VType> objectObjectCursor : iterable) {
            this.put(objectObjectCursor.key, objectObjectCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(KType key, VType value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    @Override
    public VType remove(KType key) {
        Object existing;
        int mask = this.mask;
        if (key == null) {
            this.hasEmptyKey = false;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = null;
            return (VType)previousValue;
        }
        Object[] keys2 = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != null) {
            if (this.equals(existing, key)) {
                Object previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeAll(ObjectContainer<? super KType> other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof ObjectLookupContainer) {
            void var4_6;
            if (this.hasEmptyKey && other.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = null;
            }
            Object[] keys2 = this.keys;
            boolean bl = false;
            int max = this.mask;
            while (var4_6 <= max) {
                Object existing = keys2[var4_6];
                if (existing != null && other.contains(existing)) {
                    this.shiftConflictingKeys((int)var4_6);
                    continue;
                }
                ++var4_6;
            }
        } else {
            for (ObjectCursor<Object> objectCursor : other) {
                this.remove(objectCursor.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectObjectPredicate<? super KType, ? super VType> predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(null, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = null;
        }
        Object[] keys2 = this.keys;
        Object[] values2 = this.values;
        int slot = 0;
        while (slot <= mask) {
            Object existing = keys2[slot];
            if (existing != null && predicate.apply(existing, values2[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = null;
        }
        Object[] keys2 = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            Object existing = keys2[slot];
            if (existing != null && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public VType get(KType key) {
        Object existing;
        if (key == null) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : null);
        }
        Object[] keys2 = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != null) {
            if (this.equals(existing, key)) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Override
    public VType getOrDefault(KType key, VType defaultValue) {
        Object existing;
        if (key == null) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue);
        }
        Object[] keys2 = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != null) {
            if (this.equals(existing, key)) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(KType key) {
        Object existing;
        if (key == null) {
            return this.hasEmptyKey;
        }
        Object[] keys2 = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != null) {
            if (this.equals(existing, key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(KType key) {
        Object existing;
        int mask = this.mask;
        if (key == null) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        Object[] keys2 = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != null) {
            if (this.equals(existing, key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public VType indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return (VType)this.values[index];
    }

    @Override
    public VType indexReplace(int index, VType newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        Object previousValue = this.values[index];
        this.values[index] = newValue;
        return (VType)previousValue;
    }

    @Override
    public void indexInsert(int index, KType key, VType value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == null) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == null);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectObjectCursor<KType, VType> c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ObjectObjectHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(ObjectObjectHashMap<?, ?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ObjectObjectCursor<?, ?> objectObjectCursor : other) {
            Object key = objectObjectCursor.key;
            if (this.containsKey(key) && Objects.equals(this.get(key), objectObjectCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            Object[] prevKeys = this.keys;
            Object[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<ObjectObjectCursor<KType, VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ObjectObjectProcedure<? super KType, ? super VType>> T forEach(T procedure) {
        Object[] keys2 = this.keys;
        Object[] values2 = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(null, (Object)values2[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (keys2[slot] == null) continue;
            procedure.apply((Object)keys2[slot], (Object)values2[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectObjectPredicate<? super KType, ? super VType>> T forEach(T predicate) {
        Object[] keys2 = this.keys;
        Object[] values2 = this.values;
        if (this.hasEmptyKey && !predicate.apply(null, (Object)values2[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (keys2[slot] == null || predicate.apply((Object)keys2[slot], (Object)values2[slot])); ++slot) {
        }
        return predicate;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ObjectCollection<VType> values() {
        return new ValuesContainer();
    }

    public ObjectObjectHashMap<KType, VType> clone() {
        try {
            ObjectObjectHashMap cloned = (ObjectObjectHashMap)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectObjectCursor<KType, VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static <KType, VType> ObjectObjectHashMap<KType, VType> from(KType[] keys2, VType[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectObjectHashMap<KType, VType> map = new ObjectObjectHashMap<KType, VType>(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }

    protected int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(KType[] fromKeys, VType[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        Object[] keys2 = this.keys;
        Object[] values2 = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys2[keys2.length - 1] = fromKeys[from];
        values2[values2.length - 1] = fromValues[from];
        while (--from >= 0) {
            KType existing = fromKeys[from];
            if (existing == null) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys2[slot] != null) {
                slot = slot + 1 & mask;
            }
            keys2[slot] = existing;
            values2[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        Object[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new Object[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, KType pendingKey, VType pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == null && pendingKey != null);
        Object[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        Object existing;
        Object[] keys2 = this.keys;
        Object[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys2[slot = gapSlot + ++distance & mask]) != null) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            values2[gapSlot] = values2[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = null;
        values2[gapSlot] = null;
        --this.assigned;
    }

    protected boolean equals(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ObjectObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (ObjectObjectHashMap.this.keys[this.slot] != null) {
                        this.cursor.index = this.slot;
                        this.cursor.value = ObjectObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ObjectObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ObjectObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final ObjectObjectHashMap<KType, VType> owner;

        private ValuesContainer() {
            this.owner = ObjectObjectHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(VType value) {
            for (ObjectObjectCursor c : this.owner) {
                if (!Objects.equals(c.value, value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            for (ObjectObjectCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            for (ObjectObjectCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final VType e) {
            return this.owner.removeAll(new ObjectObjectPredicate<KType, VType>(){

                @Override
                public boolean apply(KType key, VType value) {
                    return Objects.equals(value, e);
                }
            });
        }

        @Override
        public int removeAll(final ObjectPredicate<? super VType> predicate) {
            return this.owner.removeAll(new ObjectObjectPredicate<KType, VType>(){

                @Override
                public boolean apply(KType key, VType value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ObjectObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    Object existing = ObjectObjectHashMap.this.keys[this.slot];
                    if (existing != null) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ObjectObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectObjectHashMap<KType, VType> owner;

        public KeysContainer() {
            this.owner = ObjectObjectHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(final T procedure) {
            this.owner.forEach(new ObjectObjectProcedure<KType, VType>(){

                @Override
                public void apply(KType key, VType value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(final T predicate) {
            this.owner.forEach(new ObjectObjectPredicate<KType, VType>(){

                @Override
                public boolean apply(KType key, VType value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectObjectCursor<KType, VType>> {
        private final ObjectObjectCursor<KType, VType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectObjectCursor();
        }

        @Override
        protected ObjectObjectCursor<KType, VType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    Object existing = ObjectObjectHashMap.this.keys[this.slot];
                    if (existing != null) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = ObjectObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ObjectObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = null;
                this.cursor.value = ObjectObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectObjectCursor)this.done();
        }
    }
}

