/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ObjectObjectHashMap;

public class ObjectObjectScatterMap<KType, VType>
extends ObjectObjectHashMap<KType, VType> {
    public ObjectObjectScatterMap() {
        this(4);
    }

    public ObjectObjectScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectObjectScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType, VType> ObjectObjectScatterMap<KType, VType> from(KType[] keys2, VType[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectObjectScatterMap<KType, VType> map = new ObjectObjectScatterMap<KType, VType>(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }
}

