/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.graphhopper.isochrone.algorithm.QuadEdgeSubdivisionAsReadableTriangulation;
import com.graphhopper.isochrone.algorithm.ReadableQuadEdge;
import com.graphhopper.isochrone.algorithm.Triangulation;
import com.graphhopper.isochrone.algorithm.TriangulationAsReadableTriangulation;
import java.util.Collection;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;

public interface ReadableTriangulation {
    public Collection<ReadableQuadEdge> getEdges();

    public static ReadableTriangulation wrap(Triangulation triangulation) {
        return new TriangulationAsReadableTriangulation(triangulation);
    }

    public static ReadableTriangulation wrap(QuadEdgeSubdivision quadEdgeSubdivision) {
        return new QuadEdgeSubdivisionAsReadableTriangulation(quadEdgeSubdivision);
    }

    public ReadableQuadEdge getEdge(int var1, int var2);

    public ReadableQuadEdge getVertexQuadEdge(int var1);
}

