/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader;

import com.graphhopper.reader.ReaderElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ReaderRelation
extends ReaderElement {
    protected List<Member> members;

    public ReaderRelation(long id) {
        super(id, ReaderElement.Type.RELATION, new HashMap<String, Object>(2));
    }

    @Override
    public String toString() {
        return "Relation (" + this.getId() + ", " + (this.members == null ? 0 : this.members.size()) + " members)";
    }

    public List<Member> getMembers() {
        if (this.members == null) {
            return Collections.emptyList();
        }
        return this.members;
    }

    public boolean isMetaRelation() {
        if (this.members != null) {
            for (Member member : this.members) {
                if (member.getType() != ReaderElement.Type.RELATION) continue;
                return true;
            }
        }
        return false;
    }

    public void add(Member member) {
        if (this.members == null) {
            this.members = new ArrayList<Member>(3);
        }
        this.members.add(member);
    }

    public static class Member {
        private final ReaderElement.Type type;
        private final long ref;
        private final String role;

        public Member(ReaderElement.Type type, long ref, String role) {
            this.type = type;
            this.ref = ref;
            this.role = role;
        }

        public String toString() {
            return "Member " + String.valueOf((Object)this.type) + ":" + this.ref;
        }

        public ReaderElement.Type getType() {
            return this.type;
        }

        public long getRef() {
            return this.ref;
        }

        public String getRole() {
            return this.role;
        }
    }
}

