/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;

public class ElevationInterpolator {
    public static final double EPSILON = 1.0E-5;
    public static final double EPSILON2 = 1.0000000000000002E-10;

    public double calculateElevationBasedOnTwoPoints(double lat, double lon, double lat0, double lon0, double ele0, double lat1, double lon1, double ele1) {
        double l1;
        double dlat0 = lat0 - lat;
        double dlon0 = lon0 - lon;
        double dlat1 = lat1 - lat;
        double dlon1 = lon1 - lon;
        double l0 = Math.sqrt(dlon0 * dlon0 + dlat0 * dlat0);
        double l = l0 + (l1 = Math.sqrt(dlon1 * dlon1 + dlat1 * dlat1));
        if (l < 1.0E-5) {
            return l0 <= l1 ? ele0 : ele1;
        }
        return Helper.round2(ele0 + (ele1 - ele0) * l0 / l);
    }

    public double calculateElevationBasedOnThreePoints(double lat, double lon, double lat0, double lon0, double ele0, double lat1, double lon1, double ele1, double lat2, double lon2, double ele2) {
        double dlat10 = lat1 - lat0;
        double dlon10 = lon1 - lon0;
        double dele10 = ele1 - ele0;
        double dlat20 = lat2 - lat0;
        double dlon20 = lon2 - lon0;
        double dele20 = ele2 - ele0;
        double a = dlon10 * dele20 - dele10 * dlon20;
        double b = dele10 * dlat20 - dlat10 * dele20;
        double c = dlat10 * dlon20 - dlon10 * dlat20;
        if (Math.abs(c) < 1.0E-5) {
            double dlat21 = lat2 - lat1;
            double dlon21 = lon2 - lon1;
            double dele21 = ele2 - ele1;
            double l10 = dlat10 * dlat10 + dlon10 * dlon10 + dele10 * dele10;
            double l20 = dlat20 * dlat20 + dlon20 * dlon20 + dele20 * dele20;
            double l21 = dlat21 * dlat21 + dlon21 * dlon21 + dele21 * dele21;
            if (l21 > l10 && l21 > l20) {
                return this.calculateElevationBasedOnTwoPoints(lat, lon, lat1, lon1, ele1, lat2, lon2, ele2);
            }
            if (l20 > l10 && l20 > l21) {
                return this.calculateElevationBasedOnTwoPoints(lat, lon, lat0, lon0, ele0, lat2, lon2, ele2);
            }
            return this.calculateElevationBasedOnTwoPoints(lat, lon, lat0, lon0, ele0, lat1, lon1, ele1);
        }
        double d = a * lat0 + b * lon0 + c * ele0;
        double ele = (d - a * lat - b * lon) / c;
        return Helper.round2(ele);
    }

    public double calculateElevationBasedOnPointList(double lat, double lon, PointList pointList) {
        int size = pointList.size();
        if (size == 0) {
            throw new IllegalArgumentException("At least one point is required in the pointList.");
        }
        if (size == 1) {
            return pointList.getEle(0);
        }
        if (size == 2) {
            return this.calculateElevationBasedOnTwoPoints(lat, lon, pointList.getLat(0), pointList.getLon(0), pointList.getEle(0), pointList.getLat(1), pointList.getLon(1), pointList.getEle(1));
        }
        if (size == 3) {
            return this.calculateElevationBasedOnThreePoints(lat, lon, pointList.getLat(0), pointList.getLon(0), pointList.getEle(0), pointList.getLat(1), pointList.getLon(1), pointList.getEle(1), pointList.getLat(2), pointList.getLon(2), pointList.getEle(2));
        }
        double[] vs = new double[size];
        double[] eles = new double[size];
        double v = 0.0;
        for (int index = 0; index < size; ++index) {
            double lati = pointList.getLat(index);
            double loni = pointList.getLon(index);
            double dlati = lati - lat;
            double dloni = loni - lon;
            double l2 = dlati * dlati + dloni * dloni;
            eles[index] = pointList.getEle(index);
            if (l2 < 1.0000000000000002E-10) {
                return eles[index];
            }
            vs[index] = 1.0 / l2;
            v += vs[index];
        }
        double ele = 0.0;
        for (int index = 0; index < size; ++index) {
            ele += eles[index] * vs[index] / v;
        }
        return Helper.round2(ele);
    }
}

