/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.reader.dem.AbstractSRTMElevationProvider;
import com.graphhopper.util.Helper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SRTMProvider
extends AbstractSRTMElevationProvider {
    private final GHIntObjectHashMap<String> areas = new GHIntObjectHashMap();

    public SRTMProvider() {
        this("");
    }

    public SRTMProvider(String cacheDir) {
        super("https://srtm.kurviger.de/SRTM3/", cacheDir.isEmpty() ? "/tmp/srtm" : cacheDir, "GraphHopper SRTMReader", -56, 60, 1201);
        this.init();
    }

    public static void main(String[] args2) throws IOException {
        SRTMProvider provider = new SRTMProvider();
        System.out.println(provider.getEle(49.949784, 11.57517));
        System.out.println(provider.getEle(49.968668, 11.575127));
        System.out.println(provider.getEle(49.968682, 11.574842));
        System.out.println(provider.getEle(-22.532854, -65.110474));
        System.out.println(provider.getEle(38.065392, -87.099609));
        System.out.println(provider.getEle(40.0, -105.2277023));
        System.out.println(provider.getEle(39.99999999, -105.2277023));
        System.out.println(provider.getEle(39.9999999, -105.2277023));
        System.out.println(provider.getEle(39.999999, -105.2277023));
        System.out.println(provider.getEle(47.468668, 14.575127));
        System.out.println(provider.getEle(47.467753, 14.573911));
        System.out.println(provider.getEle(46.468835, 12.578777));
        System.out.println(provider.getEle(48.469123, 9.576393));
    }

    private SRTMProvider init() {
        try {
            String[] strs;
            for (String str : strs = new String[]{"Africa", "Australia", "Eurasia", "Islands", "North_America", "South_America"}) {
                InputStream is = this.getClass().getResourceAsStream(str + "_names.txt");
                for (String line : Helper.readFile(new InputStreamReader(is, Helper.UTF_CS))) {
                    int intKey;
                    String key;
                    int lat = Integer.parseInt(line.substring(1, 3));
                    if (line.substring(0, 1).charAt(0) == 'S') {
                        lat = -lat;
                    }
                    int lon = Integer.parseInt(line.substring(4, 7));
                    if (line.substring(3, 4).charAt(0) == 'W') {
                        lon = -lon;
                    }
                    if ((key = this.areas.put(intKey = this.calcIntKey(lat, lon), str)) == null) continue;
                    throw new IllegalStateException("do not overwrite existing! key " + intKey + " " + key + " vs. " + str);
                }
            }
            return this;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot load area names from classpath", ex);
        }
    }

    public String toString() {
        return "srtm";
    }

    @Override
    byte[] readFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        BufferedInputStream buff = new BufferedInputStream(is, 8192);
        try (ZipInputStream zis = new ZipInputStream(buff);){
            ZipEntry entry = zis.getNextEntry();
            if (entry == null) {
                throw new RuntimeException("No entry found in zip file " + String.valueOf(file));
            }
            int bufferSize = (int)Math.max(entry.getSize(), 65536L);
            ByteArrayOutputStream os = new ByteArrayOutputStream(bufferSize);
            zis.transferTo(os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    @Override
    String getFileName(double lat, double lon) {
        int intKey = this.calcIntKey(lat, lon);
        Object str = (String)this.areas.get(intKey);
        if (str == null) {
            return null;
        }
        int minLat = Math.abs(this.down(lat));
        int minLon = Math.abs(this.down(lon));
        str = (String)str + "/";
        str = lat >= 0.0 ? (String)str + "N" : (String)str + "S";
        if (minLat < 10) {
            str = (String)str + "0";
        }
        str = (String)str + minLat;
        str = lon >= 0.0 ? (String)str + "E" : (String)str + "W";
        if (minLon < 10) {
            str = (String)str + "0";
        }
        if (minLon < 100) {
            str = (String)str + "0";
        }
        str = (String)str + minLon;
        return str;
    }

    @Override
    String getDownloadURL(double lat, double lon) {
        return this.getFileName(lat, lon) + ".hgt.zip";
    }
}

