/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.DirectionResolver;
import com.graphhopper.routing.DirectionResolverResult;
import com.graphhopper.routing.EdgeRestrictions;
import com.graphhopper.routing.HeadingResolver;
import com.graphhopper.routing.MultiplePointsNotFoundException;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathCalculator;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.DirectedEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.HeadingEdgeFilter;
import com.graphhopper.routing.util.NameSimilarityEdgeFilter;
import com.graphhopper.routing.util.SnapPreventionEdgeFilter;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.List;

public class ViaRouting {
    public static List<Snap> lookup(EncodedValueLookup lookup, List<GHPoint> points, EdgeFilter snapFilter, LocationIndex locationIndex, List<String> snapPreventions, List<String> pointHints, DirectedEdgeFilter directedSnapFilter, List<Double> headings) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("At least 2 points have to be specified, but was:" + points.size());
        }
        EnumEncodedValue<RoadClass> roadClassEnc = lookup.getEnumEncodedValue("road_class", RoadClass.class);
        EnumEncodedValue<RoadEnvironment> roadEnvEnc = lookup.getEnumEncodedValue("road_environment", RoadEnvironment.class);
        EdgeFilter strictEdgeFilter = snapPreventions.isEmpty() ? snapFilter : new SnapPreventionEdgeFilter(snapFilter, roadClassEnc, roadEnvEnc, snapPreventions);
        ArrayList<Snap> snaps = new ArrayList<Snap>(points.size());
        IntArrayList pointsNotFound = new IntArrayList();
        for (int placeIndex = 0; placeIndex < points.size(); ++placeIndex) {
            GHPoint point = points.get(placeIndex);
            Snap snap = null;
            if (placeIndex < headings.size() && !Double.isNaN(headings.get(placeIndex))) {
                if (!pointHints.isEmpty() && !Helper.isEmpty(pointHints.get(placeIndex))) {
                    throw new IllegalArgumentException("Cannot specify heading and point_hint at the same time. Make sure you specify either an empty point_hint (String) or a NaN heading (double) for point " + placeIndex);
                }
                snap = locationIndex.findClosest(point.lat, point.lon, new HeadingEdgeFilter(directedSnapFilter, headings.get(placeIndex), point));
            } else if (!pointHints.isEmpty()) {
                snap = locationIndex.findClosest(point.lat, point.lon, new NameSimilarityEdgeFilter(strictEdgeFilter, pointHints.get(placeIndex), point, 170.0));
            } else if (!snapPreventions.isEmpty()) {
                snap = locationIndex.findClosest(point.lat, point.lon, strictEdgeFilter);
            }
            if (snap == null || !snap.isValid()) {
                snap = locationIndex.findClosest(point.lat, point.lon, snapFilter);
            }
            if (!snap.isValid()) {
                pointsNotFound.add(placeIndex);
            }
            snaps.add(snap);
        }
        if (!pointsNotFound.isEmpty()) {
            throw new MultiplePointsNotFoundException(pointsNotFound);
        }
        return snaps;
    }

    public static Result calcPaths(List<GHPoint> points, QueryGraph queryGraph, List<Snap> snaps, DirectedEdgeFilter directedEdgeFilter, PathCalculator pathCalculator, List<String> curbsides, String curbsideStrictness, List<Double> headings, boolean passThrough) {
        if (!curbsides.isEmpty() && curbsides.size() != points.size()) {
            throw new IllegalArgumentException("If you pass curbside, you need to pass exactly one curbside for every point, empty curbsides will be ignored");
        }
        if (!curbsides.isEmpty() && !headings.isEmpty()) {
            throw new IllegalArgumentException("You cannot use curbsides and headings or pass_through at the same time");
        }
        int legs = snaps.size() - 1;
        Result result = new Result(legs);
        for (int leg = 0; leg < legs; ++leg) {
            Path prevRoute;
            Snap fromSnap = snaps.get(leg);
            Snap toSnap = snaps.get(leg + 1);
            double fromHeading = leg == 0 && !headings.isEmpty() ? headings.get(0) : Double.NaN;
            double toHeading = snaps.size() == headings.size() && !Double.isNaN(headings.get(leg + 1)) ? headings.get(leg + 1) : Double.NaN;
            int incomingEdge = -1;
            if (leg != 0 && (prevRoute = result.paths.get(leg - 1)).getEdgeCount() > 0) {
                incomingEdge = prevRoute.getFinalEdge().getEdge();
            }
            String fromCurbside = curbsides.isEmpty() ? "any" : curbsides.get(leg);
            String toCurbside = curbsides.isEmpty() ? "any" : curbsides.get(leg + 1);
            EdgeRestrictions edgeRestrictions = ViaRouting.buildEdgeRestrictions(queryGraph, fromSnap, toSnap, fromHeading, toHeading, incomingEdge, passThrough, fromCurbside, toCurbside, directedEdgeFilter);
            edgeRestrictions.setSourceOutEdge(ViaRouting.ignoreThrowOrAcceptImpossibleCurbsides(curbsides, edgeRestrictions.getSourceOutEdge(), leg, curbsideStrictness));
            edgeRestrictions.setTargetInEdge(ViaRouting.ignoreThrowOrAcceptImpossibleCurbsides(curbsides, edgeRestrictions.getTargetInEdge(), leg + 1, curbsideStrictness));
            List<Path> paths = pathCalculator.calcPaths(fromSnap.getClosestNode(), toSnap.getClosestNode(), edgeRestrictions);
            result.debug = result.debug + pathCalculator.getDebugString();
            for (int i = 0; i < paths.size(); ++i) {
                Path path = paths.get(i);
                if (path.getTime() < 0L) {
                    throw new RuntimeException("Time was negative " + path.getTime() + " for index " + i);
                }
                result.paths.add(path);
                result.debug = result.debug + ", " + path.getDebugInfo();
            }
            result.visitedNodes += (long)pathCalculator.getVisitedNodes();
            result.debug = result.debug + ", visited nodes sum: " + result.visitedNodes;
        }
        return result;
    }

    private static EdgeRestrictions buildEdgeRestrictions(QueryGraph queryGraph, Snap fromSnap, Snap toSnap, double fromHeading, double toHeading, int incomingEdge, boolean passThrough, String fromCurbside, String toCurbside, DirectedEdgeFilter edgeFilter) {
        EdgeRestrictions edgeRestrictions = new EdgeRestrictions();
        if (!fromCurbside.equals("any") || !toCurbside.equals("any")) {
            DirectedEdgeFilter directedEdgeFilter = (edge, reverse) -> {
                if (queryGraph.isVirtualEdge(edge.getEdge())) {
                    EdgeIteratorState virtualEdge = queryGraph.getEdgeIteratorStateForKey(edge.getEdgeKey());
                    EdgeIteratorState origEdge = queryGraph.getEdgeIteratorStateForKey(((VirtualEdgeIteratorState)virtualEdge).getOriginalEdgeKey());
                    return edgeFilter.accept(origEdge, reverse);
                }
                return edgeFilter.accept(edge, reverse);
            };
            DirectionResolver directionResolver = new DirectionResolver(queryGraph, directedEdgeFilter);
            DirectionResolverResult fromDirection = directionResolver.resolveDirections(fromSnap.getClosestNode(), fromSnap.getQueryPoint());
            DirectionResolverResult toDirection = directionResolver.resolveDirections(toSnap.getClosestNode(), toSnap.getQueryPoint());
            int sourceOutEdge = DirectionResolverResult.getOutEdge(fromDirection, fromCurbside);
            int targetInEdge = DirectionResolverResult.getInEdge(toDirection, toCurbside);
            if (fromSnap.getClosestNode() == toSnap.getClosestNode() && (Helper.isEmpty(fromCurbside) || Helper.isEmpty(toCurbside) || fromCurbside.equals("any") || toCurbside.equals("any") || fromCurbside.equals(toCurbside))) {
                sourceOutEdge = -2;
                targetInEdge = -2;
            }
            edgeRestrictions.setSourceOutEdge(sourceOutEdge);
            edgeRestrictions.setTargetInEdge(targetInEdge);
        }
        if (!Double.isNaN(fromHeading) || !Double.isNaN(toHeading)) {
            HeadingResolver headingResolver = new HeadingResolver(queryGraph);
            if (!Double.isNaN(fromHeading)) {
                edgeRestrictions.getUnfavoredEdges().addAll(headingResolver.getEdgesWithDifferentHeading(fromSnap.getClosestNode(), fromHeading));
            }
            if (!Double.isNaN(toHeading)) {
                if ((toHeading += 180.0) > 360.0) {
                    toHeading -= 360.0;
                }
                edgeRestrictions.getUnfavoredEdges().addAll(headingResolver.getEdgesWithDifferentHeading(toSnap.getClosestNode(), toHeading));
            }
        }
        if (incomingEdge != -1 && passThrough) {
            edgeRestrictions.getUnfavoredEdges().add(incomingEdge);
        }
        return edgeRestrictions;
    }

    private static int ignoreThrowOrAcceptImpossibleCurbsides(List<String> curbsides, int edge, int placeIndex, String curbsideStrictness) {
        if (edge != -1) {
            return edge;
        }
        if ("strict".equals(curbsideStrictness)) {
            return ViaRouting.throwImpossibleCurbsideConstraint(curbsides, placeIndex);
        }
        if ("soft".equals(curbsideStrictness)) {
            return -2;
        }
        throw new IllegalArgumentException("Unknown curbside_strictness " + curbsideStrictness);
    }

    private static int throwImpossibleCurbsideConstraint(List<String> curbsides, int placeIndex) {
        throw new IllegalArgumentException("Impossible curbside constraint: 'curbside=" + curbsides.get(placeIndex) + "' at point " + placeIndex);
    }

    public static class Result {
        public List<Path> paths;
        public long visitedNodes;
        public String debug = "";

        Result(int legs) {
            this.paths = new ArrayList<Path>(legs);
        }
    }
}

