/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.graphhopper.routing.ev.EncodedValue;

public class EncodedValueSerializer {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String serializeEncodedValue(EncodedValue encodedValue) {
        try {
            Object tree = MAPPER.valueToTree(encodedValue);
            return MAPPER.writeValueAsString(tree);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not serialize encoded value: " + String.valueOf(encodedValue) + ", error: " + e.getMessage());
        }
    }

    public static EncodedValue deserializeEncodedValue(String serializedEncodedValue) {
        try {
            JsonNode jsonNode = MAPPER.readTree(serializedEncodedValue);
            return MAPPER.treeToValue((TreeNode)jsonNode, EncodedValue.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not deserialize encoded value: " + serializedEncodedValue + ", error: " + e.getMessage());
        }
    }

    static {
        MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        MAPPER.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
    }
}

