/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.util.PMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ImportUnit {
    private final String name;
    private final Function<PMap, EncodedValue> createEncodedValue;
    private final BiFunction<EncodedValueLookup, PMap, TagParser> createTagParser;
    private final List<String> requiredImportUnits;

    public static ImportUnit create(String name, Function<PMap, EncodedValue> createEncodedValue, BiFunction<EncodedValueLookup, PMap, TagParser> createTagParser, String ... requiredImportUnits) {
        return new ImportUnit(name, createEncodedValue, createTagParser, List.of(requiredImportUnits));
    }

    private ImportUnit(String name, Function<PMap, EncodedValue> createEncodedValue, BiFunction<EncodedValueLookup, PMap, TagParser> createTagParser, List<String> requiredImportUnits) {
        this.name = name;
        this.createEncodedValue = createEncodedValue;
        this.createTagParser = createTagParser;
        this.requiredImportUnits = requiredImportUnits;
    }

    public Function<PMap, EncodedValue> getCreateEncodedValue() {
        return this.createEncodedValue;
    }

    public BiFunction<EncodedValueLookup, PMap, TagParser> getCreateTagParser() {
        return this.createTagParser;
    }

    public List<String> getRequiredImportUnits() {
        return this.requiredImportUnits;
    }

    public String toString() {
        return "ImportUnit: " + this.name + " (requires: " + String.valueOf(this.requiredImportUnits) + ")";
    }
}

