/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.util.Helper;

public enum RoadAccess {
    YES,
    DESTINATION,
    CUSTOMERS,
    DELIVERY,
    PRIVATE,
    AGRICULTURAL,
    FORESTRY,
    NO;

    public static final String KEY = "road_access";

    public static EnumEncodedValue<RoadAccess> create() {
        return new EnumEncodedValue<RoadAccess>(KEY, RoadAccess.class);
    }

    public String toString() {
        return Helper.toLowerCase(super.toString());
    }

    public static RoadAccess find(String name) {
        if (name == null) {
            return YES;
        }
        if (name.equalsIgnoreCase("permit")) {
            return PRIVATE;
        }
        try {
            return RoadAccess.valueOf(Helper.toUpperCase(name));
        }
        catch (IllegalArgumentException ex) {
            return YES;
        }
    }

    public static RoadAccess countryHook(ReaderWay readerWay, RoadAccess roadAccess) {
        CountryRule countryRule = readerWay.getTag("country_rule", null);
        return countryRule == null ? roadAccess : countryRule.getAccess(readerWay, TransportationMode.CAR, roadAccess == null ? YES : roadAccess);
    }
}

