/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.util.Helper;
import java.util.HashMap;
import java.util.Map;

public enum Surface {
    MISSING,
    PAVED,
    ASPHALT,
    CONCRETE,
    PAVING_STONES,
    COBBLESTONE,
    UNPAVED,
    COMPACTED,
    FINE_GRAVEL,
    GRAVEL,
    GROUND,
    DIRT,
    GRASS,
    SAND,
    WOOD,
    OTHER;

    public static final String KEY = "surface";
    private static final Map<String, Surface> SURFACE_MAP;

    public static EnumEncodedValue<Surface> create() {
        return new EnumEncodedValue<Surface>(KEY, Surface.class);
    }

    public String toString() {
        return Helper.toLowerCase(super.toString());
    }

    public static Surface find(String name) {
        if (Helper.isEmpty(name)) {
            return MISSING;
        }
        int colonIndex = name.indexOf(":");
        if (colonIndex != -1) {
            name = name.substring(0, colonIndex);
        }
        return SURFACE_MAP.getOrDefault(name, OTHER);
    }

    static {
        SURFACE_MAP = new HashMap<String, Surface>();
        for (Surface surface : Surface.values()) {
            if (surface == MISSING || surface == OTHER) continue;
            SURFACE_MAP.put(surface.toString(), surface);
        }
        SURFACE_MAP.put("metal", PAVED);
        SURFACE_MAP.put("sett", COBBLESTONE);
        SURFACE_MAP.put("unhewn_cobblestone", COBBLESTONE);
        SURFACE_MAP.put("earth", DIRT);
        SURFACE_MAP.put("pebblestone", GRAVEL);
        SURFACE_MAP.put("grass_paver", GRASS);
    }
}

