/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.querygraph;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointList;
import java.util.List;
import java.util.Map;

class VirtualEdgeIterator
implements EdgeIterator {
    private final EdgeFilter edgeFilter;
    private List<EdgeIteratorState> edges;
    private int current;

    VirtualEdgeIterator(EdgeFilter edgeFilter, List<EdgeIteratorState> edges) {
        this.edges = edges;
        this.current = -1;
        this.edgeFilter = edgeFilter;
    }

    EdgeIterator reset(List<EdgeIteratorState> edges) {
        this.edges = edges;
        this.current = -1;
        return this;
    }

    @Override
    public boolean next() {
        ++this.current;
        while (this.current < this.edges.size() && !this.edgeFilter.accept(this.edges.get(this.current))) {
            ++this.current;
        }
        return this.current < this.edges.size();
    }

    @Override
    public EdgeIteratorState detach(boolean reverse) {
        if (reverse) {
            throw new IllegalStateException("Not yet supported");
        }
        return this.getCurrentEdge();
    }

    @Override
    public int getEdge() {
        return this.getCurrentEdge().getEdge();
    }

    @Override
    public int getEdgeKey() {
        return this.getCurrentEdge().getEdgeKey();
    }

    @Override
    public int getReverseEdgeKey() {
        return this.getCurrentEdge().getReverseEdgeKey();
    }

    @Override
    public int getBaseNode() {
        return this.getCurrentEdge().getBaseNode();
    }

    @Override
    public int getAdjNode() {
        return this.getCurrentEdge().getAdjNode();
    }

    @Override
    public PointList fetchWayGeometry(FetchMode mode) {
        return this.getCurrentEdge().fetchWayGeometry(mode);
    }

    @Override
    public EdgeIteratorState setWayGeometry(PointList list) {
        return this.getCurrentEdge().setWayGeometry(list);
    }

    @Override
    public double getDistance() {
        return this.getCurrentEdge().getDistance();
    }

    @Override
    public EdgeIteratorState setDistance(double dist) {
        return this.getCurrentEdge().setDistance(dist);
    }

    @Override
    public IntsRef getFlags() {
        return this.getCurrentEdge().getFlags();
    }

    @Override
    public EdgeIteratorState setFlags(IntsRef flags) {
        return this.getCurrentEdge().setFlags(flags);
    }

    @Override
    public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
        this.getCurrentEdge().set(property, value);
        return this;
    }

    @Override
    public boolean get(BooleanEncodedValue property) {
        return this.getCurrentEdge().get(property);
    }

    @Override
    public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
        this.getCurrentEdge().setReverse(property, value);
        return this;
    }

    @Override
    public boolean getReverse(BooleanEncodedValue property) {
        return this.getCurrentEdge().getReverse(property);
    }

    @Override
    public EdgeIteratorState set(BooleanEncodedValue property, boolean fwd, boolean bwd) {
        this.getCurrentEdge().set(property, fwd, bwd);
        return this;
    }

    @Override
    public EdgeIteratorState set(IntEncodedValue property, int value) {
        this.getCurrentEdge().set(property, value);
        return this;
    }

    @Override
    public int get(IntEncodedValue property) {
        return this.getCurrentEdge().get(property);
    }

    @Override
    public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
        this.getCurrentEdge().setReverse(property, value);
        return this;
    }

    @Override
    public int getReverse(IntEncodedValue property) {
        return this.getCurrentEdge().getReverse(property);
    }

    @Override
    public EdgeIteratorState set(IntEncodedValue property, int fwd, int bwd) {
        this.getCurrentEdge().set(property, fwd, bwd);
        return this;
    }

    @Override
    public EdgeIteratorState set(DecimalEncodedValue property, double value) {
        this.getCurrentEdge().set(property, value);
        return this;
    }

    @Override
    public double get(DecimalEncodedValue property) {
        return this.getCurrentEdge().get(property);
    }

    @Override
    public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
        this.getCurrentEdge().setReverse(property, value);
        return this;
    }

    @Override
    public double getReverse(DecimalEncodedValue property) {
        return this.getCurrentEdge().getReverse(property);
    }

    @Override
    public EdgeIteratorState set(DecimalEncodedValue property, double fwd, double bwd) {
        this.getCurrentEdge().set(property, fwd, bwd);
        return this;
    }

    @Override
    public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
        this.getCurrentEdge().set(property, value);
        return this;
    }

    @Override
    public <T extends Enum<?>> T get(EnumEncodedValue<T> property) {
        return this.getCurrentEdge().get(property);
    }

    @Override
    public <T extends Enum<?>> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
        this.getCurrentEdge().setReverse(property, value);
        return this;
    }

    @Override
    public <T extends Enum<?>> T getReverse(EnumEncodedValue<T> property) {
        return this.getCurrentEdge().getReverse(property);
    }

    @Override
    public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T fwd, T bwd) {
        this.getCurrentEdge().set(property, fwd, bwd);
        return this;
    }

    @Override
    public String get(StringEncodedValue property) {
        return this.getCurrentEdge().get(property);
    }

    @Override
    public EdgeIteratorState set(StringEncodedValue property, String value) {
        return this.getCurrentEdge().set(property, value);
    }

    @Override
    public String getReverse(StringEncodedValue property) {
        return this.getCurrentEdge().getReverse(property);
    }

    @Override
    public EdgeIteratorState setReverse(StringEncodedValue property, String value) {
        return this.getCurrentEdge().setReverse(property, value);
    }

    @Override
    public EdgeIteratorState set(StringEncodedValue property, String fwd, String bwd) {
        return this.getCurrentEdge().set(property, fwd, bwd);
    }

    @Override
    public String getName() {
        return this.getCurrentEdge().getName();
    }

    @Override
    public Map<String, KVStorage.KValue> getKeyValues() {
        return this.getCurrentEdge().getKeyValues();
    }

    @Override
    public EdgeIteratorState setKeyValues(Map<String, KVStorage.KValue> list) {
        return this.getCurrentEdge().setKeyValues(list);
    }

    @Override
    public Object getValue(String key) {
        return this.getCurrentEdge().getValue(key);
    }

    public String toString() {
        if (this.current >= 0 && this.current < this.edges.size()) {
            return "virtual edge: " + String.valueOf(this.getCurrentEdge()) + ", all: " + this.edges.toString();
        }
        return "virtual edge: (invalid), all: " + this.edges.toString();
    }

    @Override
    public EdgeIteratorState copyPropertiesFrom(EdgeIteratorState edge) {
        return this.getCurrentEdge().copyPropertiesFrom(edge);
    }

    private EdgeIteratorState getCurrentEdge() {
        return this.edges.get(this.current);
    }

    public List<EdgeIteratorState> getEdges() {
        return this.edges;
    }
}

