/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.util.JsonFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class CustomArea
implements AreaIndex.Area {
    private final Map<String, Object> properties;
    private final List<Polygon> borders;
    private final double area;

    public static CustomArea fromJsonFeature(JsonFeature j) {
        ArrayList<Polygon> borders = new ArrayList<Polygon>();
        for (int i = 0; i < j.getGeometry().getNumGeometries(); ++i) {
            Geometry geometry = j.getGeometry().getGeometryN(i);
            if (!(geometry instanceof Polygon)) {
                throw new IllegalArgumentException("Custom area features must be of type 'Polygon', but was: " + geometry.getClass().getSimpleName());
            }
            borders.add((Polygon)geometry);
        }
        return new CustomArea(j.getProperties(), borders);
    }

    public CustomArea(Map<String, Object> properties, List<Polygon> borders) {
        this.properties = properties;
        this.borders = borders;
        this.area = borders.stream().map(Polygon::getArea).reduce(0.0, Double::sum);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public List<Polygon> getBorders() {
        return this.borders;
    }

    public double getArea() {
        return this.area;
    }
}

