/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.OSMTemporalAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BikeCommonAccessParser
extends AbstractAccessParser
implements TagParser {
    private static final Set<String> OPP_LANES = new HashSet<String>(Arrays.asList("opposite", "opposite_lane", "opposite_track"));
    private final Set<String> allowedHighways = new HashSet<String>();
    private final BooleanEncodedValue roundaboutEnc;
    private static final List<String> RESTRICTIONS = Arrays.asList("bicycle", "access");
    private static final Collection<String> FWDONEWAYS = Arrays.asList("yes", "true", "1");

    protected BikeCommonAccessParser(BooleanEncodedValue accessEnc, BooleanEncodedValue roundaboutEnc) {
        super(accessEnc, RESTRICTIONS);
        this.roundaboutEnc = roundaboutEnc;
        this.restrictedValues.add("agricultural");
        this.restrictedValues.add("forestry");
        this.restrictedValues.add("delivery");
        this.barriers.add("fence");
        this.allowedHighways.addAll(Arrays.asList("living_street", "steps", "cycleway", "path", "footway", "platform", "pedestrian", "track", "service", "residential", "unclassified", "road", "bridleway", "motorway", "motorway_link", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link"));
    }

    public WayAccess getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            String bikeTag;
            WayAccess access = WayAccess.CAN_SKIP;
            if (FerrySpeedCalculator.isFerry(way) && ((bikeTag = way.getTag("bicycle")) == null && !way.hasTag("foot", new String[0]) || this.allowedValues.contains(bikeTag))) {
                access = WayAccess.FERRY;
            }
            if (way.hasTag("railway", (Object)"platform")) {
                access = WayAccess.WAY;
            }
            if (way.hasTag("man_made", (Object)"pier")) {
                access = WayAccess.WAY;
            }
            if (!access.canSkip()) {
                if (way.hasTag((List<String>)this.restrictionKeys, (Collection<String>)this.restrictedValues)) {
                    return WayAccess.CAN_SKIP;
                }
                return access;
            }
            return WayAccess.CAN_SKIP;
        }
        if (!this.allowedHighways.contains(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("bicycle", (Object)"dismount")) {
            return WayAccess.WAY;
        }
        int firstIndex = way.getFirstIndex(this.restrictionKeys);
        if (firstIndex >= 0) {
            String[] restrict;
            String firstValue = way.getTag((String)this.restrictionKeys.get(firstIndex), "");
            for (String value : restrict = firstValue.split(";")) {
                if (!this.allowedValues.contains(value)) continue;
                return WayAccess.WAY;
            }
            for (String value : restrict) {
                if (!this.restrictedValues.contains(value) || OSMTemporalAccessParser.hasPermissiveTemporalRestriction(way, firstIndex, this.restrictionKeys, this.allowedValues)) continue;
                return WayAccess.CAN_SKIP;
            }
        }
        if ("motorway".equals(highwayValue) || "motorway_link".equals(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("motorroad", (Object)"yes")) {
            return WayAccess.CAN_SKIP;
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return;
        }
        if (access.isFerry()) {
            this.accessEnc.setBool(false, edgeId, edgeIntAccess, true);
            this.accessEnc.setBool(true, edgeId, edgeIntAccess, true);
        } else {
            this.handleAccess(edgeId, edgeIntAccess, way);
        }
        if (way.hasTag("gh:barrier_edge", new String[0])) {
            List nodeTags = way.getTag("node_tags", Collections.emptyList());
            this.handleBarrierEdge(edgeId, edgeIntAccess, (Map)nodeTags.get(0));
        }
    }

    protected void handleAccess(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way) {
        boolean isOneway;
        boolean bl = isOneway = way.hasTag("oneway", (Collection<String>)ONEWAYS) && !way.hasTag("oneway", (Object)"-1") && !way.hasTag("bicycle:backward", (Collection<String>)this.allowedValues) || way.hasTag("oneway", (Object)"-1") && !way.hasTag("bicycle:forward", (Collection<String>)this.allowedValues) || way.hasTag("oneway:bicycle", (Collection<String>)ONEWAYS) || way.hasTag("cycleway:left:oneway", FWDONEWAYS) && !way.hasTag("cycleway:right:oneway", (Object)"-1") || way.hasTag("cycleway:right:oneway", FWDONEWAYS) && !way.hasTag("cycleway:left:oneway", (Object)"-1") || way.hasTag("vehicle:backward", (Collection<String>)this.restrictedValues) && !way.hasTag("bicycle:forward", (Collection<String>)this.allowedValues) || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) && !way.hasTag("bicycle:backward", (Collection<String>)this.allowedValues) || way.hasTag("bicycle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("bicycle:backward", (Collection<String>)this.restrictedValues);
        if (!(!isOneway && !this.roundaboutEnc.getBool(false, edgeId, edgeIntAccess) || way.hasTag("oneway:bicycle", (Object)"no") || way.hasTag("cycleway:both", new String[0]) && !way.hasTag("cycleway:both", (Object)"no") || way.hasTag("cycleway", OPP_LANES) || way.hasTag("cycleway:left", OPP_LANES) || way.hasTag("cycleway:right", OPP_LANES) || way.hasTag("cycleway:left:oneway", (Object)"no") || way.hasTag("cycleway:right:oneway", (Object)"no"))) {
            boolean isBackward = way.hasTag("oneway", (Object)"-1") || way.hasTag("oneway:bicycle", (Object)"-1") || way.hasTag("cycleway:left:oneway", (Object)"-1") || way.hasTag("cycleway:right:oneway", (Object)"-1") || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("bicycle:forward", (Collection<String>)this.restrictedValues);
            this.accessEnc.setBool(isBackward, edgeId, edgeIntAccess, true);
        } else {
            this.accessEnc.setBool(true, edgeId, edgeIntAccess, true);
            this.accessEnc.setBool(false, edgeId, edgeIntAccess, true);
        }
    }
}

