/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class OSMRoadAccessParser<T extends Enum>
implements TagParser {
    protected final EnumEncodedValue<T> accessEnc;
    private final List<String> restrictions;
    private final Function<String, T> valueFinder;
    private final BiFunction<ReaderWay, T, T> countryHook;

    public OSMRoadAccessParser(EnumEncodedValue<T> accessEnc, List<String> restrictions, BiFunction<ReaderWay, T, T> countryHook, Function<String, T> valueFinder) {
        this.accessEnc = accessEnc;
        this.restrictions = restrictions;
        this.valueFinder = valueFinder;
        this.countryHook = countryHook;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay readerWay, IntsRef relationFlags) {
        String restriction2;
        Enum accessValue = null;
        List nodeTags = readerWay.getTag("node_tags", Collections.emptyList());
        if (readerWay.hasTag("gh:barrier_edge", new String[0])) {
            for (String restriction2 : this.restrictions) {
                Object value = ((Map)nodeTags.get(0)).get(restriction2);
                accessValue = this.getRoadAccess((String)value, accessValue);
                if (accessValue == null) continue;
                break;
            }
        }
        Iterator<String> iterator2 = this.restrictions.iterator();
        while (iterator2.hasNext() && (accessValue = this.getRoadAccess(readerWay.getTag(restriction2 = iterator2.next()), accessValue)) == null) {
        }
        if ((accessValue = (Enum)this.countryHook.apply(readerWay, (ReaderWay)((Object)accessValue))) != null) {
            this.accessEnc.setEnum(false, edgeId, edgeIntAccess, accessValue);
        }
    }

    private T getRoadAccess(String tagValue, T accessValue) {
        if (tagValue != null) {
            String[] complex;
            for (String simple : complex = tagValue.split(";")) {
                Enum tmpAccessValue = (Enum)this.valueFinder.apply(simple);
                if (tmpAccessValue == null || accessValue != null && tmpAccessValue.ordinal() >= ((Enum)accessValue).ordinal()) continue;
                accessValue = tmpAccessValue;
            }
        }
        return (T)accessValue;
    }

    public static List<String> toOSMRestrictions(TransportationMode mode) {
        switch (mode) {
            case FOOT: {
                return Arrays.asList("foot", "access");
            }
            case VEHICLE: {
                return Arrays.asList("vehicle", "access");
            }
            case BIKE: {
                return Arrays.asList("bicycle", "vehicle", "access");
            }
            case CAR: {
                return Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access");
            }
            case MOTORCYCLE: {
                return Arrays.asList("motorcycle", "motor_vehicle", "vehicle", "access");
            }
            case HGV: {
                return Arrays.asList("hgv", "motor_vehicle", "vehicle", "access");
            }
            case PSV: {
                return Arrays.asList("psv", "motor_vehicle", "vehicle", "access");
            }
            case TRAIN: {
                return Arrays.asList("access");
            }
            case BUS: {
                return Arrays.asList("bus", "psv", "motor_vehicle", "vehicle", "access");
            }
            case HOV: {
                return Arrays.asList("hov", "motor_vehicle", "vehicle", "access");
            }
        }
        throw new IllegalArgumentException("Cannot convert TransportationMode " + String.valueOf((Object)mode) + " to list of restrictions");
    }
}

