/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.weighting.custom.ClassHelper;
import com.graphhopper.routing.weighting.custom.CustomWeightingHelper;
import com.graphhopper.routing.weighting.custom.NameValidator;
import com.graphhopper.routing.weighting.custom.ParseResult;
import com.graphhopper.util.Helper;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.TokenType;
import org.codehaus.janino.Visitor;

class ConditionalExpressionVisitor
implements Visitor.AtomVisitor<Boolean, Exception> {
    private static final Set<String> allowedMethodParents = new HashSet<String>(Arrays.asList("edge", "Math", "country"));
    private static final Set<String> allowedMethods = new HashSet<String>(Arrays.asList("ordinal", "getDistance", "getName", "contains", "sqrt", "abs", "isRightHandTraffic"));
    private final ParseResult result;
    private final TreeMap<Integer, Replacement> replacements = new TreeMap();
    private final NameValidator variableValidator;
    private final ClassHelper classHelper;
    private String invalidMessage;

    public ConditionalExpressionVisitor(ParseResult result, NameValidator variableValidator, ClassHelper classHelper) {
        this.result = result;
        this.variableValidator = variableValidator;
        this.classHelper = classHelper;
    }

    boolean isValidIdentifier(String identifier) {
        if (this.variableValidator.isValid(identifier)) {
            if (!Character.isUpperCase(identifier.charAt(0))) {
                this.result.guessedVariables.add(identifier);
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitRvalue(Java.Rvalue rv) throws Exception {
        if (rv instanceof Java.AmbiguousName) {
            Java.AmbiguousName n = (Java.AmbiguousName)rv;
            if (n.identifiers.length == 1) {
                String arg = n.identifiers[0];
                if (arg.startsWith("in_")) {
                    int start = rv.getLocation().getColumnNumber() - 1;
                    this.replacements.put(start, new Replacement(start, arg.length(), CustomWeightingHelper.class.getSimpleName() + ".in(this." + arg + ", edge)"));
                    this.result.guessedVariables.add(arg);
                    return true;
                }
                if (this.isValidIdentifier(arg)) {
                    return true;
                }
                this.invalidMessage = "'" + arg + "' not available";
                return false;
            }
            this.invalidMessage = "identifier " + String.valueOf(n) + " invalid";
            return false;
        }
        if (rv instanceof Java.Literal) {
            return true;
        }
        if (rv instanceof Java.UnaryOperation) {
            Java.UnaryOperation uo = (Java.UnaryOperation)rv;
            if (uo.operator.equals("!")) {
                return uo.operand.accept(this);
            }
            if (uo.operator.equals("-")) {
                return uo.operand.accept(this);
            }
            return false;
        }
        if (rv instanceof Java.MethodInvocation) {
            Java.MethodInvocation mi = (Java.MethodInvocation)rv;
            if (allowedMethods.contains(mi.methodName) && mi.target != null) {
                Java.AmbiguousName n = (Java.AmbiguousName)mi.target.toRvalue();
                if (n.identifiers.length == 2) {
                    if (allowedMethodParents.contains(n.identifiers[0])) {
                        if (mi.arguments.length == 0) {
                            this.result.guessedVariables.add(n.identifiers[0]);
                            return true;
                        }
                        if (mi.arguments.length == 1) {
                            return mi.arguments[0].accept(this);
                        }
                    } else if (this.variableValidator.isValid(n.identifiers[0]) && mi.arguments.length == 0) {
                        this.result.guessedVariables.add(n.identifiers[0]);
                        return true;
                    }
                }
            }
            this.invalidMessage = mi.methodName + " is an illegal method in a conditional expression";
            return false;
        }
        if (rv instanceof Java.ParenthesizedExpression) {
            return ((Java.ParenthesizedExpression)rv).value.accept(this);
        }
        if (rv instanceof Java.BinaryOperation) {
            Java.BinaryOperation binOp = (Java.BinaryOperation)rv;
            int startRH = binOp.rhs.getLocation().getColumnNumber() - 1;
            if (binOp.lhs instanceof Java.AmbiguousName && ((Java.AmbiguousName)binOp.lhs).identifiers.length == 1) {
                boolean eqOps;
                String lhVarAsString = ((Java.AmbiguousName)binOp.lhs).identifiers[0];
                boolean bl = eqOps = binOp.operator.equals("==") || binOp.operator.equals("!=");
                if (binOp.rhs instanceof Java.AmbiguousName && ((Java.AmbiguousName)binOp.rhs).identifiers.length == 1) {
                    String rhValueAsString = ((Java.AmbiguousName)binOp.rhs).identifiers[0];
                    if (this.variableValidator.isValid(lhVarAsString) && Helper.toUpperCase(rhValueAsString).equals(rhValueAsString)) {
                        if (!eqOps) {
                            throw new IllegalArgumentException("Operator " + binOp.operator + " not allowed for enum");
                        }
                        String value = this.classHelper.getClassName(binOp.lhs.toString());
                        this.replacements.put(startRH, new Replacement(startRH, rhValueAsString.length(), value + "." + rhValueAsString));
                    }
                }
            }
            return binOp.lhs.accept(this) != false && binOp.rhs.accept(this) != false;
        }
        return false;
    }

    @Override
    public Boolean visitPackage(Java.Package p) {
        return false;
    }

    @Override
    public Boolean visitType(Java.Type t) {
        return false;
    }

    @Override
    public Boolean visitConstructorInvocation(Java.ConstructorInvocation ci) {
        return false;
    }

    static ParseResult parse(String expression, NameValidator validator, ClassHelper helper) {
        ParseResult result = new ParseResult();
        try {
            Parser parser = new Parser(new Scanner("ignore", new StringReader(expression)));
            Java.Atom atom = parser.parseConditionalExpression();
            if (parser.peek().type == TokenType.END_OF_INPUT) {
                result.guessedVariables = new LinkedHashSet<String>();
                ConditionalExpressionVisitor visitor = new ConditionalExpressionVisitor(result, validator, helper);
                result.ok = atom.accept(visitor);
                result.invalidMessage = visitor.invalidMessage;
                if (result.ok) {
                    result.converted = new StringBuilder(expression.length());
                    int start = 0;
                    for (Replacement replace : visitor.replacements.values()) {
                        result.converted.append(expression, start, replace.start).append(replace.newString);
                        start = replace.start + replace.oldLength;
                    }
                    result.converted.append(expression.substring(start));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static class Replacement {
        int start;
        int oldLength;
        String newString;

        public Replacement(int start, int oldLength, String newString) {
            this.start = start;
            this.oldLength = oldLength;
            this.newString = newString;
        }
    }
}

