/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.BaseGraphNodesAndEdges;
import com.graphhopper.storage.NodeAccess;

class GHNodeAccess
implements NodeAccess {
    private final BaseGraphNodesAndEdges store;

    public GHNodeAccess(BaseGraphNodesAndEdges store) {
        this.store = store;
    }

    @Override
    public void ensureNode(int nodeId) {
        this.store.ensureNodeCapacity(nodeId);
    }

    @Override
    public final void setNode(int nodeId, double lat, double lon, double ele) {
        this.store.ensureNodeCapacity(nodeId);
        this.store.setLat(this.store.toNodePointer(nodeId), lat);
        this.store.setLon(this.store.toNodePointer(nodeId), lon);
        if (this.store.withElevation()) {
            this.store.setEle(this.store.toNodePointer(nodeId), ele);
            this.store.bounds.update(lat, lon, ele);
        } else {
            this.store.bounds.update(lat, lon);
        }
    }

    @Override
    public final double getLat(int nodeId) {
        return this.store.getLat(this.store.toNodePointer(nodeId));
    }

    @Override
    public final double getLon(int nodeId) {
        return this.store.getLon(this.store.toNodePointer(nodeId));
    }

    @Override
    public final double getEle(int nodeId) {
        if (!this.store.withElevation()) {
            throw new IllegalStateException("elevation is disabled");
        }
        return this.store.getEle(this.store.toNodePointer(nodeId));
    }

    @Override
    public final void setTurnCostIndex(int index, int turnCostIndex) {
        if (!this.store.withTurnCosts()) {
            throw new AssertionError((Object)"This graph does not support turn costs");
        }
        this.store.ensureNodeCapacity(index);
        this.store.setTurnCostRef(this.store.toNodePointer(index), turnCostIndex);
    }

    @Override
    public final int getTurnCostIndex(int index) {
        if (this.store.withTurnCosts()) {
            return this.store.getTurnCostRef(this.store.toNodePointer(index));
        }
        throw new AssertionError((Object)"This graph does not support turn costs");
    }

    @Override
    public final boolean is3D() {
        return this.store.withElevation();
    }

    @Override
    public int getDimension() {
        return this.store.withElevation() ? 3 : 2;
    }
}

