/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.AbstractDataAccess;
import com.graphhopper.storage.DAType;
import com.graphhopper.util.Helper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public final class MMapDataAccess
extends AbstractDataAccess {
    private final boolean allowWrites;
    private RandomAccessFile raFile;
    private final List<MappedByteBuffer> segments = new ArrayList<MappedByteBuffer>();

    MMapDataAccess(String name, String location, boolean allowWrites, int segmentSize) {
        super(name, location, segmentSize);
        this.allowWrites = allowWrites;
    }

    public static void cleanMappedByteBuffer(ByteBuffer buffer) {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            Method method = unsafeClass.getDeclaredMethod("invokeCleaner", ByteBuffer.class);
            try {
                method.invoke(theUnsafe, buffer);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to unmap the mapped buffer", ex);
        }
    }

    private void initRandomAccessFile() {
        if (this.raFile != null) {
            return;
        }
        try {
            this.raFile = new RandomAccessFile(this.getFullName(), this.allowWrites ? "rw" : "r");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public MMapDataAccess create(long bytes) {
        if (!this.segments.isEmpty()) {
            throw new IllegalThreadStateException("already created");
        }
        this.initRandomAccessFile();
        bytes = Math.max(40L, bytes);
        this.ensureCapacity(bytes);
        return this;
    }

    @Override
    public boolean ensureCapacity(long bytes) {
        return this.mapIt(100L, bytes);
    }

    private boolean mapIt(long offset, long byteCount) {
        int i;
        if (byteCount < 0L) {
            throw new IllegalArgumentException("new capacity has to be strictly positive");
        }
        if (byteCount <= this.getCapacity()) {
            return false;
        }
        long longSegmentSize = this.segmentSizeInBytes;
        int segmentsToMap = (int)(byteCount / longSegmentSize);
        if (segmentsToMap < 0) {
            throw new IllegalStateException("Too many segments needs to be allocated. Increase segmentSize.");
        }
        if (byteCount % longSegmentSize != 0L) {
            ++segmentsToMap;
        }
        if (segmentsToMap == 0) {
            throw new IllegalStateException("0 segments are not allowed.");
        }
        long bufferStart = offset;
        long newFileLength = offset + (long)segmentsToMap * longSegmentSize;
        try {
            bufferStart += (long)this.segments.size() * longSegmentSize;
            int newSegments = segmentsToMap - this.segments.size();
            for (i = 0; i < newSegments; ++i) {
                this.segments.add(this.newByteBuffer(bufferStart, longSegmentSize));
                bufferStart += longSegmentSize;
            }
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException("Couldn't map buffer " + i + " of " + segmentsToMap + " with " + longSegmentSize + " for " + this.name + " at position " + bufferStart + " for " + byteCount + " bytes with offset " + offset + ", new fileLength:" + newFileLength + ", " + Helper.getMemInfo(), ex);
        }
    }

    private MappedByteBuffer newByteBuffer(long offset, long byteCount) throws IOException {
        ByteBuffer buf = null;
        IOException ioex = null;
        for (int trial = 0; trial < 1; ++trial) {
            try {
                buf = this.raFile.getChannel().map(this.allowWrites ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY, offset, byteCount);
                break;
            }
            catch (IOException tmpex) {
                ioex = tmpex;
                try {
                    Thread.sleep(5L);
                    continue;
                }
                catch (InterruptedException iex) {
                    throw new IOException(iex);
                }
            }
        }
        if (buf == null) {
            if (ioex == null) {
                throw new AssertionError((Object)"internal problem as the exception 'ioex' shouldn't be null");
            }
            throw ioex;
        }
        buf.order(this.byteOrder);
        return buf;
    }

    @Override
    public boolean loadExisting() {
        if (this.segments.size() > 0) {
            throw new IllegalStateException("already initialized");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("already closed");
        }
        File file = new File(this.getFullName());
        if (!file.exists() || file.length() == 0L) {
            return false;
        }
        this.initRandomAccessFile();
        try {
            long byteCount = this.readHeader(this.raFile);
            if (byteCount < 0L) {
                return false;
            }
            this.mapIt(100L, byteCount - 100L);
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException("Problem while loading " + this.getFullName(), ex);
        }
    }

    @Override
    public void flush() {
        if (this.isClosed()) {
            throw new IllegalStateException("already closed");
        }
        try {
            for (MappedByteBuffer bb : this.segments) {
                bb.force();
            }
            this.writeHeader(this.raFile, this.raFile.length(), this.segmentSizeInBytes);
            this.raFile.getFD().sync();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void load(int percentage) {
        if (percentage < 0 || percentage > 100) {
            throw new IllegalArgumentException("Percentage for MMapDataAccess.load for " + this.getName() + " must be in [0,100] but was " + percentage);
        }
        int max = Math.round((float)(this.segments.size() * percentage) / 100.0f);
        for (int i = 0; i < max; ++i) {
            this.segments.get(i).load();
        }
    }

    @Override
    public void close() {
        super.close();
        this.clean(0, this.segments.size());
        this.segments.clear();
        Helper.close(this.raFile);
    }

    @Override
    public void setInt(long bytePos, int value) {
        int bufferIndex = (int)(bytePos >> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        ByteBuffer b1 = this.segments.get(bufferIndex);
        if (index + 3 >= this.segmentSizeInBytes) {
            ByteBuffer b2 = this.segments.get(bufferIndex + 1);
            if (index + 1 >= this.segmentSizeInBytes) {
                b2.putShort(1, (short)(value >>> 16));
                b2.put(0, (byte)(value >>> 8));
                b1.put(index, (byte)value);
            } else if (index + 2 >= this.segmentSizeInBytes) {
                b2.putShort(0, (short)(value >>> 16));
                b1.putShort(index, (short)value);
            } else {
                b2.put(0, (byte)(value >>> 24));
                b1.putShort(index + 1, (short)(value >>> 8));
                b1.put(index, (byte)value);
            }
        } else {
            b1.putInt(index, value);
        }
    }

    @Override
    public int getInt(long bytePos) {
        int bufferIndex = (int)(bytePos >> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        ByteBuffer b1 = this.segments.get(bufferIndex);
        if (index + 3 >= this.segmentSizeInBytes) {
            ByteBuffer b2 = this.segments.get(bufferIndex + 1);
            if (index + 1 >= this.segmentSizeInBytes) {
                return (b2.getShort(1) & 0xFFFF) << 16 | (b2.get(0) & 0xFF) << 8 | b1.get(index) & 0xFF;
            }
            if (index + 2 >= this.segmentSizeInBytes) {
                return (b2.getShort(0) & 0xFFFF) << 16 | b1.getShort(index) & 0xFFFF;
            }
            return (b2.get(0) & 0xFF) << 24 | (b1.getShort(index + 1) & 0xFFFF) << 8 | b1.get(index) & 0xFF;
        }
        return b1.getInt(index);
    }

    @Override
    public void setShort(long bytePos, short value) {
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        ByteBuffer byteBuffer = this.segments.get(bufferIndex);
        if (index + 1 >= this.segmentSizeInBytes) {
            ByteBuffer byteBufferNext = this.segments.get(bufferIndex + 1);
            byteBuffer.put(index, (byte)value);
            byteBufferNext.put(0, (byte)(value >>> 8));
        } else {
            byteBuffer.putShort(index, value);
        }
    }

    @Override
    public short getShort(long bytePos) {
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        ByteBuffer byteBuffer = this.segments.get(bufferIndex);
        if (index + 1 >= this.segmentSizeInBytes) {
            ByteBuffer byteBufferNext = this.segments.get(bufferIndex + 1);
            return (short)((byteBufferNext.get(0) & 0xFF) << 8 | byteBuffer.get(index) & 0xFF);
        }
        return byteBuffer.getShort(index);
    }

    @Override
    public void setBytes(long bytePos, byte[] values2, int length) {
        assert (length <= this.segmentSizeInBytes) : "the length has to be smaller or equal to the segment size: " + length + " vs. " + this.segmentSizeInBytes;
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        int delta = index + length - this.segmentSizeInBytes;
        ByteBuffer bb1 = this.segments.get(bufferIndex);
        if (delta > 0) {
            bb1.put(index, values2, 0, length -= delta);
        } else {
            bb1.put(index, values2, 0, length);
        }
        if (delta > 0) {
            ByteBuffer bb2 = this.segments.get(bufferIndex + 1);
            bb2.put(0, values2, length, delta);
        }
    }

    @Override
    public void getBytes(long bytePos, byte[] values2, int length) {
        assert (length <= this.segmentSizeInBytes) : "the length has to be smaller or equal to the segment size: " + length + " vs. " + this.segmentSizeInBytes;
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        int delta = index + length - this.segmentSizeInBytes;
        ByteBuffer bb1 = this.segments.get(bufferIndex);
        if (delta > 0) {
            bb1.get(index, values2, 0, length -= delta);
            ByteBuffer bb2 = this.segments.get(bufferIndex + 1);
            bb2.get(0, values2, length, delta);
        } else {
            bb1.get(index, values2, 0, length);
        }
    }

    @Override
    public void setByte(long bytePos, byte value) {
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        ByteBuffer bb1 = this.segments.get(bufferIndex);
        bb1.put(index, value);
    }

    @Override
    public byte getByte(long bytePos) {
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        ByteBuffer bb1 = this.segments.get(bufferIndex);
        return bb1.get(index);
    }

    @Override
    public long getCapacity() {
        long cap = 0L;
        for (ByteBuffer byteBuffer : this.segments) {
            cap += (long)byteBuffer.capacity();
        }
        return cap;
    }

    @Override
    public int getSegments() {
        return this.segments.size();
    }

    private void clean(int from, int to) {
        for (int i = from; i < to; ++i) {
            ByteBuffer bb = this.segments.get(i);
            MMapDataAccess.cleanMappedByteBuffer(bb);
            this.segments.set(i, null);
        }
    }

    @Override
    public DAType getType() {
        return DAType.MMAP;
    }
}

