/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.shapes.BBox;

public interface LocationIndex {
    public Snap findClosest(double var1, double var3, EdgeFilter var5);

    default public void query(BBox queryBBox, Visitor function) {
        this.query(LocationIndex.createBBoxTileFilter(queryBBox), function);
    }

    public void query(TileFilter var1, Visitor var2);

    public void close();

    public static TileFilter createBBoxTileFilter(final BBox queryBBox) {
        return queryBBox == null ? null : new TileFilter(){

            @Override
            public boolean acceptAll(BBox tile) {
                return queryBBox.contains(tile);
            }

            @Override
            public boolean acceptPartially(BBox tile) {
                return queryBBox.intersects(tile);
            }
        };
    }

    public static interface TileFilter {
        public boolean acceptAll(BBox var1);

        public boolean acceptPartially(BBox var1);
    }

    @FunctionalInterface
    public static interface Visitor {
        public void onEdge(int var1);

        default public boolean isTileInfo() {
            return false;
        }

        default public void onTile(BBox bbox, int depth) {
        }
    }
}

