/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.tools;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.routing.util.countryrules.CountryRuleFactory;
import com.graphhopper.util.MiniPerfTest;
import com.graphhopper.util.PMap;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class CHImportTest {
    public static void main(String[] args2) {
        System.out.println("running for args: " + Arrays.toString(args2));
        PMap map = PMap.read(args2);
        String vehicle = map.getString("vehicle", "car");
        GraphHopperConfig config = new GraphHopperConfig(map);
        config.putObject("datareader.file", map.getString("pbf", "map-matching/files/leipzig_germany.osm.pbf"));
        config.putObject("graph.location", map.getString("gh", "ch-import-test-gh"));
        config.setProfiles(Arrays.asList(new Profile(vehicle)));
        config.setCHProfiles(Collections.singletonList(new CHProfile(vehicle)));
        config.putObject("prepare.ch.updates.periodic", map.getInt("periodic", 0));
        config.putObject("prepare.ch.updates.lazy", map.getInt("lazy", 100));
        config.putObject("prepare.ch.updates.neighbor", map.getInt("neighbor", 100));
        config.putObject("prepare.ch.updates.neighbor_max", map.getInt("neighbor_max", 2));
        config.putObject("prepare.ch.contracted_nodes", map.getInt("contracted", 100));
        config.putObject("prepare.ch.log_messages", map.getInt("logs", 20));
        config.putObject("prepare.ch.node.edge_difference_weight", map.getDouble("edge_diff", 10.0));
        config.putObject("prepare.ch.node.original_edge_count_weight", map.getDouble("orig_edge", 1.0));
        config.putObject("prepare.ch.node.max_poll_factor_heuristic", map.getDouble("mpf_heur", 5.0));
        config.putObject("prepare.ch.node.max_poll_factor_contraction", map.getDouble("mpf_contr", 200.0));
        GraphHopper hopper = new GraphHopper();
        hopper.init(config);
        if (map.getBool("use_country_rules", false)) {
            hopper.setCountryRuleFactory(new CountryRuleFactory());
        }
        hopper.importOrLoad();
        CHImportTest.runQueries(hopper, vehicle);
    }

    private static void runQueries(GraphHopper hopper, String profile) {
        BBox bounds = new BBox(10.508422, 12.326602, 47.713457, 49.940615);
        int numQueries = 10000;
        long seed = 123L;
        Random rnd = new Random(seed);
        AtomicInteger notFoundCount = new AtomicInteger();
        MiniPerfTest test = new MiniPerfTest().setIterations(numQueries).start((warmup, run) -> {
            GHPoint to;
            GHPoint from = CHImportTest.getRandomPoint(rnd, bounds);
            GHRequest req = new GHRequest(from, to = CHImportTest.getRandomPoint(rnd, bounds)).setProfile(profile);
            GHResponse rsp = hopper.route(req);
            if (rsp.hasErrors()) {
                if (rsp.getErrors().stream().anyMatch(t -> !(t instanceof PointNotFoundException) && !(t instanceof ConnectionNotFoundException))) {
                    throw new IllegalStateException("Unexpected error: " + rsp.getErrors().toString());
                }
                notFoundCount.incrementAndGet();
                return 0;
            }
            return (int)rsp.getBest().getRouteWeight();
        });
        System.out.println("Total queries: " + numQueries + ", Failed queries: " + notFoundCount.get());
        System.out.println(test.getReport());
    }

    private static GHPoint getRandomPoint(Random rnd, BBox bounds) {
        double lat = bounds.minLat + rnd.nextDouble() * (bounds.maxLat - bounds.minLat);
        double lon = bounds.minLon + rnd.nextDouble() * (bounds.maxLon - bounds.minLon);
        return new GHPoint(lat, lon);
    }
}

