/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.tools;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.routing.TestProfiles;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.Helper;
import com.graphhopper.util.MiniPerfTest;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TurnCostsConfig;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHMeasurement {
    private static final Logger LOGGER = LoggerFactory.getLogger(CHMeasurement.class);

    public static void main(String[] args2) {
        CHMeasurement.testPerformanceAutomaticNodeOrdering(args2);
    }

    private static void testPerformanceAutomaticNodeOrdering(String[] args2) {
        long start = System.nanoTime();
        PMap map = PMap.read(args2);
        GraphHopperConfig ghConfig = new GraphHopperConfig(map);
        LOGGER.info("Running analysis with parameters {}", (Object)ghConfig);
        String osmFile = ghConfig.getString("map", "map-matching/files/leipzig_germany.osm.pbf");
        ghConfig.putObject("datareader.file", osmFile);
        String statsFile = ghConfig.getString("stats_file", null);
        int periodicUpdates = ghConfig.getInt("period_updates", 0);
        int lazyUpdates = ghConfig.getInt("lazy_updates", 100);
        int neighborUpdates = ghConfig.getInt("neighbor_updates", 50);
        int maxNeighborUpdates = ghConfig.getInt("max_neighbor_updates", 3);
        int contractedNodes = ghConfig.getInt("contract_nodes", 100);
        int logMessages = ghConfig.getInt("log_messages", 20);
        float edgeQuotientWeight = ghConfig.getFloat("edge_quotient_weight", 100.0f);
        float origEdgeQuotientWeight = ghConfig.getFloat("orig_edge_quotient_weight", 100.0f);
        float hierarchyDepthWeight = ghConfig.getFloat("hierarchy_depth_weight", 20.0f);
        int pollFactorHeuristic = ghConfig.getInt("poll_factor_heur", 5);
        int pollFactorContraction = ghConfig.getInt("poll_factor_contr", 200);
        int landmarks = ghConfig.getInt("landmarks", 0);
        boolean cleanup = ghConfig.getBool("cleanup", true);
        boolean withTurnCosts = ghConfig.getBool("turncosts", true);
        int uTurnCosts = ghConfig.getInt("u_turn_costs", 80);
        double errorThreshold = ghConfig.getDouble("threshold", 0.1);
        long seed = ghConfig.getLong("seed", 456L);
        int compIterations = ghConfig.getInt("comp_iterations", 100);
        int perfIterations = ghConfig.getInt("perf_iterations", 1000);
        boolean quick = ghConfig.getBool("quick", false);
        GraphHopper graphHopper = new GraphHopper();
        String profile = "car_profile";
        if (withTurnCosts) {
            ghConfig.setProfiles(Collections.singletonList(TestProfiles.accessAndSpeed(profile, "car").setTurnCostsConfig(new TurnCostsConfig(List.of("motorcar", "motor_vehicle"), uTurnCosts))));
            ghConfig.setCHProfiles(Collections.singletonList(new CHProfile(profile)));
            if (landmarks > 0) {
                ghConfig.setLMProfiles(Collections.singletonList(new LMProfile(profile)));
                ghConfig.putObject("prepare.lm.landmarks", landmarks);
            }
        } else {
            ghConfig.setProfiles(Collections.singletonList(TestProfiles.accessAndSpeed(profile, "car")));
        }
        ghConfig.putObject("prepare.ch.updates.periodic", periodicUpdates);
        ghConfig.putObject("prepare.ch.updates.lazy", lazyUpdates);
        ghConfig.putObject("prepare.ch.updates.neighbor", neighborUpdates);
        ghConfig.putObject("prepare.ch.updates.neighbor_max", maxNeighborUpdates);
        ghConfig.putObject("prepare.ch.contracted_nodes", contractedNodes);
        ghConfig.putObject("prepare.ch.log_messages", logMessages);
        if (withTurnCosts) {
            ghConfig.putObject("prepare.ch.edge.edge_quotient_weight", Float.valueOf(edgeQuotientWeight));
            ghConfig.putObject("prepare.ch.edge.original_edge_quotient_weight", Float.valueOf(origEdgeQuotientWeight));
            ghConfig.putObject("prepare.ch.edge.hierarchy_depth_weight", Float.valueOf(hierarchyDepthWeight));
            ghConfig.putObject("prepare.ch.edge.max_poll_factor_heuristic", pollFactorHeuristic);
            ghConfig.putObject("prepare.ch.edge.max_poll_factor_contraction", pollFactorContraction);
        } else {
            ghConfig.putObject("prepare.ch.node.max_poll_factor_heuristic", pollFactorHeuristic);
            ghConfig.putObject("prepare.ch.node.max_poll_factor_contraction", pollFactorContraction);
        }
        LOGGER.info("Initializing graph hopper with args: {}", (Object)ghConfig);
        graphHopper.init(ghConfig);
        if (cleanup) {
            graphHopper.clean();
        }
        PMap results = new PMap(ghConfig.asPMap());
        StopWatch sw = new StopWatch();
        sw.start();
        graphHopper.importOrLoad();
        sw.stop();
        results.putObject("_prepare_time", Float.valueOf(sw.getSeconds()));
        LOGGER.info("Import and preparation took {}s", (Object)(sw.getMillis() / 1000L));
        if (!quick) {
            CHMeasurement.runCompareTest("dijkstrabi", graphHopper, withTurnCosts, uTurnCosts, seed, compIterations, errorThreshold, results);
            CHMeasurement.runCompareTest("astarbi", graphHopper, withTurnCosts, uTurnCosts, seed, compIterations, errorThreshold, results);
        }
        if (!quick) {
            CHMeasurement.runPerformanceTest("dijkstrabi", graphHopper, withTurnCosts, seed, perfIterations, results);
        }
        CHMeasurement.runPerformanceTest("astarbi", graphHopper, withTurnCosts, seed, perfIterations, results);
        if (!quick && landmarks > 0) {
            CHMeasurement.runPerformanceTest("lm", graphHopper, withTurnCosts, seed, perfIterations, results);
        }
        graphHopper.close();
        Map<String, Object> resultMap = results.toMap();
        TreeSet<String> sortedKeys = new TreeSet<String>(resultMap.keySet());
        for (String key : sortedKeys) {
            LOGGER.info(key + "=" + String.valueOf(resultMap.get(key)));
        }
        if (statsFile != null) {
            File f = new File(statsFile);
            boolean writeHeader = !f.exists();
            try (FileOutputStream os = new FileOutputStream(f, true);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
                if (writeHeader) {
                    writer.write(CHMeasurement.getHeader(sortedKeys));
                }
                writer.write(CHMeasurement.getStatLine(sortedKeys, resultMap));
            }
            catch (IOException e) {
                LOGGER.error("Could not write summary to file '{}'", (Object)statsFile, (Object)e);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String key : sortedKeys) {
            sb.append(key).append(":").append(resultMap.get(key)).append(";");
        }
        sb.deleteCharAt(sb.lastIndexOf(";"));
        System.out.println(sb);
        LOGGER.info("Total time: {}s", (Object)CHMeasurement.fmt((double)(System.nanoTime() - start) * 1.0E-9));
    }

    private static String getHeader(TreeSet<String> keys2) {
        StringBuilder sb = new StringBuilder("#");
        for (String key : keys2) {
            sb.append(key).append(";");
        }
        sb.append("\n");
        return sb.toString();
    }

    private static String getStatLine(TreeSet<String> keys2, Map<String, Object> results) {
        StringBuilder sb = new StringBuilder();
        for (String key : keys2) {
            sb.append(results.get(key)).append(";");
        }
        sb.append("\n");
        return sb.toString();
    }

    private static void runCompareTest(final String algo, final GraphHopper graphHopper, boolean withTurnCosts, final int uTurnCosts, long seed, final int iterations, final double threshold, final PMap results) {
        LOGGER.info("Running compare test for {}, using seed {}", (Object)algo, (Object)seed);
        BaseGraph g = graphHopper.getBaseGraph();
        final int numNodes = g.getNodes();
        final NodeAccess nodeAccess = g.getNodeAccess();
        final Random random = new Random(seed);
        MiniPerfTest compareTest = new MiniPerfTest();
        compareTest.setIterations(iterations).start(new MiniPerfTest.Task(){
            long chTime = 0L;
            long noChTime = 0L;
            long chErrors = 0L;
            long noChErrors = 0L;
            long chDeviations = 0L;

            @Override
            public int doCalc(boolean warmup, int run) {
                double nonCHWeight;
                if (!warmup && run % 100 == 0) {
                    LOGGER.info("Finished {} of {} runs. {}", run, iterations, run > 0 ? String.format(Locale.ROOT, " CH: %6.2fms, without CH: %6.2fms", (double)this.chTime * 1.0E-6 / (double)run, (double)this.noChTime * 1.0E-6 / (double)run) : "");
                }
                if (run == iterations - 1) {
                    String avgChTime = CHMeasurement.fmt((double)this.chTime * 1.0E-6 / (double)run);
                    String avgNoChTime = CHMeasurement.fmt((double)this.noChTime * 1.0E-6 / (double)run);
                    LOGGER.info("Finished all ({}) runs, CH: {}ms, without CH: {}ms", iterations, avgChTime, avgNoChTime);
                    results.putObject("_" + algo + ".time_comp_ch", avgChTime);
                    results.putObject("_" + algo + ".time_comp", avgNoChTime);
                    results.putObject("_" + algo + ".errors_ch", this.chErrors);
                    results.putObject("_" + algo + ".errors", this.noChErrors);
                    results.putObject("_" + algo + ".deviations", this.chDeviations);
                }
                GHRequest req = CHMeasurement.buildRandomRequest(random, numNodes, nodeAccess);
                req.setProfile("car_profile");
                req.getHints().putObject("ch.disable", false);
                req.getHints().putObject("lm.disable", true);
                req.getHints().putObject("u_turn_costs", uTurnCosts);
                req.setAlgorithm(algo);
                long start = System.nanoTime();
                GHResponse chRoute = graphHopper.route(req);
                if (!warmup) {
                    this.chTime += System.nanoTime() - start;
                }
                req.getHints().putObject("ch.disable", true);
                start = System.nanoTime();
                GHResponse nonChRoute = graphHopper.route(req);
                if (!warmup) {
                    this.noChTime += System.nanoTime() - start;
                }
                if (CHMeasurement.connectionNotFound(chRoute) && CHMeasurement.connectionNotFound(nonChRoute)) {
                    return 0;
                }
                if (!chRoute.getErrors().isEmpty() || !nonChRoute.getErrors().isEmpty()) {
                    LOGGER.warn("there were errors for {}: \n with CH: {} \n without CH: {}", algo, chRoute.getErrors(), nonChRoute.getErrors());
                    if (!chRoute.getErrors().isEmpty()) {
                        ++this.chErrors;
                    }
                    if (!nonChRoute.getErrors().isEmpty()) {
                        ++this.noChErrors;
                    }
                    return chRoute.getErrors().size();
                }
                double chWeight = chRoute.getBest().getRouteWeight();
                if (Math.abs(chWeight - (nonCHWeight = nonChRoute.getBest().getRouteWeight())) > threshold) {
                    LOGGER.warn("error for {}: difference between best paths with and without CH is above threshold ({}), {}", algo, threshold, CHMeasurement.getWeightDifferenceString(chWeight, nonCHWeight));
                    ++this.chDeviations;
                }
                if (!chRoute.getBest().getPoints().equals(nonChRoute.getBest().getPoints())) {
                    LOGGER.warn("error for {}: found different points for query from {} to {}, {}", algo, req.getPoints().get(0).toShortString(), req.getPoints().get(1).toShortString(), CHMeasurement.getWeightDifferenceString(chWeight, nonCHWeight));
                }
                return chRoute.getErrors().size();
            }
        });
    }

    private static void runPerformanceTest(final String algo, final GraphHopper graphHopper, boolean withTurnCosts, long seed, final int iterations, final PMap results) {
        BaseGraph g = graphHopper.getBaseGraph();
        final int numNodes = g.getNodes();
        final NodeAccess nodeAccess = g.getNodeAccess();
        final Random random = new Random(seed);
        final boolean lm = "lm".equals(algo);
        LOGGER.info("Running performance test for {}, seed = {}", (Object)algo, (Object)seed);
        final long[] numVisitedNodes = new long[]{0L};
        MiniPerfTest performanceTest = new MiniPerfTest();
        performanceTest.setIterations(iterations).start(new MiniPerfTest.Task(){
            private long queryTime;

            @Override
            public int doCalc(boolean warmup, int run) {
                if (!warmup && run % 100 == 0) {
                    LOGGER.info("Finished {} of {} runs. {}", run, iterations, run > 0 ? String.format(Locale.ROOT, " Time: %6.2fms", (double)this.queryTime * 1.0E-6 / (double)run) : "");
                }
                if (run == iterations - 1) {
                    String avg = CHMeasurement.fmt((double)this.queryTime * 1.0E-6 / (double)run);
                    LOGGER.info("Finished all ({}) runs, avg time: {}ms", (Object)iterations, (Object)avg);
                    results.putObject("_" + algo + ".time_ch", avg);
                }
                GHRequest req = CHMeasurement.buildRandomRequest(random, numNodes, nodeAccess);
                req.putHint("ch.disable", lm);
                req.putHint("lm.disable", !lm);
                req.setProfile("car_profile");
                if (!lm) {
                    req.setAlgorithm(algo);
                } else {
                    req.putHint("lm.active_landmarks", 8);
                }
                long start = System.nanoTime();
                GHResponse route = graphHopper.route(req);
                numVisitedNodes[0] = numVisitedNodes[0] + (long)route.getHints().getInt("visited_nodes.sum", 0);
                if (!warmup) {
                    this.queryTime += System.nanoTime() - start;
                }
                return CHMeasurement.getRealErrors(route).size();
            }
        });
        if ((double)performanceTest.getDummySum() > 0.01 * (double)iterations) {
            throw new IllegalStateException("too many errors, probably something is wrong");
        }
        LOGGER.info("Average query time for {}: {}ms", (Object)algo, (Object)performanceTest.getMean());
        LOGGER.info("Visited nodes for {}: {}", (Object)algo, (Object)Helper.nf(numVisitedNodes[0]));
    }

    private static String getWeightDifferenceString(double chWeight, double noChWeight) {
        return String.format(Locale.ROOT, "route weight: %.6f (CH) vs. %.6f (no CH) (diff = %.6f)", chWeight, noChWeight, chWeight - noChWeight);
    }

    private static boolean connectionNotFound(GHResponse response) {
        for (Throwable t : response.getErrors()) {
            if (!(t instanceof ConnectionNotFoundException)) continue;
            return true;
        }
        return false;
    }

    private static List<Throwable> getRealErrors(GHResponse response) {
        ArrayList<Throwable> realErrors = new ArrayList<Throwable>();
        for (Throwable t : response.getErrors()) {
            if (t instanceof ConnectionNotFoundException) continue;
            realErrors.add(t);
        }
        return realErrors;
    }

    private static GHRequest buildRandomRequest(Random random, int numNodes, NodeAccess nodeAccess) {
        int from = random.nextInt(numNodes);
        int to = random.nextInt(numNodes);
        double fromLat = nodeAccess.getLat(from);
        double fromLon = nodeAccess.getLon(from);
        double toLat = nodeAccess.getLat(to);
        double toLon = nodeAccess.getLon(to);
        return new GHRequest(fromLat, fromLon, toLat, toLon);
    }

    private static String fmt(double number) {
        return String.format(Locale.ROOT, "%.2f", number);
    }
}

