/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.tools;

import com.carrotsearch.hppc.IntArrayList;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.ResponsePath;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.routing.TestProfiles;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.ev.TurnRestriction;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.util.CustomArea;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIterator;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.Constants;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.MiniPerfTest;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TurnCostsConfig;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Measurement {
    private static final Logger logger = LoggerFactory.getLogger(Measurement.class);
    private final Map<String, Object> properties = new TreeMap<String, Object>();
    private long seed;
    private boolean stopOnError;
    private int maxNode;
    private String vehicle;

    public static void main(String[] strs) throws IOException {
        PMap args2 = PMap.read(strs);
        int repeats = args2.getInt("measurement.repeats", 1);
        for (int i = 0; i < repeats; ++i) {
            new Measurement().start(args2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(PMap args2) throws IOException {
        Object propFilename;
        String graphLocation = args2.getString("graph.location", "");
        boolean useJson = args2.getBool("measurement.json", false);
        boolean cleanGraph = args2.getBool("measurement.clean", false);
        this.stopOnError = args2.getBool("measurement.stop_on_error", false);
        String summaryLocation = args2.getString("measurement.summaryfile", "");
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss").format(new Date());
        this.put("measurement.timestamp", timestamp);
        String propFolder = args2.getString("measurement.folder", "");
        if (!propFolder.isEmpty()) {
            Files.createDirectories(Paths.get(propFolder, new String[0]), new FileAttribute[0]);
        }
        if (Helper.isEmpty((String)(propFilename = args2.getString("measurement.filename", "")))) {
            if (useJson) {
                String id = Constants.GIT_INFO != null ? Constants.GIT_INFO.getCommitHash().substring(0, 8) : "unknown";
                propFilename = "measurement_" + id + "_" + timestamp + ".json";
            } else {
                propFilename = "measurement_" + timestamp + ".properties";
            }
        }
        String propLocation = Paths.get(propFolder, new String[0]).resolve((String)propFilename).toString();
        this.seed = args2.getLong("measurement.seed", 123L);
        this.put("measurement.gitinfo", args2.getString("measurement.gitinfo", ""));
        int count = args2.getInt("measurement.count", 5000);
        this.put("measurement.name", args2.getString("measurement.name", "no_name"));
        this.put("measurement.map", args2.getString("datareader.file", "unknown"));
        boolean useMeasurementTimeAsRefTime = args2.getBool("measurement.use_measurement_time_as_ref_time", false);
        if (useMeasurementTimeAsRefTime && !useJson) {
            throw new IllegalArgumentException("Using measurement time as reference time only works with json files");
        }
        GraphHopper hopper = new GraphHopper(){

            @Override
            protected Map<String, PrepareContractionHierarchies.Result> prepareCH(boolean closeEarly, List<CHConfig> configsToPrepare) {
                int shortcuts;
                StopWatch sw = new StopWatch().start();
                Map<String, PrepareContractionHierarchies.Result> result = super.prepareCH(closeEarly, configsToPrepare);
                Measurement.this.put("prepare.ch.time", sw.stop().getMillis());
                if (result.get("profile_no_tc") != null) {
                    shortcuts = result.get("profile_no_tc").getCHStorage().getShortcuts();
                    Measurement.this.put("prepare.ch.node.shortcuts", shortcuts);
                    Measurement.this.put("prepare.ch.node.time", result.get("profile_no_tc").getTotalPrepareTime());
                }
                if (result.get("profile_tc") != null) {
                    shortcuts = result.get("profile_tc").getCHStorage().getShortcuts();
                    Measurement.this.put("prepare.ch.edge.shortcuts", shortcuts);
                    Measurement.this.put("prepare.ch.edge.time", result.get("profile_tc").getTotalPrepareTime());
                }
                return result;
            }

            @Override
            protected List<PrepareLandmarks> prepareLM(boolean closeEarly, List<LMConfig> configsToPrepare) {
                List<PrepareLandmarks> prepareLandmarks = super.prepareLM(closeEarly, configsToPrepare);
                for (PrepareLandmarks plm : prepareLandmarks) {
                    Measurement.this.put("prepare.lm.time", plm.getTotalPrepareTime());
                }
                return prepareLandmarks;
            }

            @Override
            protected void cleanUp() {
                StopWatch sw = new StopWatch().start();
                super.cleanUp();
                Measurement.this.put("graph.subnetwork_removal_time_ms", sw.stop().getMillis());
            }

            @Override
            protected void importOSM() {
                StopWatch sw = new StopWatch().start();
                super.importOSM();
                sw.stop();
                Measurement.this.put("graph.import_time", Float.valueOf(sw.getSeconds()));
                Measurement.this.put("graph.import_time_ms", sw.getMillis());
            }
        };
        hopper.init(this.createConfigFromArgs(args2));
        if (cleanGraph) {
            hopper.clean();
        }
        hopper.importOrLoad();
        BaseGraph g = hopper.getBaseGraph();
        EncodingManager encodingManager = hopper.getEncodingManager();
        BooleanEncodedValue accessEnc = encodingManager.getBooleanEncodedValue(VehicleAccess.key(this.vehicle));
        boolean withTurnCosts = encodingManager.hasTurnEncodedValue(TurnRestriction.key("profile_tc"));
        StopWatch sw = new StopWatch().start();
        try {
            boolean isLM;
            boolean isCH;
            this.maxNode = g.getNodes();
            boolean runSlow = args2.getBool("measurement.run_slow_routing", true);
            this.printGraphDetails(g, this.vehicle);
            this.measureGraphTraversal(g, accessEnc, count * 100);
            this.measureLocationIndex(g, hopper.getLocationIndex(), count);
            if (runSlow) {
                isCH = false;
                isLM = false;
                this.measureRouting(hopper, new QuerySettings("routing", count / 20, isCH, isLM).withInstructions());
                this.measureRouting(hopper, new QuerySettings("routing_alt", count / 500, isCH, isLM).alternative());
                if (withTurnCosts) {
                    this.measureRouting(hopper, new QuerySettings("routing_edge", count / 20, isCH, isLM).withInstructions().edgeBased());
                    this.measureRouting(hopper, new QuerySettings("routing_edge_alt", count / 500, isCH, isLM).edgeBased().alternative());
                }
            }
            if (hopper.getLMPreparationHandler().isEnabled()) {
                Measurement.gcAndWait();
                isCH = false;
                isLM = true;
                Helper.parseList(args2.getString("measurement.lm.active_counts", "[4,8,12]")).stream().mapToInt(Integer::parseInt).forEach(activeLMCount -> {
                    this.measureRouting(hopper, new QuerySettings("routingLM" + activeLMCount, count / 20, isCH, isLM).withInstructions().activeLandmarks(activeLMCount));
                    this.measureRouting(hopper, new QuerySettings("routingLM" + activeLMCount + "_alt", count / 500, isCH, isLM).activeLandmarks(activeLMCount).alternative());
                    if (args2.getBool("measurement.lm.edge_based", withTurnCosts)) {
                        this.measureRouting(hopper, new QuerySettings("routingLM" + activeLMCount + "_edge", count / 20, isCH, isLM).withInstructions().activeLandmarks(activeLMCount).edgeBased());
                        this.measureRouting(hopper, new QuerySettings("routingLM" + activeLMCount + "_alt_edge", count / 500, isCH, isLM).activeLandmarks(activeLMCount).edgeBased().alternative());
                    }
                });
            }
            if (hopper.getCHPreparationHandler().isEnabled()) {
                RoutingCHGraph edgeBasedCH;
                isCH = true;
                isLM = false;
                Measurement.gcAndWait();
                RoutingCHGraph nodeBasedCH = hopper.getCHGraphs().get("profile_no_tc");
                if (nodeBasedCH != null) {
                    this.measureGraphTraversalCH(nodeBasedCH, count * 100);
                    Measurement.gcAndWait();
                    this.measureRouting(hopper, new QuerySettings("routingCH", count, isCH, isLM).withInstructions().sod());
                    this.measureRouting(hopper, new QuerySettings("routingCH_alt", count / 100, isCH, isLM).withInstructions().sod().alternative());
                    this.measureRouting(hopper, new QuerySettings("routingCH_with_hints", count, isCH, isLM).withInstructions().sod().withPointHints());
                    this.measureRouting(hopper, new QuerySettings("routingCH_no_sod", count, isCH, isLM).withInstructions());
                    this.measureRouting(hopper, new QuerySettings("routingCH_no_instr", count, isCH, isLM).sod());
                    this.measureRouting(hopper, new QuerySettings("routingCH_full", count, isCH, isLM).withInstructions().withPointHints().sod().simplify().pathDetails());
                    this.measureRouting(hopper, new QuerySettings("routingCH_via_100", count / 100, isCH, isLM).withPoints(100).sod());
                    this.measureRouting(hopper, new QuerySettings("routingCH_via_100_full", count / 100, isCH, isLM).withPoints(100).sod().withInstructions().simplify().pathDetails());
                }
                if ((edgeBasedCH = hopper.getCHGraphs().get("profile_tc")) != null) {
                    this.measureRouting(hopper, new QuerySettings("routingCH_edge", count, isCH, isLM).edgeBased().withInstructions());
                    this.measureRouting(hopper, new QuerySettings("routingCH_edge_alt", count / 100, isCH, isLM).edgeBased().withInstructions().alternative());
                    this.measureRouting(hopper, new QuerySettings("routingCH_edge_no_instr", count, isCH, isLM).edgeBased());
                    this.measureRouting(hopper, new QuerySettings("routingCH_edge_full", count, isCH, isLM).edgeBased().withInstructions().withPointHints().simplify().pathDetails());
                    this.measureRouting(hopper, new QuerySettings("routingCH_edge_via_100", count / 100, isCH, isLM).withPoints(100).edgeBased().sod());
                    this.measureRouting(hopper, new QuerySettings("routingCH_edge_via_100_full", count / 100, isCH, isLM).withPoints(100).edgeBased().sod().withInstructions().simplify().pathDetails());
                }
            }
            this.measureCountryAreaIndex(count);
            this.put("gh.gitinfo", Constants.GIT_INFO != null ? Constants.GIT_INFO.toString() : "unknown");
            this.put("measurement.count", count);
            this.put("measurement.seed", this.seed);
            this.put("measurement.time", sw.stop().getMillis());
        }
        catch (Exception ex) {
            try {
                logger.error("Problem while measuring " + graphLocation, ex);
                if (this.stopOnError) {
                    System.exit(1);
                }
                this.put("error", ex.toString());
                this.put("gh.gitinfo", Constants.GIT_INFO != null ? Constants.GIT_INFO.toString() : "unknown");
                this.put("measurement.count", count);
                this.put("measurement.seed", this.seed);
                this.put("measurement.time", sw.stop().getMillis());
            }
            catch (Throwable throwable) {
                this.put("gh.gitinfo", Constants.GIT_INFO != null ? Constants.GIT_INFO.toString() : "unknown");
                this.put("measurement.count", count);
                this.put("measurement.seed", this.seed);
                this.put("measurement.time", sw.stop().getMillis());
                Measurement.gcAndWait();
                this.put("measurement.totalMB", Helper.getTotalMB());
                this.put("measurement.usedMB", Helper.getUsedMB());
                if (!Helper.isEmpty(summaryLocation)) {
                    this.writeSummary(summaryLocation, propLocation);
                }
                if (useJson) {
                    this.storeJson(propLocation, useMeasurementTimeAsRefTime);
                } else {
                    this.storeProperties(propLocation);
                }
                throw throwable;
            }
            Measurement.gcAndWait();
            this.put("measurement.totalMB", Helper.getTotalMB());
            this.put("measurement.usedMB", Helper.getUsedMB());
            if (!Helper.isEmpty(summaryLocation)) {
                this.writeSummary(summaryLocation, propLocation);
            }
            if (useJson) {
                this.storeJson(propLocation, useMeasurementTimeAsRefTime);
            } else {
                this.storeProperties(propLocation);
            }
        }
        Measurement.gcAndWait();
        this.put("measurement.totalMB", Helper.getTotalMB());
        this.put("measurement.usedMB", Helper.getUsedMB());
        if (!Helper.isEmpty(summaryLocation)) {
            this.writeSummary(summaryLocation, propLocation);
        }
        if (useJson) {
            this.storeJson(propLocation, useMeasurementTimeAsRefTime);
        } else {
            this.storeProperties(propLocation);
        }
    }

    private GraphHopperConfig createConfigFromArgs(PMap args2) {
        GraphHopperConfig ghConfig = new GraphHopperConfig(args2);
        this.vehicle = args2.getString("measurement.vehicle", "car");
        ghConfig.putObject("graph.encoded_values", ghConfig.getString("graph.encoded_values", "") + ", " + VehicleAccess.key(this.vehicle) + "," + VehicleSpeed.key(this.vehicle));
        boolean turnCosts = args2.getBool("measurement.turn_costs", false);
        int uTurnCosts = args2.getInt("measurement.u_turn_costs", 40);
        String weighting = args2.getString("measurement.weighting", "custom");
        boolean useCHEdge = args2.getBool("measurement.ch.edge", true);
        boolean useCHNode = args2.getBool("measurement.ch.node", true);
        boolean useLM = args2.getBool("measurement.lm", true);
        String customModelFile = args2.getString("measurement.custom_model_file", "");
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        if (turnCosts && !this.vehicle.equals("car")) {
            throw new IllegalArgumentException("turn costs not yet supported for: " + this.vehicle);
        }
        List<String> restrictionVehicleTypes = List.of("motorcar", "motor_vehicle");
        if (!customModelFile.isEmpty()) {
            if (!weighting.equals("custom")) {
                throw new IllegalArgumentException("To make use of a custom model you need to set measurement.weighting to 'custom'");
            }
            CustomModel customModel = this.loadCustomModel(customModelFile);
            profiles.add(new Profile("profile_no_tc").setCustomModel(customModel));
            if (turnCosts) {
                profiles.add(new Profile("profile_tc").setCustomModel(customModel).setTurnCostsConfig(new TurnCostsConfig(restrictionVehicleTypes, uTurnCosts)));
            }
        } else {
            profiles.add(TestProfiles.accessAndSpeed("profile_no_tc", this.vehicle));
            if (turnCosts) {
                profiles.add(TestProfiles.accessAndSpeed("profile_tc", this.vehicle).setTurnCostsConfig(new TurnCostsConfig(restrictionVehicleTypes, uTurnCosts)));
            }
        }
        ghConfig.setProfiles(profiles);
        ArrayList<CHProfile> chProfiles = new ArrayList<CHProfile>();
        if (useCHNode) {
            chProfiles.add(new CHProfile("profile_no_tc"));
        }
        if (useCHEdge) {
            chProfiles.add(new CHProfile("profile_tc"));
        }
        ghConfig.setCHProfiles(chProfiles);
        ArrayList<LMProfile> lmProfiles = new ArrayList<LMProfile>();
        if (useLM) {
            lmProfiles.add(new LMProfile("profile_no_tc"));
            if (turnCosts) {
                lmProfiles.add(new LMProfile("profile_tc").setPreparationProfile("profile_no_tc"));
            }
        }
        ghConfig.setLMProfiles(lmProfiles);
        return ghConfig;
    }

    private void printGraphDetails(BaseGraph g, String vehicleStr) {
        this.put("graph.nodes", g.getNodes());
        this.put("graph.edges", g.getAllEdges().length());
        this.put("graph.size_in_MB", g.getCapacity() / 0x100000L);
        this.put("graph.encoder", vehicleStr);
        GHBitSet validEdges = this.getValidEdges(g);
        this.put("graph.valid_edges", validEdges.getCardinality());
    }

    private void measureLocationIndex(Graph g, LocationIndex idx, int count) {
        BBox bbox = g.getBounds();
        double latDelta = bbox.maxLat - bbox.minLat;
        double lonDelta = bbox.maxLon - bbox.minLon;
        Random rand = new Random(this.seed);
        MiniPerfTest miniPerf = new MiniPerfTest().setIterations(count *= 2).start((boolean warmup, int run) -> {
            double lat = rand.nextDouble() * latDelta + bbox.minLat;
            double lon = rand.nextDouble() * lonDelta + bbox.minLon;
            return idx.findClosest(lat, lon, EdgeFilter.ALL_EDGES).getClosestNode();
        });
        this.print("location_index", miniPerf);
    }

    private void measureGraphTraversal(Graph graph, BooleanEncodedValue accessEnc, int count) {
        Random rand = new Random(this.seed);
        AccessFilter outFilter = AccessFilter.outEdges(accessEnc);
        EdgeExplorer outExplorer = graph.createEdgeExplorer(outFilter);
        MiniPerfTest miniPerf = new MiniPerfTest().setIterations(count).start((boolean warmup, int run) -> {
            int nodeId = rand.nextInt(this.maxNode);
            return GHUtility.count(outExplorer.setBaseNode(nodeId));
        });
        this.print("unit_tests.out_edge_state_next", miniPerf);
        EdgeExplorer allExplorer = graph.createEdgeExplorer();
        miniPerf = new MiniPerfTest().setIterations(count).start((boolean warmup, int run) -> {
            int nodeId = rand.nextInt(this.maxNode);
            return GHUtility.count(allExplorer.setBaseNode(nodeId));
        });
        this.print("unit_tests.all_edge_state_next", miniPerf);
        int maxEdgesId = graph.getAllEdges().length();
        GHBitSet allowedEdges = this.getValidEdges(graph);
        miniPerf = new MiniPerfTest().setIterations(count).start((boolean warmup, int run) -> {
            int edgeId;
            while (!allowedEdges.contains(edgeId = rand.nextInt(maxEdgesId))) {
            }
            return graph.getEdgeIteratorState(edgeId, Integer.MIN_VALUE).getEdge();
        });
        this.print("unit_tests.get_edge_state", miniPerf);
    }

    private void measureGraphTraversalCH(RoutingCHGraph lg, int count) {
        Random rand = new Random(this.seed);
        int maxEdgesId = lg.getEdges();
        MiniPerfTest miniPerf = new MiniPerfTest().setIterations(count).start((boolean warmup, int run) -> {
            int edgeId = rand.nextInt(maxEdgesId);
            return lg.getEdgeIteratorState(edgeId, Integer.MIN_VALUE).getEdge();
        });
        this.print("unit_testsCH.get_edge_state", miniPerf);
        RoutingCHEdgeExplorer chOutEdgeExplorer = lg.createOutEdgeExplorer();
        miniPerf = new MiniPerfTest().setIterations(count).start((boolean warmup, int run) -> {
            int nodeId = rand.nextInt(this.maxNode);
            RoutingCHEdgeIterator iter = chOutEdgeExplorer.setBaseNode(nodeId);
            while (iter.next()) {
                nodeId += iter.getAdjNode();
            }
            return nodeId;
        });
        this.print("unit_testsCH.out_edge_next", miniPerf);
        miniPerf = new MiniPerfTest().setIterations(count).start((boolean warmup, int run) -> {
            int nodeId = rand.nextInt(this.maxNode);
            RoutingCHEdgeIterator iter = chOutEdgeExplorer.setBaseNode(nodeId);
            while (iter.next()) {
                nodeId = (int)((double)nodeId + iter.getWeight(false));
            }
            return nodeId;
        });
        this.print("unit_testsCH.out_edge_get_weight", miniPerf);
    }

    private GHBitSet getValidEdges(Graph g) {
        GHBitSetImpl result = new GHBitSetImpl(g.getAllEdges().length());
        AllEdgesIterator iter = g.getAllEdges();
        while (iter.next()) {
            result.add(iter.getEdge());
        }
        return result;
    }

    private void measureCountryAreaIndex(int count) {
        AreaIndex<CustomArea> countryIndex = new AreaIndex<CustomArea>(GHUtility.readCountries());
        Random rnd = new Random(this.seed);
        ArrayList<GHPoint> randomPoints = new ArrayList<GHPoint>(count);
        for (int i = 0; i < count; ++i) {
            double lat = 36.0 + rnd.nextDouble() * 24.0;
            double lon = -14.0 + rnd.nextDouble() * 47.0;
            randomPoints.add(new GHPoint(lat, lon));
        }
        MiniPerfTest lookupPerfTest = new MiniPerfTest().setIterations(count).start((boolean warmup, int run) -> {
            int checksum = 0;
            for (int i = 0; i < 1000; ++i) {
                GHPoint point = (GHPoint)randomPoints.get(rnd.nextInt(randomPoints.size()));
                checksum += countryIndex.query(point.lat, point.lon).size();
            }
            return checksum;
        });
        this.print("area_index.query", lookupPerfTest);
    }

    private void measureRouting(GraphHopper hopper, QuerySettings querySettings) {
        Object algoStr;
        BaseGraph g = hopper.getBaseGraph();
        AtomicLong maxDistance = new AtomicLong(0L);
        AtomicLong minDistance = new AtomicLong(Long.MAX_VALUE);
        AtomicLong distSum = new AtomicLong(0L);
        AtomicLong airDistSum = new AtomicLong(0L);
        AtomicLong altCount = new AtomicLong(0L);
        AtomicInteger failedCount = new AtomicInteger(0);
        DistanceCalcEarth distCalc = new DistanceCalcEarth();
        String profileName = querySettings.edgeBased ? "profile_tc" : "profile_no_tc";
        Weighting weighting = hopper.createWeighting(hopper.getProfile(profileName), new PMap());
        DefaultSnapFilter edgeFilter = new DefaultSnapFilter(weighting, hopper.getEncodingManager().getBooleanEncodedValue(Subnetwork.key(profileName)));
        EdgeExplorer edgeExplorer = g.createEdgeExplorer(edgeFilter);
        AtomicLong visitedNodesSum = new AtomicLong(0L);
        AtomicLong maxVisitedNodes = new AtomicLong(0L);
        Random rand = new Random(this.seed);
        NodeAccess na = g.getNodeAccess();
        MiniPerfTest miniPerf = new MiniPerfTest().setIterations(querySettings.count).start((boolean warmup, int run) -> {
            GHResponse rsp;
            GHRequest req = new GHRequest(querySettings.points);
            IntArrayList nodes = new IntArrayList(querySettings.points);
            ArrayList<GHPoint> points = new ArrayList<GHPoint>();
            ArrayList<String> pointHints = new ArrayList<String>();
            int tries = 0;
            while (nodes.size() < querySettings.points) {
                int node = rand.nextInt(this.maxNode);
                if (++tries > g.getNodes()) {
                    throw new RuntimeException("Could not find accessible points");
                }
                if (GHUtility.count(edgeExplorer.setBaseNode(node)) == 0) continue;
                nodes.add(node);
                points.add(new GHPoint(na.getLat(node), na.getLon(node)));
                if (!querySettings.withPointHints) continue;
                pointHints.add("probably_not_found");
            }
            req.setPoints(points);
            req.setPointHints(pointHints);
            req.setProfile(profileName);
            req.getHints().putObject("ch.disable", !querySettings.ch).putObject("stall_on_demand", querySettings.sod).putObject("lm.disable", !querySettings.lm).putObject("lm.active_landmarks", querySettings.activeLandmarks).putObject("instructions", querySettings.withInstructions);
            if (querySettings.alternative) {
                req.setAlgorithm("alternative_route");
            }
            if (querySettings.pathDetails) {
                req.setPathDetails(Arrays.asList("average_speed", "edge_id", "street_name", "access_conditional", "vehicle_conditional", "motor_vehicle_conditional"));
            }
            if (!querySettings.simplify) {
                req.getHints().putObject("way_point_max_distance", 0);
            }
            try {
                rsp = hopper.route(req);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error while calculating route! nodes: " + String.valueOf(nodes) + ", request:" + String.valueOf(req), ex);
            }
            if (rsp.hasErrors()) {
                if (!warmup) {
                    failedCount.incrementAndGet();
                }
                if (rsp.getErrors().get(0).getMessage() == null) {
                    rsp.getErrors().get(0).printStackTrace();
                } else if (!Helper.toLowerCase(rsp.getErrors().get(0).getMessage()).contains("not found")) {
                    if (this.stopOnError) {
                        throw new RuntimeException("errors should NOT happen in Measurement! " + String.valueOf(req) + " => " + String.valueOf(rsp.getErrors()));
                    }
                    logger.error("errors should NOT happen in Measurement! " + String.valueOf(req) + " => " + String.valueOf(rsp.getErrors()));
                }
                return 0;
            }
            ResponsePath responsePath = rsp.getBest();
            if (!warmup) {
                long visitedNodes = rsp.getHints().getLong("visited_nodes.sum", 0L);
                visitedNodesSum.addAndGet(visitedNodes);
                if (visitedNodes > maxVisitedNodes.get()) {
                    maxVisitedNodes.set(visitedNodes);
                }
                rsp.getAll().forEach(p -> {
                    long dist = (long)p.getDistance();
                    distSum.addAndGet(dist);
                });
                long dist = (long)responsePath.getDistance();
                GHPoint prev = req.getPoints().get(0);
                for (GHPoint point : req.getPoints()) {
                    airDistSum.addAndGet((long)distCalc.calcDist(prev.getLat(), prev.getLon(), point.getLat(), point.getLon()));
                    prev = point;
                }
                if (dist > maxDistance.get()) {
                    maxDistance.set(dist);
                }
                if (dist < minDistance.get()) {
                    minDistance.set(dist);
                }
                if (querySettings.alternative) {
                    altCount.addAndGet(rsp.getAll().size());
                }
            }
            return responsePath.getPoints().size();
        });
        int count = querySettings.count - failedCount.get();
        if (count == 0) {
            throw new RuntimeException("All requests failed, something must be wrong: " + failedCount.get());
        }
        Object object = algoStr = querySettings.ch && !querySettings.edgeBased ? "dijkstrabi" : "astarbi";
        if (querySettings.ch && !querySettings.sod) {
            algoStr = (String)algoStr + "_no_sod";
        }
        String prefix = querySettings.prefix;
        this.put(prefix + ".guessed_algorithm", algoStr);
        this.put(prefix + ".failed_count", failedCount.get());
        this.put(prefix + ".distance_min", minDistance.get());
        this.put(prefix + ".distance_mean", Float.valueOf((float)distSum.get() / (float)count));
        this.put(prefix + ".air_distance_mean", Float.valueOf((float)airDistSum.get() / (float)count));
        this.put(prefix + ".distance_max", maxDistance.get());
        this.put(prefix + ".visited_nodes_mean", Float.valueOf((float)visitedNodesSum.get() / (float)count));
        this.put(prefix + ".visited_nodes_max", Float.valueOf(maxVisitedNodes.get()));
        this.put(prefix + ".alternative_rate", Float.valueOf((float)altCount.get() / (float)count));
        this.print(prefix, miniPerf);
    }

    void print(String prefix, MiniPerfTest perf) {
        logger.info(prefix + ": " + perf.getReport());
        this.put(prefix + ".sum", perf.getSum());
        this.put(prefix + ".min", perf.getMin());
        this.put(prefix + ".mean", perf.getMean());
        this.put(prefix + ".max", perf.getMax());
    }

    void put(String key, Object val) {
        this.properties.put(key, val);
    }

    private void storeJson(String jsonLocation, boolean useMeasurementTimeAsRefTime) {
        logger.info("storing measurement json in " + jsonLocation);
        HashMap<String, String> gitInfoMap = new HashMap<String, String>();
        if (Constants.GIT_INFO != null) {
            this.properties.remove("gh.gitinfo");
            gitInfoMap.put("commitHash", Constants.GIT_INFO.getCommitHash());
            gitInfoMap.put("commitMessage", Constants.GIT_INFO.getCommitMessage());
            gitInfoMap.put("commitTime", Constants.GIT_INFO.getCommitTime());
            gitInfoMap.put("branch", Constants.GIT_INFO.getBranch());
            gitInfoMap.put("dirty", String.valueOf(Constants.GIT_INFO.isDirty()));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String measurementTime = new SimpleDateFormat("yyy-MM-dd'T'HH:mm:ssZ").format(new Date());
        result.put("measurementTime", measurementTime);
        if (Constants.GIT_INFO != null && !useMeasurementTimeAsRefTime) {
            result.put("refTime", Constants.GIT_INFO.getCommitTime());
        } else {
            result.put("refTime", measurementTime);
        }
        result.put("periodicBuild", useMeasurementTimeAsRefTime);
        result.put("gitinfo", gitInfoMap);
        result.put("metrics", this.properties);
        try {
            File file = new File(jsonLocation);
            new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue(file, result);
        }
        catch (IOException e) {
            logger.error("Problem while storing json in: " + jsonLocation, e);
        }
    }

    private CustomModel loadCustomModel(String customModelLocation) {
        ObjectMapper om = Jackson.initObjectMapper(new ObjectMapper());
        try {
            return om.readValue(Helper.readJSONFileWithoutComments(customModelLocation), CustomModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load custom_model from " + customModelLocation, e);
        }
    }

    private void storeProperties(String propLocation) {
        logger.info("storing measurement properties in " + propLocation);
        try (FileWriter fileWriter = new FileWriter(propLocation);){
            String comment = "measurement finish, " + new Date().toString() + ", " + Constants.BUILD_DATE;
            fileWriter.append("#" + comment + "\n");
            for (Map.Entry<String, Object> e : this.properties.entrySet()) {
                fileWriter.append(e.getKey());
                fileWriter.append("=");
                fileWriter.append(e.getValue().toString());
                fileWriter.append("\n");
            }
            fileWriter.flush();
        }
        catch (IOException e) {
            logger.error("Problem while storing properties in: " + propLocation, e);
        }
    }

    private void writeSummary(String summaryLocation, String propLocation) {
        logger.info("writing summary to " + summaryLocation);
        String[] properties = new String[]{"graph.nodes", "graph.edges", "graph.import_time", "prepare.ch.time", "prepare.ch.node.time", "prepare.ch.edge.time", "prepare.ch.node.shortcuts", "prepare.ch.edge.shortcuts", "prepare.lm.time", "routing.distance_mean", "routing.mean", "routing.visited_nodes_mean", "routingCH.distance_mean", "routingCH.mean", "routingCH.visited_nodes_mean", "routingCH_no_instr.mean", "routingCH_full.mean", "routingCH_edge.distance_mean", "routingCH_edge.mean", "routingCH_edge.visited_nodes_mean", "routingCH_edge_no_instr.mean", "routingCH_edge_full.mean", "routingLM8.distance_mean", "routingLM8.mean", "routingLM8.visited_nodes_mean", "measurement.seed", "measurement.gitinfo", "measurement.timestamp"};
        File f = new File(summaryLocation);
        boolean writeHeader = !f.exists();
        try (FileWriter writer = new FileWriter(f, true);){
            if (writeHeader) {
                writer.write(this.getSummaryHeader(properties));
            }
            writer.write(this.getSummaryLogLine(properties, propLocation));
        }
        catch (IOException e) {
            logger.error("Could not write summary to file '{}'", (Object)summaryLocation, (Object)e);
        }
    }

    private String getSummaryHeader(String[] properties) {
        StringBuilder sb = new StringBuilder("#");
        for (String p : properties) {
            String columnName = String.format("%" + this.getSummaryColumnWidth(p) + "s, ", p);
            sb.append(columnName);
        }
        sb.append("propertyFile");
        sb.append('\n');
        return sb.toString();
    }

    private String getSummaryLogLine(String[] properties, String propLocation) {
        StringBuilder sb = new StringBuilder(" ");
        for (String p : properties) {
            sb.append(this.getFormattedProperty(p));
        }
        sb.append(propLocation);
        sb.append('\n');
        return sb.toString();
    }

    private String getFormattedProperty(String property) {
        Object resultObj = this.properties.get(property);
        String result = resultObj == null ? "missing" : resultObj.toString();
        try {
            double doubleValue = Double.parseDouble(result.trim());
            if (doubleValue != (double)((long)doubleValue)) {
                result = String.format(Locale.US, "%.2f", doubleValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return String.format(Locale.US, "%" + this.getSummaryColumnWidth(property) + "s, ", result);
    }

    private int getSummaryColumnWidth(String p) {
        return Math.max(10, p.length());
    }

    private static void gcAndWait() {
        long before = Measurement.getTotalGcCount();
        System.gc();
        while (Measurement.getTotalGcCount() == before) {
        }
    }

    private static long getTotalGcCount() {
        long sum = 0L;
        for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
            long count = b.getCollectionCount();
            if (count == -1L) continue;
            sum += count;
        }
        return sum;
    }

    private static class QuerySettings {
        private final String prefix;
        private final int count;
        final boolean ch;
        final boolean lm;
        int activeLandmarks = -1;
        boolean withInstructions;
        boolean withPointHints;
        boolean sod;
        boolean edgeBased;
        boolean simplify;
        boolean pathDetails;
        boolean alternative;
        int points = 2;

        QuerySettings(String prefix, int count, boolean isCH, boolean isLM) {
            this.prefix = prefix;
            this.count = count;
            this.ch = isCH;
            this.lm = isLM;
        }

        QuerySettings withInstructions() {
            this.withInstructions = true;
            return this;
        }

        QuerySettings withPoints(int points) {
            this.points = points;
            return this;
        }

        QuerySettings withPointHints() {
            this.withPointHints = true;
            return this;
        }

        QuerySettings sod() {
            this.sod = true;
            return this;
        }

        QuerySettings activeLandmarks(int alm) {
            this.activeLandmarks = alm;
            return this;
        }

        QuerySettings edgeBased() {
            this.edgeBased = true;
            return this;
        }

        QuerySettings simplify() {
            this.simplify = true;
            return this;
        }

        QuerySettings pathDetails() {
            this.pathDetails = true;
            return this;
        }

        QuerySettings alternative() {
            this.alternative = true;
            return this;
        }
    }
}

