/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.ui;

import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.shapes.BBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsWrapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private NodeAccess na;
    private double scaleX;
    private double scaleY;
    private double offsetX;
    private double offsetY;
    private BBox bounds = new BBox(-180.0, 180.0, -90.0, 90.0);

    public GraphicsWrapper(Graph g) {
        this.na = g.getNodeAccess();
        BBox b = g.getBounds();
        this.scaleX = this.scaleY = 0.002 * (b.maxLat - b.minLat);
        this.offsetY = b.maxLat - 90.0;
        this.offsetX = -b.minLon;
    }

    public void setNodeAccess(Graph graph) {
        this.na = graph.getNodeAccess();
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void plotText(Graphics2D g2, double lat, double lon, String text) {
        g2.drawString(text, (int)this.getX(lon) + 5, (int)this.getY(lat) + 5);
    }

    public void plotDirectedEdge(Graphics2D g2, double lat, double lon, double lat2, double lon2, float width) {
        g2.setStroke(new BasicStroke(width));
        int startLon = (int)this.getX(lon);
        int startLat = (int)this.getY(lat);
        int destLon = (int)this.getX(lon2);
        int destLat = (int)this.getY(lat2);
        g2.drawLine(startLon, startLat, destLon, destLat);
        if (this.scaleX < 1.0E-4) {
            g2.setStroke(new BasicStroke(3.0f));
            Path2D.Float path = new Path2D.Float();
            path.moveTo(destLon, destLat);
            path.lineTo(destLon + 6, destLat - 2);
            path.lineTo(destLon + 6, destLat + 2);
            path.lineTo(destLon, destLat);
            AffineTransform at = new AffineTransform();
            double angle = Math.atan2(lat2 - lat, lon2 - lon);
            at.rotate(-angle + Math.PI, destLon, destLat);
            path.transform(at);
            g2.draw(path);
        }
    }

    public void plotEdge(Graphics2D g2, double lat, double lon, double lat2, double lon2, float width) {
        g2.setStroke(new BasicStroke(width));
        g2.drawLine((int)this.getX(lon), (int)this.getY(lat), (int)this.getX(lon2), (int)this.getY(lat2));
    }

    public void plotEdge(Graphics2D g2, double lat, double lon, double lat2, double lon2) {
        this.plotEdge(g2, lat, lon, lat2, lon2, 1.0f);
    }

    public double getX(double lon) {
        return (lon + this.offsetX) / this.scaleX;
    }

    public double getY(double lat) {
        return (90.0 - lat + this.offsetY) / this.scaleY;
    }

    public double getLon(int x) {
        return (double)x * this.scaleX - this.offsetX;
    }

    public double getLat(int y) {
        return 90.0 - ((double)y * this.scaleY - this.offsetY);
    }

    public void plotNode(Graphics2D g2, int loc, Color c) {
        this.plotNode(g2, loc, c, 4);
    }

    public void plotNode(Graphics2D g2, int loc, Color c, int size) {
        this.plotNode(g2, loc, c, size, "");
    }

    public void plotNode(Graphics2D g2, int loc, Color c, int size, String text) {
        this.plotNode(g2, this.na, loc, c, size, "");
    }

    public void plotNode(Graphics2D g2, NodeAccess na, int loc, Color c, int size, String text) {
        double lat = na.getLat(loc);
        double lon = na.getLon(loc);
        if (lat < this.bounds.minLat || lat > this.bounds.maxLat || lon < this.bounds.minLon || lon > this.bounds.maxLon) {
            return;
        }
        Color old = g2.getColor();
        g2.setColor(c);
        this.plot(g2, lat, lon, size);
        g2.setColor(old);
    }

    public void plot(Graphics2D g2, double lat, double lon, int width) {
        double x = this.getX(lon);
        double y = this.getY(lat);
        g2.fillOval((int)x, (int)y, width, width);
    }

    public void scale(int x, int y, boolean zoomIn) {
        double resY;
        double tmpFactor = 0.5;
        if (!zoomIn) {
            tmpFactor = 2.0;
        }
        double oldScaleX = this.scaleX;
        double oldScaleY = this.scaleY;
        double resX = this.scaleX * tmpFactor;
        if (resX > 0.0) {
            this.scaleX = resX;
        }
        if ((resY = this.scaleY * tmpFactor) > 0.0) {
            this.scaleY = resY;
        }
        if (zoomIn) {
            this.offsetX -= (this.offsetX + (double)x) * this.scaleX;
            this.offsetY -= (this.offsetY + (double)y) * this.scaleY;
        } else {
            this.offsetX += (double)x * oldScaleX;
            this.offsetY += (double)y * oldScaleY;
        }
        this.logger.info("mouse wheel moved => repaint. zoomIn:" + zoomIn + " " + this.offsetX + "," + this.offsetY + " " + this.scaleX + "," + this.scaleY);
    }

    public void setNewOffset(int offX, int offY) {
        this.offsetX += (double)offX * this.scaleX;
        this.offsetY += (double)offY * this.scaleY;
    }

    public BBox setBounds(int minX, int maxX, int minY, int maxY) {
        double minLon = this.getLon(minX);
        double maxLon = this.getLon(maxX);
        double maxLat = this.getLat(minY);
        double minLat = this.getLat(maxY);
        this.bounds = new BBox(minLon, maxLon, minLat, maxLat);
        return this.bounds;
    }
}

