/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.sorting.IndirectComparator;
import com.carrotsearch.hppc.sorting.IndirectSort;
import java.util.Arrays;
import java.util.Random;

public class ArrayUtil {
    public static IntArrayList constant(int size, int value) {
        IntArrayList result = new IntArrayList(size);
        Arrays.fill(result.buffer, value);
        result.elementsCount = size;
        return result;
    }

    public static IntArrayList zero(int size) {
        IntArrayList result = new IntArrayList(size);
        result.elementsCount = size;
        return result;
    }

    public static IntArrayList iota(int size) {
        return ArrayUtil.range(0, size);
    }

    public static IntArrayList range(int startIncl, int endExcl) {
        IntArrayList result = new IntArrayList(endExcl - startIncl);
        result.elementsCount = endExcl - startIncl;
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, startIncl + i);
        }
        return result;
    }

    public static IntArrayList rangeClosed(int startIncl, int endIncl) {
        return ArrayUtil.range(startIncl, endIncl + 1);
    }

    public static IntArrayList permutation(int size, Random rnd) {
        IntArrayList result = ArrayUtil.iota(size);
        ArrayUtil.shuffle(result, rnd);
        return result;
    }

    public static boolean isPermutation(IntArrayList arr) {
        BitSet present = new BitSet(arr.size());
        for (IntCursor e : arr) {
            if (e.value >= arr.size() || e.value < 0) {
                return false;
            }
            if (present.get(e.value)) {
                return false;
            }
            present.set(e.value);
        }
        return true;
    }

    public static IntArrayList reverse(IntArrayList list) {
        int[] buffer = list.buffer;
        int start = 0;
        for (int end = list.size() - 1; start < end; ++start, --end) {
            int tmp = buffer[start];
            buffer[start] = buffer[end];
            buffer[end] = tmp;
        }
        return list;
    }

    public static IntArrayList shuffle(IntArrayList list, Random random) {
        int maxHalf = list.size() / 2;
        for (int x1 = 0; x1 < maxHalf; ++x1) {
            int x2 = random.nextInt(maxHalf) + maxHalf;
            int tmp = list.buffer[x1];
            list.buffer[x1] = list.buffer[x2];
            list.buffer[x2] = tmp;
        }
        return list;
    }

    public static int removeConsecutiveDuplicates(int[] arr, int end) {
        if (end < 0) {
            throw new IllegalArgumentException("end less than 0");
        }
        if (end == 0) {
            return 0;
        }
        int curr = 0;
        for (int i = 1; i < end; ++i) {
            if (arr[i] == arr[curr]) continue;
            arr[++curr] = arr[i];
        }
        return curr + 1;
    }

    public static IntIndexedContainer withoutConsecutiveDuplicates(IntIndexedContainer arr) {
        IntArrayList result = new IntArrayList();
        if (arr.isEmpty()) {
            return result;
        }
        int prev = arr.get(0);
        result.add(prev);
        for (int i = 1; i < arr.size(); ++i) {
            int val = arr.get(i);
            if (val != prev) {
                result.add(val);
            }
            prev = val;
        }
        return result;
    }

    public static void transform(IntIndexedContainer arr, IntIndexedContainer map) {
        for (int i = 0; i < arr.size(); ++i) {
            arr.set(i, map.get(arr.get(i)));
        }
    }

    public static int[] calcSortOrder(IntArrayList arr1, IntArrayList arr2) {
        if (arr1.elementsCount != arr2.elementsCount) {
            throw new IllegalArgumentException("Arrays must have equal size");
        }
        return ArrayUtil.calcSortOrder(arr1.buffer, arr2.buffer, arr1.elementsCount);
    }

    public static int[] calcSortOrder(int[] arr1, int[] arr2, int length) {
        if (arr1.length < length || arr2.length < length) {
            throw new IllegalArgumentException("Arrays must not be shorter than given length");
        }
        IndirectComparator comp = (indexA, indexB) -> {
            int arr1cmp = Integer.compare(arr1[indexA], arr1[indexB]);
            return arr1cmp != 0 ? arr1cmp : Integer.compare(arr2[indexA], arr2[indexB]);
        };
        return IndirectSort.mergesort(0, length, comp);
    }

    public static int[] applyOrder(int[] arr, int[] order) {
        if (order.length > arr.length) {
            throw new IllegalArgumentException("sort order must not be shorter than array");
        }
        int[] result = new int[order.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = arr[order[i]];
        }
        return result;
    }

    public static int[] invert(int[] arr) {
        int[] result = new int[arr.length];
        Arrays.fill(result, -1);
        for (int i = 0; i < arr.length; ++i) {
            result[arr[i]] = i;
        }
        return result;
    }

    public static IntArrayList invert(IntArrayList list) {
        IntArrayList result = new IntArrayList(list.size());
        result.elementsCount = list.size();
        for (int i = 0; i < result.elementsCount; ++i) {
            result.set(list.get(i), i);
        }
        return result;
    }

    public static IntArrayList subList(IntArrayList list, int fromIndex, int toIndex) {
        IntArrayList result = new IntArrayList(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(list.get(i));
        }
        return result;
    }

    public static int[] merge(int[] a, int[] b) {
        if (a.length + b.length == 0) {
            return new int[0];
        }
        int[] result = new int[a.length + b.length];
        int size = 0;
        int i = 0;
        int j = 0;
        while (i < a.length && j < b.length) {
            if (a[i] < b[j]) {
                result[size++] = a[i++];
                continue;
            }
            result[size++] = b[j++];
        }
        if (i == a.length) {
            System.arraycopy(b, j, result, size, b.length - j);
            size += b.length - j;
        } else {
            System.arraycopy(a, i, result, size, a.length - i);
            size += a.length - i;
        }
        int sizeWithoutDuplicates = ArrayUtil.removeConsecutiveDuplicates(result, size);
        return Arrays.copyOf(result, sizeWithoutDuplicates);
    }
}

