/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.graphhopper.jackson.CustomModelAreasDeserializer;
import com.graphhopper.json.Statement;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.JsonFeatureCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CustomModel {
    public static final String KEY = "custom_model";
    private Double distanceInfluence;
    private Double headingPenalty;
    @JsonIgnore
    private boolean internal;
    private List<Statement> speedStatements = new ArrayList<Statement>();
    private List<Statement> priorityStatements = new ArrayList<Statement>();
    private List<Statement> turnPenaltyStatements = new ArrayList<Statement>();
    private JsonFeatureCollection areas = new JsonFeatureCollection();

    public CustomModel() {
    }

    public CustomModel(CustomModel toCopy) {
        this.internal = false;
        this.headingPenalty = toCopy.headingPenalty;
        this.distanceInfluence = toCopy.distanceInfluence;
        this.speedStatements = this.deepCopy(toCopy.getSpeed());
        this.priorityStatements = this.deepCopy(toCopy.getPriority());
        this.turnPenaltyStatements = this.deepCopy(toCopy.getTurnPenalty());
        this.addAreas(toCopy.getAreas());
    }

    public static Map<String, JsonFeature> getAreasAsMap(JsonFeatureCollection areas) {
        return areas.getFeatures().stream().collect(Collectors.toMap(JsonFeature::getId, Function.identity(), (existing, duplicate) -> {
            throw new IllegalArgumentException("Cannot handle duplicate area " + duplicate.getId());
        }));
    }

    public void addAreas(JsonFeatureCollection externalAreas) {
        Set indexed = this.areas.getFeatures().stream().map(JsonFeature::getId).collect(Collectors.toSet());
        for (JsonFeature ext : externalAreas.getFeatures()) {
            if (!JsonFeature.isValidId("in_" + ext.getId())) {
                throw new IllegalArgumentException("The area '" + ext.getId() + "' has an invalid id. Only letters, numbers and underscore are allowed.");
            }
            if (indexed.contains(ext.getId())) {
                throw new IllegalArgumentException("area " + ext.getId() + " already exists");
            }
            this.areas.getFeatures().add(ext);
            indexed.add(ext.getId());
        }
    }

    public CustomModel internal() {
        this.internal = true;
        return this;
    }

    public boolean isInternal() {
        return this.internal;
    }

    private <T> T deepCopy(T originalObject) {
        if (originalObject instanceof List) {
            ArrayList newList = new ArrayList(((List)originalObject).size());
            for (Object item : (List)originalObject) {
                newList.add(this.deepCopy(item));
            }
            return (T)newList;
        }
        if (originalObject instanceof Map) {
            HashMap copy = originalObject instanceof LinkedHashMap ? new LinkedHashMap(((Map)originalObject).size()) : new HashMap(((Map)originalObject).size());
            Iterator iterator2 = ((Map)originalObject).entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator2.next();
                copy.put(entry.getKey(), this.deepCopy(entry.getValue()));
            }
            return (T)copy;
        }
        return originalObject;
    }

    public List<Statement> getSpeed() {
        return this.speedStatements;
    }

    public CustomModel addToSpeed(Statement st) {
        this.getSpeed().add(st);
        return this;
    }

    public List<Statement> getPriority() {
        return this.priorityStatements;
    }

    public CustomModel addToPriority(Statement st) {
        this.getPriority().add(st);
        return this;
    }

    @JsonProperty(value="turn_penalty")
    public List<Statement> getTurnPenalty() {
        return this.turnPenaltyStatements;
    }

    public CustomModel addToTurnPenalty(Statement st) {
        this.getTurnPenalty().add(st);
        return this;
    }

    @JsonDeserialize(using=CustomModelAreasDeserializer.class)
    public CustomModel setAreas(JsonFeatureCollection areas) {
        this.areas = areas;
        return this;
    }

    public JsonFeatureCollection getAreas() {
        return this.areas;
    }

    public CustomModel setDistanceInfluence(Double distanceFactor) {
        this.distanceInfluence = distanceFactor;
        return this;
    }

    public Double getDistanceInfluence() {
        return this.distanceInfluence;
    }

    public CustomModel setHeadingPenalty(double headingPenalty) {
        this.headingPenalty = headingPenalty;
        return this;
    }

    public Double getHeadingPenalty() {
        return this.headingPenalty;
    }

    public String toString() {
        return this.createContentString();
    }

    private String createContentString() {
        return "distanceInfluence=" + this.distanceInfluence + "|headingPenalty=" + this.headingPenalty + "|speedStatements=" + String.valueOf(this.speedStatements) + "|priorityStatements=" + String.valueOf(this.priorityStatements) + "|turnPenaltyStatements=" + String.valueOf(this.turnPenaltyStatements) + "|areas=" + String.valueOf(this.areas);
    }

    public static CustomModel merge(CustomModel baseModel, CustomModel queryModel) {
        CustomModel mergedCM = new CustomModel(baseModel);
        if (queryModel == null) {
            return mergedCM;
        }
        if (queryModel.getDistanceInfluence() != null) {
            mergedCM.distanceInfluence = queryModel.distanceInfluence;
        }
        if (queryModel.getHeadingPenalty() != null) {
            mergedCM.headingPenalty = queryModel.headingPenalty;
        }
        mergedCM.speedStatements.addAll(queryModel.getSpeed());
        mergedCM.priorityStatements.addAll(queryModel.getPriority());
        mergedCM.turnPenaltyStatements.addAll(queryModel.getTurnPenalty());
        mergedCM.addAreas(queryModel.getAreas());
        return mergedCM;
    }
}

