/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Shape;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedPolygon;

public class Polygon
implements Shape {
    private static final GeometryFactory factory = new GeometryFactory();
    public final PreparedGeometry prepPolygon;
    public final boolean rectangle;
    public final Envelope envelope;
    public final BBox bbox;

    public Polygon(PreparedPolygon prepPolygon) {
        this.prepPolygon = prepPolygon;
        this.rectangle = prepPolygon.getGeometry().isRectangle();
        this.envelope = prepPolygon.getGeometry().getEnvelopeInternal();
        this.bbox = BBox.fromEnvelope(this.envelope);
    }

    public Polygon(double[] lats, double[] lons) {
        if (lats.length != lons.length) {
            throw new IllegalArgumentException("Points must be of equal length but was " + lats.length + " vs. " + lons.length);
        }
        if (lats.length == 0) {
            throw new IllegalArgumentException("Points must not be empty");
        }
        Coordinate[] coordinates = new Coordinate[lats.length + 1];
        for (int i = 0; i < lats.length; ++i) {
            coordinates[i] = new Coordinate(lons[i], lats[i]);
        }
        coordinates[lats.length] = coordinates[0];
        this.prepPolygon = new PreparedPolygon(factory.createPolygon(new PackedCoordinateSequence.Double(coordinates, 2)));
        this.rectangle = this.prepPolygon.getGeometry().isRectangle();
        this.envelope = this.prepPolygon.getGeometry().getEnvelopeInternal();
        this.bbox = BBox.fromEnvelope(this.envelope);
    }

    public static Polygon create(org.locationtech.jts.geom.Polygon polygon) {
        return new Polygon(new PreparedPolygon(polygon));
    }

    @Override
    public boolean intersects(PointList pointList) {
        return this.prepPolygon.intersects(pointList.getCachedLineString(false));
    }

    @Override
    public boolean contains(double lat, double lon) {
        return this.prepPolygon.contains(factory.createPoint(new Coordinate(lon, lat)));
    }

    @Override
    public BBox getBounds() {
        return this.bbox;
    }

    public double getMinLat() {
        return this.envelope.getMinY();
    }

    public double getMinLon() {
        return this.envelope.getMinX();
    }

    public double getMaxLat() {
        return this.envelope.getMaxY();
    }

    public double getMaxLon() {
        return this.envelope.getMaxX();
    }

    public boolean isRectangle() {
        return this.rectangle;
    }

    public String toString() {
        return "polygon (" + this.prepPolygon.getGeometry().getNumPoints() + " points," + this.prepPolygon.getGeometry().getNumGeometries() + " geometries)";
    }
}

