/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osm_legal_default_speeds.tagfilter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u0006J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0006J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0010\u001a\u00020\u0006J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010!\u001a\u00020\u0003H\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/westnordost/osm_legal_default_speeds/tagfilter/StringWithCursor;", "", "string", "", "(Ljava/lang/String;)V", "<set-?>", "", "cursorPos", "getCursorPos", "()I", "advance", "", "advanceBy", "x", "findNext", "c", "offs", "str", "regex", "Lkotlin/text/Regex;", "get", "index", "(I)Ljava/lang/Character;", "isAtEnd", "", "nextIs", "nextIsAndAdvance", "nextMatches", "Lkotlin/text/MatchResult;", "nextMatchesAndAdvance", "retreatBy", "", "toDelta", "toString", "library"})
public final class StringWithCursor {
    @NotNull
    private final String string;
    private int cursorPos;

    public StringWithCursor(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        this.string = string;
    }

    public final int getCursorPos() {
        return this.cursorPos;
    }

    @Nullable
    public final Character get(int index) {
        return index < this.string.length() ? Character.valueOf(this.string.charAt(index)) : null;
    }

    public final boolean nextIsAndAdvance(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        if (!this.nextIs(str)) {
            return false;
        }
        this.advanceBy(str.length());
        return true;
    }

    public final boolean nextIsAndAdvance(char c) {
        if (!this.nextIs(c)) {
            return false;
        }
        this.advance();
        return true;
    }

    @Nullable
    public final MatchResult nextMatchesAndAdvance(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter(regex, "regex");
        MatchResult matchResult = this.nextMatches(regex);
        if (matchResult == null) {
            return null;
        }
        MatchResult result = matchResult;
        this.advanceBy(result.getValue().length());
        return result;
    }

    public final boolean isAtEnd(int offs) {
        return this.cursorPos + offs >= this.string.length();
    }

    public static /* synthetic */ boolean isAtEnd$default(StringWithCursor stringWithCursor, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return stringWithCursor.isAtEnd(n);
    }

    public final int findNext(@NotNull String str, int offs) {
        Intrinsics.checkNotNullParameter(str, "str");
        return this.toDelta(StringsKt.indexOf$default((CharSequence)this.string, str, this.cursorPos + offs, false, 4, null));
    }

    public static /* synthetic */ int findNext$default(StringWithCursor stringWithCursor, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return stringWithCursor.findNext(string, n);
    }

    public final int findNext(char c, int offs) {
        return this.toDelta(StringsKt.indexOf$default((CharSequence)this.string, c, this.cursorPos + offs, false, 4, null));
    }

    public static /* synthetic */ int findNext$default(StringWithCursor stringWithCursor, char c, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return stringWithCursor.findNext(c, n);
    }

    public final int findNext(@NotNull Regex regex, int offs) {
        Intrinsics.checkNotNullParameter(regex, "regex");
        Object object = regex.find(this.string, this.cursorPos + offs);
        return this.toDelta(object != null && (object = object.getRange()) != null ? ((IntProgression)object).getFirst() : -1);
    }

    public static /* synthetic */ int findNext$default(StringWithCursor stringWithCursor, Regex regex, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return stringWithCursor.findNext(regex, n);
    }

    public final char advance() {
        if (StringWithCursor.isAtEnd$default(this, 0, 1, null)) {
            throw new IndexOutOfBoundsException();
        }
        char result = this.string.charAt(this.cursorPos);
        this.cursorPos = Math.min(this.string.length(), this.cursorPos + 1);
        return result;
    }

    @NotNull
    public final String advanceBy(int x) {
        if (x < 0) {
            throw new IndexOutOfBoundsException();
        }
        int end = this.cursorPos + x;
        String result = null;
        if (this.string.length() < end) {
            String string = this.string.substring(this.cursorPos);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            result = string;
            this.cursorPos = this.string.length();
        } else {
            String string = this.string.substring(this.cursorPos, end);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            result = string;
            this.cursorPos = end;
        }
        return result;
    }

    public final void retreatBy(int x) {
        if (x < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.cursorPos = Math.max(0, this.cursorPos - x);
    }

    public final boolean nextIs(char c) {
        Character c2 = this.get(this.cursorPos);
        return c2 != null && c == c2.charValue();
    }

    public final boolean nextIs(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        return StringsKt.startsWith$default(this.string, str, this.cursorPos, false, 4, null);
    }

    @Nullable
    public final MatchResult nextMatches(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter(regex, "regex");
        return regex.matchAt(this.string, this.cursorPos);
    }

    private final int toDelta(int index) {
        return index == -1 ? this.string.length() - this.cursorPos : index - this.cursorPos;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.string.substring(0, this.cursorPos);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\u25ba');
        String string2 = this.string.substring(this.cursorPos);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
        return stringBuilder2.append(string2).toString();
    }
}

