/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import org.apache.xmlgraphics.java2d.color.ColorSpaceOrigin;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;

public class ICCColorSpaceWithIntent
extends ICC_ColorSpace
implements ColorSpaceOrigin {
    private static final long serialVersionUID = -3338065900662625221L;
    static final ColorSpace SRGB = ColorSpace.getInstance(1000);
    private RenderingIntent intent;
    private String profileName;
    private String profileURI;

    public ICCColorSpaceWithIntent(ICC_Profile p, RenderingIntent intent, String profileName, String profileURI) {
        super(p);
        this.intent = intent;
        if (intent != RenderingIntent.AUTO) {
            byte[] hdr = p.getData(1751474532);
            hdr[64] = (byte)intent.getIntegerValue();
        }
        this.profileName = profileName;
        this.profileURI = profileURI;
    }

    public float[] intendedToRGB(float[] values2) {
        switch (this.intent) {
            case ABSOLUTE_COLORIMETRIC: {
                return this.absoluteColorimetricToRGB(values2);
            }
            case PERCEPTUAL: 
            case AUTO: {
                return this.perceptualToRGB(values2);
            }
            case RELATIVE_COLORIMETRIC: {
                return this.relativeColorimetricToRGB(values2);
            }
            case SATURATION: {
                return this.saturationToRGB(values2);
            }
        }
        throw new RuntimeException("invalid intent:" + (Object)((Object)this.intent));
    }

    private float[] perceptualToRGB(float[] values2) {
        return this.toRGB(values2);
    }

    private float[] relativeColorimetricToRGB(float[] values2) {
        float[] ciexyz = this.toCIEXYZ(values2);
        return SRGB.fromCIEXYZ(ciexyz);
    }

    private float[] absoluteColorimetricToRGB(float[] values2) {
        return this.perceptualToRGB(values2);
    }

    private float[] saturationToRGB(float[] values2) {
        return this.perceptualToRGB(values2);
    }

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public String getProfileURI() {
        return this.profileURI;
    }
}

