/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.tools;

import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.routing.TestProfiles;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValueImpl;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.MiniPerfTest;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class GraphSpeedMeasurement {
    public static void main(String[] strs) {
        PMap args = PMap.read((String[])strs);
        ArrayList<String> result = new ArrayList<String>();
        for (int speedBits = 7; speedBits <= 31; speedBits += 3) {
            System.out.println("Running measurement for speedBits=" + speedBits);
            GraphHopperConfig ghConfig = new GraphHopperConfig().putObject("datareader.file", (Object)args.getString("map", "map-matching/files/leipzig_germany.osm.pbf")).putObject("graph.location", (Object)(args.getString("location", "graph-speed-measurement") + "-" + speedBits + "-gh")).putObject("graph.dataaccess", (Object)args.getString("da", "RAM_STORE")).putObject("import.osm.ignored_highways", (Object)"").putObject("graph.encoded_values", (Object)String.format("car_average_speed|speed_bits=%d,bike_average_speed|speed_bits=%d,foot_average_speed|speed_bits=%d", speedBits, speedBits, speedBits)).setProfiles(List.of(TestProfiles.accessAndSpeed((String)"car")));
            GraphHopper hopper = new GraphHopper().init(ghConfig).importOrLoad();
            BaseGraph baseGraph = hopper.getBaseGraph();
            EncodingManager em = hopper.getEncodingManager();
            List booleanEncodedValues = em.getEncodedValues().stream().filter(e -> e instanceof BooleanEncodedValue).map(e -> (BooleanEncodedValue)e).collect(Collectors.toList());
            List intEncodedValues = em.getEncodedValues().stream().filter(e -> e.getClass().equals(IntEncodedValueImpl.class)).map(e -> (IntEncodedValue)e).collect(Collectors.toList());
            List decimalEncodedValues = em.getEncodedValues().stream().filter(e -> e instanceof DecimalEncodedValue).map(e -> (DecimalEncodedValue)e).collect(Collectors.toList());
            List enumEncodedValues = em.getEncodedValues().stream().filter(e -> e.getClass().isAssignableFrom(EnumEncodedValue.class)).map(e -> (EnumEncodedValue)e).collect(Collectors.toList());
            EdgeExplorer explorer = baseGraph.createEdgeExplorer();
            Random rnd = new Random(123L);
            int iterations = args.getInt("iters", 1000000);
            int repeatsPerEdge = args.getInt("repeats_per_edge", 10);
            MiniPerfTest t = new MiniPerfTest().setIterations(iterations).start((warmup, run) -> {
                EdgeIterator iter = explorer.setBaseNode(rnd.nextInt(baseGraph.getNodes()));
                double sum = 0.0;
                while (iter.next()) {
                    for (int i = 0; i < repeatsPerEdge; ++i) {
                        for (BooleanEncodedValue ev : booleanEncodedValues) {
                            sum += iter.get(ev) ? 1.0 : 0.0;
                        }
                        for (BooleanEncodedValue ev : intEncodedValues) {
                            sum += iter.get((IntEncodedValue)ev) > 5 ? 1.0 : 0.0;
                        }
                        for (BooleanEncodedValue ev : decimalEncodedValues) {
                            sum += iter.get((DecimalEncodedValue)ev) > 20.0 ? 1.0 : 0.0;
                        }
                        for (BooleanEncodedValue ev : enumEncodedValues) {
                            sum += (double)iter.get((EnumEncodedValue)ev).ordinal();
                        }
                    }
                }
                return (int)sum;
            });
            result.add(String.format("bits: %d, bytes: %d, took: %.2fms, checksum: %d", speedBits, em.getBytesForFlags(), t.getSum(), t.getDummySum()));
            System.out.println((String)result.get(result.size() - 1));
        }
        System.out.println();
        System.out.println("### RESULT ###");
        for (String res : result) {
            System.out.println(res);
        }
    }
}

