/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TagInfoUtil {
    private static final String URL_TEMPLATE = "https://taginfo.openstreetmap.org/api/4/key/values?filter=all&sortname=count&sortorder=desc&qtype=value&format=json&key=";
    private static final Extractor TONS_EXTRACTOR = OSMValueExtractor::stringToTons;
    private static final Extractor METER_EXTRACTOR = OSMValueExtractor::stringToMeter;
    private static final Extractor MAXSPEED_EXTRACTOR = OSMMaxSpeedParser::parseMaxspeedString;

    public static void main(String[] args) throws IOException {
        LinkedHashMap<String, Extractor> keyMap = new LinkedHashMap<String, Extractor>();
        keyMap.put("maxweight", TONS_EXTRACTOR);
        keyMap.put("maxaxleload", TONS_EXTRACTOR);
        keyMap.put("maxwidth", METER_EXTRACTOR);
        keyMap.put("maxheight", METER_EXTRACTOR);
        keyMap.put("maxlength", METER_EXTRACTOR);
        keyMap.put("maxspeed", MAXSPEED_EXTRACTOR);
        for (Map.Entry entry : keyMap.entrySet()) {
            String key = (String)entry.getKey();
            Extractor extractor = (Extractor)entry.getValue();
            TagInfoUtil.analyzeTags(key, extractor);
        }
    }

    private static void analyzeTags(String key, Extractor extractor) throws IOException {
        System.out.println("Tag: " + key);
        LinkedHashMap<String, Tag> parsedMap = new LinkedHashMap<String, Tag>();
        ArrayList<Tag> failed = new ArrayList<Tag>();
        int count = 0;
        for (Tag tag : TagInfoUtil.loadTags(key)) {
            count += tag.getCount();
            double val = extractor.extract(tag.getValue());
            if (Double.isNaN(val)) {
                failed.add(tag);
                continue;
            }
            System.out.println("\"" + tag.getValue() + "\" -> " + val);
            String normalized = Double.toString(val);
            if (parsedMap.containsKey(normalized)) {
                Tag existing = (Tag)parsedMap.get(normalized);
                existing.setCount(existing.getCount() + tag.getCount());
                continue;
            }
            parsedMap.put(normalized, new Tag(normalized, tag.getCount()));
        }
        for (Tag tag : failed) {
            System.out.println("Unable to parse \"" + tag.getValue() + "\" (" + tag.getCount() + " occurrences)");
        }
        int parsedCount = parsedMap.values().stream().mapToInt(Tag::getCount).sum();
        double percentage = (double)parsedCount / (double)count * 100.0;
        System.out.println("Success rate: " + percentage + "%");
    }

    private static List<Tag> loadTags(String key) throws IOException {
        JsonNode node;
        try (InputStream in = new URL(URL_TEMPLATE + key).openStream();
             BufferedInputStream bufferedIn = new BufferedInputStream(in);){
            node = new ObjectMapper().readTree((InputStream)bufferedIn);
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Iterator iter = node.path("data").elements();
        while (iter.hasNext()) {
            JsonNode tagElement = (JsonNode)iter.next();
            String value = tagElement.path("value").asText();
            int count = tagElement.path("count").asInt();
            tags.add(new Tag(value, count));
        }
        return tags;
    }

    private static interface Extractor {
        public double extract(String var1);
    }

    private static class Tag {
        private final String value;
        private int count;

        public Tag(String value, int count) {
            this.value = value;
            this.count = count;
        }

        public String getValue() {
            return this.value;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Tag [value=");
            builder.append(this.value);
            builder.append(", count=");
            builder.append(this.count);
            builder.append("]");
            return builder.toString();
        }
    }
}

