/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.ui;

import com.graphhopper.ui.MapLayer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultMapLayer
implements MapLayer {
    protected BufferedImage image;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Rectangle bounds = new Rectangle();
    private Graphics2D tmpG;
    private boolean buffering = true;
    private RescaleOp op = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, new float[4], null);

    protected abstract void paintComponent(Graphics2D var1);

    @Override
    public void paint(Graphics2D mainGraphics) {
        if (!this.buffering) {
            try {
                this.paintComponent(mainGraphics);
            }
            catch (Exception ex) {
                this.logger.error("Problem in paintComponent", (Throwable)ex);
            }
            return;
        }
        if (this.image != null) {
            mainGraphics.drawImage(this.image, this.op, this.bounds.x, this.bounds.y);
        }
    }

    @Override
    public void setBuffering(boolean enable) {
        this.buffering = enable;
    }

    @Override
    public final void repaint() {
        if (this.tmpG != null) {
            this.paintComponent(this.tmpG);
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        if (this.image == null || this.image.getHeight() != bounds.height || this.image.getWidth() != bounds.width) {
            this.image = new BufferedImage(bounds.width, bounds.height, 2);
            this.tmpG = this.image.createGraphics();
            this.tmpG.setColor(Color.BLACK);
            this.tmpG.setBackground(Color.WHITE);
        }
        this.bounds = bounds;
        this.repaint();
    }

    public void makeTransparent(Graphics2D g2) {
        Color col = g2.getColor();
        Composite comp = null;
        if (this.buffering) {
            comp = g2.getComposite();
            g2.setComposite(AlphaComposite.Clear);
        }
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fillRect(0, 0, this.bounds.width, this.bounds.height);
        g2.setColor(col);
        if (comp != null) {
            g2.setComposite(comp);
        }
    }

    public void clearGraphics(Graphics2D g2) {
        g2.clearRect(0, 0, this.bounds.width, this.bounds.height);
    }
}

