/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.ui;

import com.graphhopper.ui.MapLayer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

public class LayeredPanel
extends JPanel {
    private final Collection<MapLayer> layers;

    public LayeredPanel() {
        this(new ArrayList<MapLayer>());
    }

    public LayeredPanel(Collection<MapLayer> layer) {
        this.layers = layer;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = e.getComponent().getWidth();
                int h = e.getComponent().getHeight();
                System.out.println("mainResized:" + w + " " + h);
                for (MapLayer ml : LayeredPanel.this.layers) {
                    ml.setBounds(new Rectangle(0, 0, w, h));
                }
                LayeredPanel.this.repaint();
            }
        });
    }

    public void setBuffering(boolean enable) {
        for (MapLayer ml : this.layers) {
            ml.setBuffering(enable);
        }
    }

    public void addLayer(MapLayer ml) {
        this.layers.add(ml);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.clearRect(0, 0, this.getBounds().width, this.getBounds().height);
        for (MapLayer ml : this.layers) {
            ml.paint(g2);
        }
    }
}

