/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.ui;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHTBitSet;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.DijkstraBidirectionCH;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.TestProfiles;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.lm.LMRoutingAlgorithmFactory;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.QueryRoutingCHGraph;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.ui.DebugAStar;
import com.graphhopper.ui.DebugAStarBi;
import com.graphhopper.ui.DebugAlgo;
import com.graphhopper.ui.DebugDijkstraBidirection;
import com.graphhopper.ui.DebugDijkstraSimple;
import com.graphhopper.ui.DefaultMapLayer;
import com.graphhopper.ui.GraphicsWrapper;
import com.graphhopper.ui.LayeredPanel;
import com.graphhopper.ui.MapLayer;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TurnCostsConfig;
import com.graphhopper.util.shapes.BBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniGraphUI {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BaseGraph graph;
    private final NodeAccess na;
    private final MapLayer pathLayer;
    private final DecimalEncodedValue avSpeedEnc;
    private final BooleanEncodedValue accessEnc;
    private final boolean useCH;
    int currentPosX;
    int currentPosY;
    private LocationIndexTree index;
    private String latLon = "";
    private GraphicsWrapper mg;
    private JPanel infoPanel;
    private LayeredPanel mainPanel;
    private MapLayer roadsLayer;
    private boolean fastPaint = false;
    private boolean showQuadTree = false;
    private Snap fromRes;
    private Snap toRes;
    private QueryGraph qGraph;

    public static void main(String[] strs) {
        PMap args = PMap.read((String[])strs);
        args.putObject("datareader.file", (Object)args.getString("datareader.file", "core/files/monaco.osm.gz"));
        args.putObject("graph.location", (Object)args.getString("graph.location", "tools/target/mini-graph-ui-gh"));
        GraphHopperConfig ghConfig = new GraphHopperConfig(args);
        ghConfig.setProfiles(List.of(TestProfiles.accessAndSpeed((String)"profile", (String)"car").setTurnCostsConfig(TurnCostsConfig.car()))).putObject("import.osm.ignored_highways", (Object)"");
        ghConfig.setCHProfiles(List.of(new CHProfile("profile")));
        ghConfig.setLMProfiles(List.of(new LMProfile("profile")));
        GraphHopper hopper = new GraphHopper().init(ghConfig).importOrLoad();
        boolean debug = args.getBool("minigraphui.debug", false);
        boolean useCH = args.getBool("minigraphui.useCH", false);
        new MiniGraphUI(hopper, debug, useCH).visualize();
    }

    public MiniGraphUI(final GraphHopper hopper, boolean debug, boolean useCH) {
        this.graph = hopper.getBaseGraph();
        this.na = this.graph.getNodeAccess();
        this.accessEnc = hopper.getEncodingManager().getBooleanEncodedValue(VehicleAccess.key((String)"car"));
        this.avSpeedEnc = hopper.getEncodingManager().getDecimalEncodedValue(VehicleSpeed.key((String)"car"));
        this.useCH = useCH;
        this.logger.info("locations:" + this.graph.getNodes() + ", debug:" + debug);
        this.mg = new GraphicsWrapper((Graph)this.graph);
        this.index = (LocationIndexTree)hopper.getLocationIndex();
        this.infoPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(Color.WHITE);
                Rectangle b = MiniGraphUI.this.infoPanel.getBounds();
                g.fillRect(0, 0, b.width, b.height);
                g.setColor(Color.BLUE);
                g.drawString(MiniGraphUI.this.latLon, 40, 20);
                g.drawString("scale:" + MiniGraphUI.this.mg.getScaleX(), 40, 40);
                int w = MiniGraphUI.this.mainPanel.getBounds().width;
                int h = MiniGraphUI.this.mainPanel.getBounds().height;
                g.drawString(MiniGraphUI.this.mg.setBounds(0, w, 0, h).toLessPrecisionString(), 40, 60);
            }
        };
        this.mainPanel = new LayeredPanel();
        GHTBitSet bitset = new GHTBitSet(this.graph.getNodes());
        this.roadsLayer = new DefaultMapLayer((GHBitSet)bitset){
            final Random rand = new Random();
            final /* synthetic */ GHBitSet val$bitset;
            {
                this.val$bitset = gHBitSet;
            }

            @Override
            public void paintComponent(final Graphics2D g2) {
                this.clearGraphics(g2);
                Rectangle d = this.getBounds();
                BBox b = MiniGraphUI.this.mg.setBounds(0, d.width, 0, d.height);
                if (MiniGraphUI.this.fastPaint) {
                    this.rand.setSeed(0L);
                    this.val$bitset.clear();
                }
                g2.setColor(Color.black);
                Color[] speedColors = MiniGraphUI.this.generateColors(15);
                AllEdgesIterator edge = MiniGraphUI.this.graph.getAllEdges();
                while (edge.next()) {
                    double speed;
                    if (MiniGraphUI.this.fastPaint && this.rand.nextInt(30) > 1) continue;
                    int nodeIndex = edge.getBaseNode();
                    double lat = MiniGraphUI.this.na.getLat(nodeIndex);
                    double lon = MiniGraphUI.this.na.getLon(nodeIndex);
                    int nodeId = edge.getAdjNode();
                    double lat2 = MiniGraphUI.this.na.getLat(nodeId);
                    double lon2 = MiniGraphUI.this.na.getLon(nodeId);
                    if (!b.contains(lat, lon) && !b.contains(lat2, lon2)) continue;
                    int sum = nodeIndex + nodeId;
                    if (MiniGraphUI.this.fastPaint) {
                        if (this.val$bitset.contains(sum)) continue;
                        this.val$bitset.add(sum);
                    }
                    Color color = (speed = edge.get(MiniGraphUI.this.avSpeedEnc)) >= 120.0 ? speedColors[12] : (speed >= 100.0 ? speedColors[10] : (speed >= 80.0 ? speedColors[8] : (speed >= 60.0 ? speedColors[6] : (speed >= 50.0 ? speedColors[5] : (speed >= 40.0 ? speedColors[4] : (speed >= 30.0 ? Color.GRAY : Color.LIGHT_GRAY))))));
                    g2.setColor(color);
                    boolean fwd = edge.get(MiniGraphUI.this.accessEnc);
                    boolean bwd = edge.getReverse(MiniGraphUI.this.accessEnc);
                    float width = speed > 90.0 ? 1.0f : 0.8f;
                    PointList pl = edge.fetchWayGeometry(FetchMode.ALL);
                    for (int i = 1; i < pl.size(); ++i) {
                        if (fwd && !bwd) {
                            MiniGraphUI.this.mg.plotDirectedEdge(g2, pl.getLat(i - 1), pl.getLon(i - 1), pl.getLat(i), pl.getLon(i), width);
                            continue;
                        }
                        MiniGraphUI.this.mg.plotEdge(g2, pl.getLat(i - 1), pl.getLon(i - 1), pl.getLat(i), pl.getLon(i), width);
                    }
                }
                if (MiniGraphUI.this.showQuadTree) {
                    MiniGraphUI.this.index.query(MiniGraphUI.this.graph.getBounds(), new LocationIndex.Visitor(){

                        public boolean isTileInfo() {
                            return true;
                        }

                        public void onTile(BBox bbox, int depth) {
                            int width = Math.max(1, Math.min(4, 4 - depth));
                            g2.setColor(Color.GRAY);
                            MiniGraphUI.this.mg.plotEdge(g2, bbox.minLat, bbox.minLon, bbox.minLat, bbox.maxLon, width);
                            MiniGraphUI.this.mg.plotEdge(g2, bbox.minLat, bbox.maxLon, bbox.maxLat, bbox.maxLon, width);
                            MiniGraphUI.this.mg.plotEdge(g2, bbox.maxLat, bbox.maxLon, bbox.maxLat, bbox.minLon, width);
                            MiniGraphUI.this.mg.plotEdge(g2, bbox.maxLat, bbox.minLon, bbox.minLat, bbox.minLon, width);
                        }

                        public void onEdge(int edgeId) {
                        }
                    });
                }
                g2.setColor(Color.WHITE);
                g2.fillRect(0, 0, 1000, 20);
                for (int i = 4; i < speedColors.length; ++i) {
                    g2.setColor(speedColors[i]);
                    g2.drawString("" + i * 10, i * 30 - 100, 10);
                }
                g2.setColor(Color.BLACK);
            }
        };
        this.mainPanel.addLayer(this.roadsLayer);
        this.pathLayer = new DefaultMapLayer(){

            @Override
            public void paintComponent(Graphics2D g2) {
                if (MiniGraphUI.this.qGraph == null) {
                    return;
                }
                this.makeTransparent(g2);
                RoutingAlgorithm algo = MiniGraphUI.this.createAlgo(hopper, MiniGraphUI.this.qGraph);
                if (algo instanceof DebugAlgo) {
                    ((DebugAlgo)algo).setGraphics2D(g2);
                }
                StopWatch sw = new StopWatch().start();
                MiniGraphUI.this.logger.info("start searching with " + String.valueOf(algo) + " from:" + String.valueOf(MiniGraphUI.this.fromRes) + " to:" + String.valueOf(MiniGraphUI.this.toRes));
                Color red = Color.red.brighter();
                g2.setColor(red);
                MiniGraphUI.this.mg.plotNode(g2, MiniGraphUI.this.qGraph.getNodeAccess(), MiniGraphUI.this.fromRes.getClosestNode(), red, 10, "");
                MiniGraphUI.this.mg.plotNode(g2, MiniGraphUI.this.qGraph.getNodeAccess(), MiniGraphUI.this.toRes.getClosestNode(), red, 10, "");
                g2.setColor(Color.blue.brighter().brighter());
                List paths = algo.calcPaths(MiniGraphUI.this.fromRes.getClosestNode(), MiniGraphUI.this.toRes.getClosestNode());
                sw.stop();
                if (paths.isEmpty() || !((Path)paths.get(0)).isFound()) {
                    MiniGraphUI.this.logger.warn("path not found! direction not valid?");
                    return;
                }
                Path best = (Path)paths.get(0);
                MiniGraphUI.this.logger.info("found path in " + sw.getSeconds() + "s with nodes:" + best.calcNodes().size() + ", millis: " + best.getTime() + ", visited nodes:" + algo.getVisitedNodes());
                g2.setColor(red);
                for (Path p : paths) {
                    MiniGraphUI.this.plotPath(p, g2, 3);
                }
            }
        };
        this.mainPanel.addLayer(this.pathLayer);
        if (debug) {
            RepaintManager repaintManager = RepaintManager.currentManager(this.mainPanel);
            repaintManager.setDoubleBufferingEnabled(false);
            this.mainPanel.setBuffering(false);
        }
    }

    private RoutingAlgorithm createAlgo(GraphHopper hopper, QueryGraph qGraph) {
        Profile profile = (Profile)hopper.getProfiles().iterator().next();
        if (this.useCH) {
            RoutingCHGraph chGraph = (RoutingCHGraph)hopper.getCHGraphs().get(profile.getName());
            this.logger.info("CH algo, profile: " + profile.getName());
            QueryRoutingCHGraph queryRoutingCHGraph = new QueryRoutingCHGraph(chGraph, qGraph);
            return new CHDebugAlgo((RoutingCHGraph)queryRoutingCHGraph, this.mg);
        }
        LandmarkStorage landmarks = (LandmarkStorage)hopper.getLandmarks().get(profile.getName());
        RoutingAlgorithmFactory algoFactory = (g, w, opts) -> {
            RoutingAlgorithm algo = new LMRoutingAlgorithmFactory(landmarks).createAlgo(g, w, opts);
            if (algo instanceof AStarBidirection) {
                return new DebugAStarBi(g, w, opts.getTraversalMode(), this.mg).setApproximation(((AStarBidirection)algo).getApproximation());
            }
            if (algo instanceof AStar) {
                return new DebugAStar(g, w, opts.getTraversalMode(), this.mg);
            }
            if (algo instanceof DijkstraBidirectionRef) {
                return new DebugDijkstraBidirection(g, w, opts.getTraversalMode(), this.mg);
            }
            if (algo instanceof Dijkstra) {
                return new DebugDijkstraSimple(g, w, opts.getTraversalMode(), this.mg);
            }
            return algo;
        };
        AlgorithmOptions algoOpts = new AlgorithmOptions().setAlgorithm("astarbi").setTraversalMode(TraversalMode.EDGE_BASED);
        return algoFactory.createAlgo((Graph)qGraph, hopper.createWeighting(profile, new PMap()), algoOpts);
    }

    public Color[] generateColors(int n) {
        Color[] cols = new Color[n];
        for (int i = 0; i < n; ++i) {
            cols[i] = Color.getHSBColor((float)i / (float)n, 0.85f, 1.0f);
        }
        return cols;
    }

    void plotNodeName(Graphics2D g2, int node) {
        double lat = this.na.getLat(node);
        double lon = this.na.getLon(node);
        this.mg.plotText(g2, lat, lon, "" + node);
    }

    private Path plotPath(Path tmpPath, Graphics2D g2, int w) {
        if (!tmpPath.isFound()) {
            this.logger.info("cannot plot path as not found: " + String.valueOf(tmpPath));
            return tmpPath;
        }
        double prevLat = Double.NaN;
        double prevLon = Double.NaN;
        boolean plotNodes = false;
        IntIndexedContainer nodes = tmpPath.calcNodes();
        if (plotNodes) {
            for (int i = 0; i < nodes.size(); ++i) {
                this.plotNodeName(g2, nodes.get(i));
            }
        }
        PointList list = tmpPath.calcPoints();
        for (int i = 0; i < list.size(); ++i) {
            double lat = list.getLat(i);
            double lon = list.getLon(i);
            if (!Double.isNaN(prevLat)) {
                this.mg.plotEdge(g2, prevLat, prevLon, lat, lon, w);
            } else {
                this.mg.plot(g2, lat, lon, w);
            }
            prevLat = lat;
            prevLon = lon;
        }
        this.logger.info("dist:" + tmpPath.getDistance() + ", path points(" + list.size() + ")");
        return tmpPath;
    }

    public void visualize() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int frameHeight = 800;
                    int frameWidth = 1200;
                    JFrame frame = new JFrame("GraphHopper UI - Small&Ugly ;)");
                    frame.setLayout(new BorderLayout());
                    frame.add((Component)MiniGraphUI.this.mainPanel, "Center");
                    frame.add((Component)MiniGraphUI.this.infoPanel, "North");
                    MiniGraphUI.this.infoPanel.setPreferredSize(new Dimension(300, 100));
                    MiniGraphUI.this.mainPanel.addMouseWheelListener(new MouseWheelListener(){

                        @Override
                        public void mouseWheelMoved(MouseWheelEvent e) {
                            MiniGraphUI.this.mg.scale(e.getX(), e.getY(), e.getWheelRotation() < 0);
                            MiniGraphUI.this.repaintRoads();
                        }
                    });
                    MouseAdapter ml = new MouseAdapter(){
                        double fromLat;
                        double fromLon;
                        boolean fromDone = false;
                        boolean dragging = false;

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (!this.fromDone) {
                                this.fromLat = MiniGraphUI.this.mg.getLat(e.getY());
                                this.fromLon = MiniGraphUI.this.mg.getLon(e.getX());
                            } else {
                                double toLat = MiniGraphUI.this.mg.getLat(e.getY());
                                double toLon = MiniGraphUI.this.mg.getLon(e.getX());
                                StopWatch sw = new StopWatch().start();
                                MiniGraphUI.this.logger.info("start searching from " + this.fromLat + "," + this.fromLon + " to " + toLat + "," + toLon);
                                MiniGraphUI.this.fromRes = MiniGraphUI.this.index.findClosest(this.fromLat, this.fromLon, EdgeFilter.ALL_EDGES);
                                MiniGraphUI.this.toRes = MiniGraphUI.this.index.findClosest(toLat, toLon, EdgeFilter.ALL_EDGES);
                                if (MiniGraphUI.this.fromRes.isValid() && MiniGraphUI.this.toRes.isValid()) {
                                    MiniGraphUI.this.qGraph = QueryGraph.create((BaseGraph)MiniGraphUI.this.graph, (Snap)MiniGraphUI.this.fromRes, (Snap)MiniGraphUI.this.toRes);
                                    MiniGraphUI.this.mg.setNodeAccess((Graph)MiniGraphUI.this.qGraph);
                                    MiniGraphUI.this.logger.info("found ids " + String.valueOf(MiniGraphUI.this.fromRes) + " -> " + String.valueOf(MiniGraphUI.this.toRes) + " in " + sw.stop().getSeconds() + "s");
                                }
                                MiniGraphUI.this.repaintPaths();
                            }
                            this.fromDone = !this.fromDone;
                        }

                        @Override
                        public void mouseDragged(MouseEvent e) {
                            this.dragging = true;
                            MiniGraphUI.this.fastPaint = true;
                            this.update(e);
                            MiniGraphUI.this.updateLatLon(e);
                        }

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            if (this.dragging) {
                                this.dragging = false;
                                MiniGraphUI.this.fastPaint = false;
                                this.update(e);
                            }
                        }

                        public void update(MouseEvent e) {
                            MiniGraphUI.this.mg.setNewOffset(e.getX() - MiniGraphUI.this.currentPosX, e.getY() - MiniGraphUI.this.currentPosY);
                            MiniGraphUI.this.repaintRoads();
                        }

                        @Override
                        public void mouseMoved(MouseEvent e) {
                            MiniGraphUI.this.updateLatLon(e);
                        }

                        @Override
                        public void mousePressed(MouseEvent e) {
                            MiniGraphUI.this.updateLatLon(e);
                        }
                    };
                    MiniGraphUI.this.mainPanel.addMouseListener(ml);
                    MiniGraphUI.this.mainPanel.addMouseMotionListener(ml);
                    frame.setDefaultCloseOperation(3);
                    frame.setSize(frameWidth + 10, frameHeight + 30);
                    frame.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void updateLatLon(MouseEvent e) {
        this.latLon = this.mg.getLat(e.getY()) + "," + this.mg.getLon(e.getX());
        this.infoPanel.repaint();
        this.currentPosX = e.getX();
        this.currentPosY = e.getY();
    }

    void repaintPaths() {
        this.pathLayer.repaint();
        this.mainPanel.repaint();
    }

    void repaintRoads() {
        StopWatch sw = new StopWatch().start();
        this.pathLayer.repaint();
        this.roadsLayer.repaint();
        this.mainPanel.repaint();
        this.logger.info("roads painting took " + sw.stop().getSeconds() + " sec");
    }

    private static class CHDebugAlgo
    extends DijkstraBidirectionCH
    implements DebugAlgo {
        private final GraphicsWrapper mg;
        private Graphics2D g2;

        public CHDebugAlgo(RoutingCHGraph graph, GraphicsWrapper mg) {
            super(graph);
            this.mg = mg;
        }

        @Override
        public void setGraphics2D(Graphics2D g2) {
            this.g2 = g2;
        }

        public void updateBestPath(double edgeWeight, SPTEntry entry, int origEdgeId, int traversalId, boolean reverse) {
            if (this.g2 != null) {
                this.mg.plotNode(this.g2, traversalId, Color.YELLOW, 6);
            }
            super.updateBestPath(edgeWeight, entry, origEdgeId, traversalId, reverse);
        }
    }
}

