/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.JsonFeatureCollection;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class CustomModelAreasDeserializer
extends JsonDeserializer<JsonFeatureCollection> {
    public JsonFeatureCollection deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Map<String, JsonFeature> index;
        JsonNode treeNode = (JsonNode)jp.readValueAsTree();
        JsonFeatureCollection collection = new JsonFeatureCollection();
        if (treeNode.has("type") && "FeatureCollection".equals(treeNode.get("type").asText())) {
            for (JsonNode node : treeNode.get("features")) {
                JsonFeature feature = (JsonFeature)jp.getCodec().treeToValue((TreeNode)node, JsonFeature.class);
                if (Helper.isEmpty(feature.getId())) {
                    throw new IllegalArgumentException("The JsonFeature for the CustomModel area must contain \"id\"");
                }
                collection.getFeatures().add(feature);
            }
        } else {
            Iterator fields = treeNode.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonFeature feature = (JsonFeature)jp.getCodec().treeToValue((TreeNode)field.getValue(), JsonFeature.class);
                feature.setId((String)field.getKey());
                collection.getFeatures().add(feature);
            }
        }
        if ((index = CustomModel.getAreasAsMap(collection)).size() != collection.getFeatures().size()) {
            throw new IllegalArgumentException("JsonFeatureCollection contains duplicate area");
        }
        return collection;
    }
}

