/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.graphhopper.util.details.PathDetail;
import java.io.IOException;
import java.util.Map;

public class PathDetailSerializer
extends JsonSerializer<PathDetail> {
    public void serialize(PathDetail value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartArray();
        gen.writeNumber(value.getFirst());
        gen.writeNumber(value.getLast());
        if (value.getValue() instanceof Double) {
            gen.writeNumber(((Double)value.getValue()).doubleValue());
        } else if (value.getValue() instanceof Long) {
            gen.writeNumber(((Long)value.getValue()).longValue());
        } else if (value.getValue() instanceof Integer) {
            gen.writeNumber(((Integer)value.getValue()).intValue());
        } else if (value.getValue() instanceof Boolean) {
            gen.writeBoolean(((Boolean)value.getValue()).booleanValue());
        } else if (value.getValue() instanceof String) {
            gen.writeString((String)value.getValue());
        } else if (value.getValue() instanceof Map) {
            gen.writeObject(value.getValue());
        } else if (value.getValue() == null) {
            gen.writeNull();
        } else {
            throw new JsonGenerationException("Unsupported type for PathDetail.value" + String.valueOf(value.getValue().getClass()), gen);
        }
        gen.writeEndArray();
    }
}

