/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.ResponsePath;
import com.graphhopper.util.FinishInstruction;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.ViaInstruction;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.exceptions.DetailedIllegalArgumentException;
import com.graphhopper.util.exceptions.DetailedRuntimeException;
import com.graphhopper.util.exceptions.MaximumNodesExceededException;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.exceptions.PointOutOfBoundsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.LineString;

public class ResponsePathDeserializerHelper {
    public static ResponsePath createResponsePath(ObjectMapper objectMapper, JsonNode path, boolean hasElevation, boolean turnDescription) {
        ResponsePath responsePath = new ResponsePath();
        responsePath.addErrors(ResponsePathDeserializerHelper.readErrors(objectMapper, path));
        if (responsePath.hasErrors()) {
            return responsePath;
        }
        double multiplier = 100000.0;
        if (path.has("points_encoded") && path.get("points_encoded").asBoolean() && path.has("points_encoded_multiplier")) {
            multiplier = path.get("points_encoded_multiplier").asDouble();
        }
        if (path.has("snapped_waypoints")) {
            JsonNode snappedWaypoints = path.get("snapped_waypoints");
            PointList snappedPoints = ResponsePathDeserializerHelper.deserializePointList(objectMapper, snappedWaypoints, hasElevation, multiplier);
            responsePath.setWaypoints(snappedPoints);
        }
        if (path.has("ascend")) {
            responsePath.setAscend(path.get("ascend").asDouble());
        }
        if (path.has("descend")) {
            responsePath.setDescend(path.get("descend").asDouble());
        }
        if (path.has("weight")) {
            responsePath.setRouteWeight(path.get("weight").asDouble());
        }
        if (path.has("description")) {
            JsonNode descriptionNode = path.get("description");
            if (descriptionNode.isArray()) {
                ArrayList<String> description = new ArrayList<String>(descriptionNode.size());
                for (JsonNode descNode : descriptionNode) {
                    description.add(descNode.asText());
                }
                responsePath.setDescription(description);
            } else {
                throw new IllegalStateException("Description has to be an array");
            }
        }
        if (path.has("points")) {
            PointList pointList = ResponsePathDeserializerHelper.deserializePointList(objectMapper, path.get("points"), hasElevation, multiplier);
            responsePath.setPoints(pointList);
            if (path.has("instructions")) {
                JsonNode instrArr = path.get("instructions");
                InstructionList il = new InstructionList(null);
                int viaCount = 1;
                for (JsonNode jsonObj : instrArr) {
                    Instruction instr;
                    double instDist = jsonObj.get("distance").asDouble();
                    String text = turnDescription ? jsonObj.get("text").asText() : jsonObj.get("street_name").asText();
                    long instTime = jsonObj.get("time").asLong();
                    int sign = jsonObj.get("sign").asInt();
                    JsonNode iv = jsonObj.get("interval");
                    int from = iv.get(0).asInt();
                    int to = iv.get(1).asInt();
                    PointList instPL = new PointList(to - from, hasElevation);
                    for (int j = from; j <= to; ++j) {
                        instPL.add(pointList, j);
                    }
                    if (sign == 6 || sign == -6) {
                        RoundaboutInstruction ri = new RoundaboutInstruction(sign, text, instPL);
                        if (jsonObj.has("exit_number")) {
                            ri.setExitNumber(jsonObj.get("exit_number").asInt());
                        }
                        if (jsonObj.has("exited") && jsonObj.get("exited").asBoolean()) {
                            ri.setExited();
                        }
                        if (jsonObj.has("turn_angle")) {
                            double angle = jsonObj.get("turn_angle").asDouble();
                            ri.setDirOfRotation(angle);
                            ri.setRadian((angle < 0.0 ? -Math.PI : Math.PI) - angle);
                        }
                        instr = ri;
                    } else if (sign == 5) {
                        ViaInstruction tmpInstr = new ViaInstruction(text, instPL);
                        tmpInstr.setViaCount(viaCount);
                        ++viaCount;
                        instr = tmpInstr;
                    } else if (sign == 4) {
                        instr = new FinishInstruction(text, instPL, 0);
                    } else {
                        instr = new Instruction(sign, text, instPL);
                        if (sign == 0 && jsonObj.has("heading")) {
                            instr.setExtraInfo("heading", jsonObj.get("heading").asDouble());
                        }
                    }
                    if (turnDescription) {
                        instr.setUseRawName();
                    }
                    instr.setDistance(instDist).setTime(instTime);
                    il.add(instr);
                }
                responsePath.setInstructions(il);
            }
            if (path.has("details")) {
                JsonNode details = path.get("details");
                HashMap<String, List<PathDetail>> pathDetails = new HashMap<String, List<PathDetail>>(details.size());
                Iterator detailIterator = details.fields();
                while (detailIterator.hasNext()) {
                    Map.Entry detailEntry = (Map.Entry)detailIterator.next();
                    ArrayList<PathDetail> pathDetailList = new ArrayList<PathDetail>();
                    for (JsonNode pathDetail : (JsonNode)detailEntry.getValue()) {
                        PathDetail pd = (PathDetail)objectMapper.convertValue((Object)pathDetail, PathDetail.class);
                        pathDetailList.add(pd);
                    }
                    pathDetails.put((String)detailEntry.getKey(), pathDetailList);
                }
                responsePath.addPathDetails(pathDetails);
            }
        }
        if (path.has("points_order")) {
            responsePath.setPointsOrder((List)objectMapper.convertValue((Object)path.get("points_order"), List.class));
        } else {
            ArrayList<Integer> list = new ArrayList<Integer>(responsePath.getWaypoints().size());
            for (int i = 0; i < responsePath.getWaypoints().size(); ++i) {
                list.add(i);
            }
            responsePath.setPointsOrder(list);
        }
        double distance = path.get("distance").asDouble();
        long time = path.get("time").asLong();
        responsePath.setDistance(distance).setTime(time);
        return responsePath;
    }

    private static PointList deserializePointList(ObjectMapper objectMapper, JsonNode jsonNode, boolean hasElevation, double multiplier) {
        PointList snappedPoints;
        if (jsonNode.isTextual()) {
            snappedPoints = ResponsePathDeserializerHelper.decodePolyline(jsonNode.asText(), Math.max(10, jsonNode.asText().length() / 4), hasElevation, multiplier);
        } else {
            LineString lineString = (LineString)objectMapper.convertValue((Object)jsonNode, LineString.class);
            snappedPoints = PointList.fromLineString(lineString);
        }
        return snappedPoints;
    }

    public static PointList decodePolyline(String encoded, int initCap, boolean is3D, double multiplier) {
        if (multiplier < 1.0) {
            throw new IllegalArgumentException("multiplier cannot be smaller than 1 but was " + multiplier + " for polyline " + encoded);
        }
        PointList poly = new PointList(initCap, is3D);
        int index = 0;
        int len = encoded.length();
        int lat = 0;
        int lng = 0;
        int ele = 0;
        while (index < len) {
            int b;
            int shift = 0;
            int result = 0;
            do {
                b = encoded.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int deltaLatitude = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            lat += deltaLatitude;
            shift = 0;
            result = 0;
            do {
                b = encoded.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int deltaLongitude = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            lng += deltaLongitude;
            if (is3D) {
                shift = 0;
                result = 0;
                do {
                    b = encoded.charAt(index++) - 63;
                    result |= (b & 0x1F) << shift;
                    shift += 5;
                } while (b >= 32);
                int deltaElevation = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
                poly.add((double)lat / multiplier, (double)lng / multiplier, (double)(ele += deltaElevation) / 100.0);
                continue;
            }
            poly.add((double)lat / multiplier, (double)lng / multiplier);
        }
        return poly;
    }

    public static List<Throwable> readErrors(ObjectMapper objectMapper, JsonNode json) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        if (json.has("message")) {
            if (!json.has("hints")) {
                errors.add(new RuntimeException(json.get("message").asText()));
                return errors;
            }
        } else {
            return errors;
        }
        JsonNode errorJson = json.get("hints");
        for (JsonNode error : errorJson) {
            int pointIndex;
            String exClass = "";
            if (error.has("details")) {
                exClass = error.get("details").asText();
            }
            String exMessage = error.get("message").asText();
            if (exClass.equals(UnsupportedOperationException.class.getName())) {
                errors.add(new UnsupportedOperationException(exMessage));
                continue;
            }
            if (exClass.equals(IllegalStateException.class.getName())) {
                errors.add(new IllegalStateException(exMessage));
                continue;
            }
            if (exClass.equals(RuntimeException.class.getName())) {
                errors.add(new DetailedRuntimeException(exMessage, ResponsePathDeserializerHelper.toMap(objectMapper, error)));
                continue;
            }
            if (exClass.equals(IllegalArgumentException.class.getName())) {
                errors.add(new DetailedIllegalArgumentException(exMessage, ResponsePathDeserializerHelper.toMap(objectMapper, error)));
                continue;
            }
            if (exClass.equals(ConnectionNotFoundException.class.getName())) {
                errors.add(new ConnectionNotFoundException(exMessage, ResponsePathDeserializerHelper.toMap(objectMapper, error)));
                continue;
            }
            if (exClass.equals(MaximumNodesExceededException.class.getName())) {
                int maxVisitedNodes = error.get("max_visited_nodes").asInt();
                errors.add(new MaximumNodesExceededException(exMessage, maxVisitedNodes));
                continue;
            }
            if (exClass.equals(PointNotFoundException.class.getName())) {
                pointIndex = error.get("point_index").asInt();
                errors.add(new PointNotFoundException(exMessage, pointIndex));
                continue;
            }
            if (exClass.equals(PointOutOfBoundsException.class.getName())) {
                pointIndex = error.get("point_index").asInt();
                errors.add(new PointOutOfBoundsException(exMessage, pointIndex));
                continue;
            }
            if (exClass.isEmpty()) {
                errors.add(new DetailedRuntimeException(exMessage, ResponsePathDeserializerHelper.toMap(objectMapper, error)));
                continue;
            }
            errors.add(new DetailedRuntimeException(exClass + " " + exMessage, ResponsePathDeserializerHelper.toMap(objectMapper, error)));
        }
        if (json.has("message") && errors.isEmpty()) {
            errors.add(new RuntimeException(json.get("message").asText()));
        }
        return errors;
    }

    private static Map<String, Object> toMap(ObjectMapper objectMapper, JsonNode object) {
        return (Map)objectMapper.convertValue((Object)object, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

