/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import java.util.HashMap;
import java.util.Map;

public class Instruction {
    public static final int UNKNOWN = -99;
    public static final int U_TURN_UNKNOWN = -98;
    public static final int U_TURN_LEFT = -8;
    public static final int KEEP_LEFT = -7;
    public static final int LEAVE_ROUNDABOUT = -6;
    public static final int TURN_SHARP_LEFT = -3;
    public static final int TURN_LEFT = -2;
    public static final int TURN_SLIGHT_LEFT = -1;
    public static final int CONTINUE_ON_STREET = 0;
    public static final int TURN_SLIGHT_RIGHT = 1;
    public static final int TURN_RIGHT = 2;
    public static final int TURN_SHARP_RIGHT = 3;
    public static final int FINISH = 4;
    public static final int REACHED_VIA = 5;
    public static final int USE_ROUNDABOUT = 6;
    public static final int IGNORE = Integer.MIN_VALUE;
    public static final int KEEP_RIGHT = 7;
    public static final int U_TURN_RIGHT = 8;
    public static final int FERRY = 9;
    public static final int PT_START_TRIP = 101;
    public static final int PT_TRANSFER = 102;
    public static final int PT_END_TRIP = 103;
    protected PointList points;
    protected boolean rawName;
    protected int sign;
    protected String name = "";
    protected double distance;
    protected long time;
    protected Map<String, Object> extraInfo = new HashMap<String, Object>(3);

    public Instruction(int sign, String name, PointList pl) {
        this.sign = sign;
        if (name != null) {
            this.name = name;
        }
        this.points = pl;
    }

    public void setUseRawName() {
        this.rawName = true;
    }

    public int getSign() {
        return this.sign;
    }

    public void setSign(int sign) {
        this.sign = sign;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    String _getName() {
        return this.getName().isEmpty() && this.extraInfo.get("street_ref") instanceof String ? (String)this.extraInfo.get("street_ref") : this.getName();
    }

    public Map<String, Object> getExtraInfoJSON() {
        return this.extraInfo;
    }

    public void setExtraInfo(String key, Object value) {
        if (value != null && key != null) {
            this.extraInfo.put(key, value);
        }
    }

    public double getDistance() {
        return this.distance;
    }

    public Instruction setDistance(double distance) {
        this.distance = distance;
        return this;
    }

    public long getTime() {
        return this.time;
    }

    public Instruction setTime(long time) {
        this.time = time;
        return this;
    }

    public PointList getPoints() {
        return this.points;
    }

    public void setPoints(PointList points) {
        this.points = points;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.sign).append(',');
        sb.append(this.name).append(',');
        sb.append(this.distance).append(',');
        sb.append(this.time);
        sb.append(')');
        return sb.toString();
    }

    public int getLength() {
        return this.points.size();
    }

    public String getTurnDescription(Translation tr) {
        String str;
        if (this.rawName) {
            return this.getName();
        }
        String streetName = this._getName();
        String ferryStr = (String)this.extraInfo.get("ferry");
        int sign = this.getSign();
        if (sign == 0) {
            str = Helper.isEmpty(streetName) ? tr.tr("continue", new Object[0]) : tr.tr("continue_onto", streetName);
        } else if (sign == 9) {
            if (ferryStr == null) {
                throw new RuntimeException("no ferry information provided but sign is FERRY");
            }
            str = tr.tr(ferryStr, streetName);
        } else if (sign == 101) {
            str = tr.tr("pt_start_trip", streetName);
        } else if (sign == 102) {
            str = tr.tr("pt_transfer_to", streetName);
        } else if (sign == 103) {
            str = tr.tr("pt_end_trip", streetName);
        } else {
            String dir = null;
            switch (sign) {
                case -98: {
                    dir = tr.tr("u_turn", new Object[0]);
                    break;
                }
                case -8: {
                    dir = tr.tr("u_turn", new Object[0]);
                    break;
                }
                case 8: {
                    dir = tr.tr("u_turn", new Object[0]);
                    break;
                }
                case -7: {
                    dir = tr.tr("keep_left", new Object[0]);
                    break;
                }
                case -3: {
                    dir = tr.tr("turn_sharp_left", new Object[0]);
                    break;
                }
                case -2: {
                    dir = tr.tr("turn_left", new Object[0]);
                    break;
                }
                case -1: {
                    dir = tr.tr("turn_slight_left", new Object[0]);
                    break;
                }
                case 1: {
                    dir = tr.tr("turn_slight_right", new Object[0]);
                    break;
                }
                case 2: {
                    dir = tr.tr("turn_right", new Object[0]);
                    break;
                }
                case 3: {
                    dir = tr.tr("turn_sharp_right", new Object[0]);
                    break;
                }
                case 7: {
                    dir = tr.tr("keep_right", new Object[0]);
                }
            }
            if (dir == null) {
                str = tr.tr("unknown", sign);
            } else {
                String string = str = streetName.isEmpty() ? dir : tr.tr("turn_onto", dir, streetName);
            }
        }
        if ("leave_ferry".equals(ferryStr)) {
            return tr.tr(ferryStr, str);
        }
        String dest = (String)this.extraInfo.get("street_destination");
        String destRef = (String)this.extraInfo.get("street_destination_ref");
        if (dest != null) {
            if (destRef != null) {
                return tr.tr("toward_destination_with_ref", str, destRef, dest);
            }
            return tr.tr("toward_destination", str, dest);
        }
        if (destRef != null) {
            return tr.tr("toward_destination_ref_only", str, destRef);
        }
        return str;
    }
}

