/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PMap {
    private final LinkedHashMap<String, Object> map;

    public PMap() {
        this(5);
    }

    public PMap(int capacity) {
        this.map = new LinkedHashMap(capacity);
    }

    public PMap(Map<String, Object> map) {
        this.map = new LinkedHashMap<String, Object>(map);
    }

    public PMap(PMap map) {
        this.map = new LinkedHashMap<String, Object>(map.map);
    }

    public PMap(String propertiesString) {
        this.map = new LinkedHashMap();
        for (String s : propertiesString.split("\\|")) {
            int index = (s = s.trim()).indexOf("=");
            if (index < 0) continue;
            this.putObject(Helper.camelCaseToUnderScore(s.substring(0, index)), Helper.toObject(s.substring(index + 1)));
        }
    }

    public static PMap read(String[] args) {
        PMap map = new PMap();
        for (String arg : args) {
            int index = arg.indexOf("=");
            if (index <= 0) continue;
            String key = arg.substring(0, index);
            if (key.startsWith("-")) {
                key = key.substring(1);
            }
            if (key.startsWith("-")) {
                key = key.substring(1);
            }
            String value = arg.substring(index + 1);
            Object old = map.map.put(Helper.camelCaseToUnderScore(key), Helper.toObject(value));
            if (old == null) continue;
            throw new IllegalArgumentException("Pair '" + Helper.camelCaseToUnderScore(key) + "'='" + value + "' not possible to add to the PMap-object as the key already exists with '" + String.valueOf(old) + "'");
        }
        return map;
    }

    public PMap putAll(PMap map) {
        this.map.putAll(map.map);
        return this;
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public boolean getBool(String key, boolean _default) {
        Object object = this.map.get(key);
        return object instanceof Boolean ? (Boolean)object : _default;
    }

    public int getInt(String key, int _default) {
        Object object = this.map.get(key);
        return object instanceof Number ? ((Number)object).intValue() : _default;
    }

    public long getLong(String key, long _default) {
        Object object = this.map.get(key);
        return object instanceof Number ? ((Number)object).longValue() : _default;
    }

    public float getFloat(String key, float _default) {
        Object object = this.map.get(key);
        return object instanceof Number ? ((Number)object).floatValue() : _default;
    }

    public double getDouble(String key, double _default) {
        Object object = this.map.get(key);
        return object instanceof Number ? ((Number)object).doubleValue() : _default;
    }

    public String getString(String key, String _default) {
        Object object = this.map.get(key);
        return object instanceof String ? (String)object : _default;
    }

    public <T> T getObject(String key, T _default) {
        Object object = this.map.get(key);
        return (T)(object == null ? _default : object);
    }

    public PMap putObject(String key, Object object) {
        this.map.put(key, object);
        return this;
    }

    public static Set<String> toSet(String value) {
        return Arrays.stream(value.split(";")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    public Map<String, Object> toMap() {
        return new LinkedHashMap<String, Object>(this.map);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.map.toString();
    }
}

