/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TurnCostsConfig {
    public static final int INFINITE_U_TURN_COSTS = -1;
    private int uTurnCosts = -1;
    private List<String> vehicleTypes;
    private boolean allowTurnPenaltyInRequest;
    private boolean enableUTurnTimes;
    private static final Set<String> ALL_SUPPORTED = Set.of("agricultural", "atv", "auto_rickshaw", "bdouble", "bicycle", "bus", "caravan", "carpool", "coach", "delivery", "destination", "emergency", "foot", "golf_cart", "goods", "hazmat", "hgv", "hgv:trailer", "hov", "minibus", "mofa", "moped", "motorcar", "motorcycle", "motor_vehicle", "motorhome", "nev", "ohv", "psv", "residents", "share_taxi", "small_electric_vehicle", "speed_pedelec", "train", "light_rail", "tram", "subway", "taxi", "trailer", "tourist_bus");

    public static TurnCostsConfig car() {
        return new TurnCostsConfig(List.of("motorcar", "motor_vehicle"));
    }

    public static TurnCostsConfig bike() {
        return new TurnCostsConfig(List.of("bicycle"));
    }

    public TurnCostsConfig() {
    }

    public TurnCostsConfig(TurnCostsConfig copy) {
        this.uTurnCosts = copy.uTurnCosts;
        if (copy.vehicleTypes != null) {
            this.vehicleTypes = new ArrayList<String>(copy.vehicleTypes);
        }
        this.enableUTurnTimes = copy.enableUTurnTimes;
    }

    public TurnCostsConfig(List<String> vehicleTypes) {
        this.vehicleTypes = this.check(vehicleTypes);
    }

    public TurnCostsConfig(List<String> vehicleTypes, int uTurnCost) {
        this.vehicleTypes = this.check(vehicleTypes);
        this.uTurnCosts = uTurnCost;
    }

    List<String> check(List<String> restrictions) {
        if (restrictions == null || restrictions.isEmpty()) {
            throw new IllegalArgumentException("turn_costs cannot have empty vehicle_types");
        }
        for (String r : restrictions) {
            if (ALL_SUPPORTED.contains(r)) continue;
            throw new IllegalArgumentException("Currently we do not support the restriction: " + r);
        }
        return restrictions;
    }

    public TurnCostsConfig setVehicleTypes(List<String> vehicleTypes) {
        this.vehicleTypes = this.check(vehicleTypes);
        return this;
    }

    @JsonProperty(value="vehicle_types")
    public List<String> getVehicleTypes() {
        this.check(this.vehicleTypes);
        return this.vehicleTypes;
    }

    public TurnCostsConfig setUTurnCosts(int uTurnCosts) {
        this.uTurnCosts = uTurnCosts;
        return this;
    }

    @JsonProperty(value="allow_turn_penalty_in_request")
    public boolean isAllowTurnPenaltyInRequest() {
        return this.allowTurnPenaltyInRequest;
    }

    public TurnCostsConfig setAllowTurnPenaltyInRequest(boolean allowTurnPenaltyInRequest) {
        this.allowTurnPenaltyInRequest = allowTurnPenaltyInRequest;
        return this;
    }

    @JsonProperty(value="u_turn_costs")
    public int getUTurnCosts() {
        return this.uTurnCosts;
    }

    @JsonProperty(value="enable_uturn_times")
    public boolean getEnableUTurnTimes() {
        return this.enableUTurnTimes;
    }

    public TurnCostsConfig setEnableUTurnTimes(boolean enableUTurnTimes) {
        this.enableUTurnTimes = enableUTurnTimes;
        return this;
    }

    public String toString() {
        return "uTurnCosts=" + this.uTurnCosts + ",enable_uturn_times=" + this.enableUTurnTimes + ", vehicleTypes=" + String.valueOf(this.vehicleTypes);
    }
}

