/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gpx;

import com.graphhopper.jackson.Gpx;
import com.graphhopper.matching.Observation;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.Translation;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;

public class GpxConversions {
    private static final AngleCalc AC = AngleCalc.ANGLE_CALC;
    private static final Pattern XML_ESCAPE_PATTERN = Pattern.compile("[\\<\\>]");

    static String simpleXMLEscape(String str) {
        return XML_ESCAPE_PATTERN.matcher(str.replace("&", "&amp;")).replaceAll("_");
    }

    public static List<GPXEntry> createGPXList(InstructionList instructions) {
        ArrayList<GPXEntry> gpxList = new ArrayList<GPXEntry>();
        long timeOffset = 0L;
        for (Instruction instruction : instructions) {
            int i = 0;
            for (GHPoint3D point : instruction.getPoints()) {
                GPXEntry gpxEntry = i == 0 ? new GPXEntry((GHPoint)point, timeOffset) : new GPXEntry((GHPoint)point);
                gpxList.add(gpxEntry);
                ++i;
            }
            timeOffset += instruction.getTime();
        }
        return gpxList;
    }

    private static void createWayPointBlock(StringBuilder output, Instruction instruction, DecimalFormat decimalFormat, Translation tr) {
        output.append("\n<wpt ");
        output.append("lat=\"").append(decimalFormat.format(instruction.getPoints().getLat(0)));
        output.append("\" lon=\"").append(decimalFormat.format(instruction.getPoints().getLon(0))).append("\">");
        String name = instruction.getName().isEmpty() ? instruction.getTurnDescription(tr) : instruction.getName();
        output.append(" <name>").append(GpxConversions.simpleXMLEscape(name)).append("</name>");
        output.append("</wpt>");
    }

    public static String createGPX(InstructionList instructions, String trackName, long startTimeMillis, boolean includeElevation, boolean withRoute, boolean withTrack, boolean withWayPoints, String version, Translation tr) {
        DateFormat formatter = Helper.createFormatter();
        DecimalFormat decimalFormat = new DecimalFormat("#", DecimalFormatSymbols.getInstance(Locale.ROOT));
        decimalFormat.setMinimumFractionDigits(1);
        decimalFormat.setMaximumFractionDigits(6);
        decimalFormat.setMinimumIntegerDigits(1);
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><gpx xmlns=\"http://www.topografix.com/GPX/1/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" creator=\"Graphhopper version " + version + "\" version=\"1.1\" xmlns:gh=\"https://graphhopper.com/public/schema/gpx/1.1\">\n<metadata><copyright author=\"OpenStreetMap contributors\"/><link href=\"http://graphhopper.com\"><text>GraphHopper GPX</text></link><time>" + formatter.format(startTimeMillis) + "</time></metadata>";
        StringBuilder gpxOutput = new StringBuilder(header);
        if (!instructions.isEmpty()) {
            if (withWayPoints) {
                GpxConversions.createWayPointBlock(gpxOutput, instructions.get(0), decimalFormat, tr);
                for (Iterator currInstr : instructions) {
                    if (currInstr.getSign() != 5 && currInstr.getSign() != 4) continue;
                    GpxConversions.createWayPointBlock(gpxOutput, (Instruction)currInstr, decimalFormat, tr);
                }
            }
            if (withRoute) {
                gpxOutput.append("\n<rte>");
                Instruction nextInstr = null;
                for (Instruction currInstr : instructions) {
                    if (null != nextInstr) {
                        GpxConversions.createRteptBlock(gpxOutput, nextInstr, currInstr, decimalFormat, tr);
                    }
                    nextInstr = currInstr;
                }
                GpxConversions.createRteptBlock(gpxOutput, nextInstr, null, decimalFormat, tr);
                gpxOutput.append("\n</rte>");
            }
        }
        if (withTrack) {
            gpxOutput.append("\n<trk><name>").append(trackName).append("</name>");
            gpxOutput.append("<trkseg>");
            for (GPXEntry entry : GpxConversions.createGPXList(instructions)) {
                gpxOutput.append("\n<trkpt lat=\"").append(decimalFormat.format(entry.getPoint().getLat()));
                gpxOutput.append("\" lon=\"").append(decimalFormat.format(entry.getPoint().getLon())).append("\">");
                if (includeElevation) {
                    gpxOutput.append("<ele>").append(Helper.round2((double)((GHPoint3D)entry.getPoint()).getEle())).append("</ele>");
                }
                if (entry.getTime() != null) {
                    gpxOutput.append("<time>").append(formatter.format(startTimeMillis + entry.getTime())).append("</time>");
                }
                gpxOutput.append("</trkpt>");
            }
            gpxOutput.append("\n</trkseg>");
            gpxOutput.append("\n</trk>");
        }
        gpxOutput.append("\n</gpx>");
        return gpxOutput.toString();
    }

    private static void createRteptBlock(StringBuilder output, Instruction instruction, Instruction nextI, DecimalFormat decimalFormat, Translation tr) {
        double azimuth;
        output.append("\n<rtept lat=\"").append(decimalFormat.format(instruction.getPoints().getLat(0))).append("\" lon=\"").append(decimalFormat.format(instruction.getPoints().getLon(0))).append("\">");
        if (!instruction.getName().isEmpty()) {
            output.append("<desc>").append(GpxConversions.simpleXMLEscape(instruction.getTurnDescription(tr))).append("</desc>");
        }
        output.append("<extensions>");
        output.append("<gh:distance>").append(Helper.round((double)instruction.getDistance(), (int)1)).append("</gh:distance>");
        output.append("<gh:time>").append(instruction.getTime()).append("</gh:time>");
        String direction = GpxConversions.calcDirection(instruction, nextI);
        if (!direction.isEmpty()) {
            output.append("<gh:direction>").append(direction).append("</gh:direction>");
        }
        if (!Double.isNaN(azimuth = GpxConversions.calcAzimuth(instruction, nextI))) {
            output.append("<gh:azimuth>").append(Helper.round2((double)azimuth)).append("</gh:azimuth>");
        }
        if (instruction instanceof RoundaboutInstruction) {
            RoundaboutInstruction ri = (RoundaboutInstruction)instruction;
            output.append("<gh:exit_number>").append(ri.getExitNumber()).append("</gh:exit_number>");
        }
        output.append("<gh:sign>").append(instruction.getSign()).append("</gh:sign>");
        output.append("</extensions>");
        output.append("</rtept>");
    }

    public static String calcDirection(Instruction instruction, Instruction nextI) {
        double azimuth = GpxConversions.calcAzimuth(instruction, nextI);
        if (Double.isNaN(azimuth)) {
            return "";
        }
        return AC.azimuth2compassPoint(azimuth);
    }

    public static double calcAzimuth(Instruction instruction, Instruction nextI) {
        double nextLon;
        double nextLat;
        if (instruction.getPoints().size() >= 2) {
            nextLat = instruction.getPoints().getLat(1);
            nextLon = instruction.getPoints().getLon(1);
        } else if (nextI != null && instruction.getPoints().size() == 1) {
            nextLat = nextI.getPoints().getLat(0);
            nextLon = nextI.getPoints().getLon(0);
        } else {
            return Double.NaN;
        }
        double lat = instruction.getPoints().getLat(0);
        double lon = instruction.getPoints().getLon(0);
        return AC.calcAzimuth(lat, lon, nextLat, nextLon);
    }

    public static List<Observation> getEntries(Gpx.Trk trk) {
        ArrayList<Observation> gpxEntries = new ArrayList<Observation>();
        for (Gpx.Trkseg t : trk.trkseg) {
            for (Gpx.Trkpt trkpt : t.trkpt) {
                gpxEntries.add(new Observation((GHPoint)new GHPoint3D(trkpt.lat, trkpt.lon, trkpt.ele)));
            }
        }
        return gpxEntries;
    }

    public static class GPXEntry {
        private GHPoint point;
        private Long time;

        public GPXEntry(GHPoint p) {
            this.point = p;
        }

        public GPXEntry(GHPoint p, long time) {
            this.point = p;
            this.time = time;
        }

        public Long getTime() {
            return this.time;
        }

        public GHPoint getPoint() {
            return this.point;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GPXEntry gpxEntry = (GPXEntry)o;
            return Objects.equals(this.point, gpxEntry.point) && Objects.equals(this.time, gpxEntry.time);
        }

        public int hashCode() {
            return Objects.hash(this.point, this.time);
        }

        public String toString() {
            return "GPXEntry{point=" + String.valueOf(this.point) + ", time=" + this.time + "}";
        }
    }
}

